/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import math.geom2d.Box2D;
import math.geom2d.circulinear.CirculinearBoundary2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.CirculinearContour2D;
import math.geom2d.circulinear.CirculinearCurve2D;
import math.geom2d.circulinear.CirculinearCurveArray2D;
import math.geom2d.circulinear.CirculinearCurveSet2D;
import math.geom2d.circulinear.CirculinearCurves2D;
import math.geom2d.circulinear.CirculinearDomain2D;
import math.geom2d.circulinear.GenericCirculinearDomain2D;
import math.geom2d.circulinear.buffer.BufferCalculator;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.transform.CircleInversion2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CirculinearContourArray2D<T extends CirculinearContour2D>
extends ContourArray2D<T>
implements CirculinearBoundary2D {
    public static <T extends CirculinearContour2D> CirculinearContourArray2D<T> create(Collection<T> curves) {
        return new CirculinearContourArray2D<T>(curves);
    }

    public static <T extends CirculinearContour2D> CirculinearContourArray2D<T> create(T ... curves) {
        return new CirculinearContourArray2D<T[]>(curves);
    }

    public CirculinearContourArray2D() {
        this.curves = new ArrayList();
    }

    public CirculinearContourArray2D(int n) {
        this.curves = new ArrayList(n);
    }

    public CirculinearContourArray2D(T ... curves) {
        this.curves = new ArrayList(curves.length);
        T[] TArray = curves;
        int n = curves.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.add(element);
            ++n2;
        }
    }

    public CirculinearContourArray2D(T curve) {
        this.curves = new ArrayList();
        this.curves.add(curve);
    }

    public CirculinearContourArray2D(Collection<? extends T> curves) {
        this.curves = new ArrayList(curves.size());
        this.curves.addAll(curves);
    }

    @Override
    public CirculinearDomain2D domain() {
        return new GenericCirculinearDomain2D(this);
    }

    @Override
    public double length() {
        double sum = 0.0;
        for (CirculinearCurve2D curve : this.curves()) {
            sum += curve.length();
        }
        return sum;
    }

    @Override
    public double length(double pos) {
        return CirculinearCurves2D.getLength(this, pos);
    }

    @Override
    public double position(double length) {
        return CirculinearCurves2D.getPosition(this, length);
    }

    @Override
    public CirculinearDomain2D buffer(double dist) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.computeBuffer(this, dist);
    }

    @Override
    public CirculinearBoundary2D parallel(double d) {
        BufferCalculator bc = BufferCalculator.getDefaultInstance();
        return bc.createParallelBoundary(this, d);
    }

    @Override
    public CirculinearContourArray2D<? extends CirculinearContour2D> transform(CircleInversion2D inv) {
        CirculinearContourArray2D<CirculinearContour2D> result = new CirculinearContourArray2D<CirculinearContour2D>(this.curves.size());
        for (CirculinearContour2D curve : this.curves) {
            result.add(curve.transform(inv));
        }
        return result;
    }

    @Override
    public Collection<T> continuousCurves() {
        return Collections.unmodifiableCollection(this.curves);
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearContinuousCurve2D> clip(Box2D box) {
        CurveSet2D<? extends Curve2D> set = Curves2D.clipCurve(this, box);
        int n = set.size();
        CirculinearCurveArray2D<CirculinearContinuousCurve2D> result = new CirculinearCurveArray2D<CirculinearContinuousCurve2D>(n);
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof CirculinearContinuousCurve2D)) continue;
            result.add((CirculinearContinuousCurve2D)curve2D);
        }
        return result;
    }

    @Override
    public CirculinearContourArray2D<? extends CirculinearContour2D> reverse() {
        int n = this.curves.size();
        CirculinearContour2D[] curves2 = new CirculinearContour2D[n];
        int i = 0;
        while (i < n) {
            curves2[i] = ((CirculinearContour2D)this.curves.get(n - 1 - i)).reverse();
            ++i;
        }
        return new CirculinearContourArray2D<CirculinearContour2D[]>(curves2);
    }

    @Override
    public CirculinearCurveSet2D<? extends CirculinearContinuousCurve2D> subCurve(double t0, double t1) {
        Curve2D curveSet = super.subCurve(t0, t1);
        ArrayList<CirculinearContinuousCurve2D> curves = new ArrayList<CirculinearContinuousCurve2D>(curveSet.size());
        for (Curve2D curve : curveSet.curves()) {
            curves.add((CirculinearContinuousCurve2D)curve);
        }
        return CirculinearCurveArray2D.create(curves);
    }
}

