/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.console;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.function.Predicate;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class TextFilterField {
    private final JTextField textField = new JTextField();
    private JLabel prompt = new JLabel();
    private Predicate<String> filter = null;
    private Runnable changeListener = null;

    TextFilterField(String textForPrompt) {
        this.initPrompt(textForPrompt);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TextFilterField.this.onUserInputChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TextFilterField.this.onUserInputChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TextFilterField.this.onUserInputChanged();
            }
        });
    }

    public JTextField getComponent() {
        return this.textField;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
    }

    public Predicate<String> getFilter() {
        if (this.filter == null) {
            this.filter = this.calculateFilter();
        }
        return this.filter;
    }

    private Predicate<String> calculateFilter() {
        String text = this.textField.getText();
        String[] words = text.split(" ");
        return s -> {
            for (String word : words) {
                if (s.contains(word)) continue;
                return false;
            }
            return true;
        };
    }

    private void onUserInputChanged() {
        this.filter = null;
        this.updatePromptVisibility();
        this.notifyChangeListener();
    }

    private void notifyChangeListener() {
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    private void initPrompt(String text) {
        this.prompt.setText(text);
        this.prompt.setFont(this.textField.getFont().deriveFont(2));
        this.prompt.setForeground(TextFilterField.changeAlpha(this.textField.getForeground(), 128));
        this.prompt.setBorder(new EmptyBorder(this.textField.getInsets()));
        this.prompt.setHorizontalAlignment(10);
        this.textField.setLayout(new BorderLayout());
        this.textField.add(this.prompt);
        this.updatePromptVisibility();
    }

    private static Color changeAlpha(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    private void updatePromptVisibility() {
        this.prompt.setVisible(this.textField.getDocument().getLength() == 0);
    }
}

