/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import org.scijava.plugin.Plugin;
import org.scijava.ui.awt.AWTColors;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.util.ColorRGB;
import org.scijava.util.ColorRGBA;
import org.scijava.widget.ColorWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingColorWidget
extends SwingInputWidget<ColorRGB>
implements ActionListener,
ColorWidget<JPanel> {
    private static final int SWATCH_WIDTH = 64;
    private static final int SWATCH_HEIGHT = SwingColorWidget.widgetHeight();
    private static final String HSB_CLASS_NAME = "javax.swing.colorchooser.DefaultHSBChooserPanel";
    protected static final String RGB_CLASS_NAME = "javax.swing.colorchooser.DefaultRGBChooserPanel";
    protected static final String SWATCHES_CLASS_NAME = "javax.swing.colorchooser.DefaultSwatchChooserPanel";
    private JButton choose;
    private Color color;
    private boolean useAlpha = false;

    @Override
    public void actionPerformed(ActionEvent e) {
        Color choice = SwingColorWidget.showColorDialog(this.choose, "Select a color", this.color);
        if (choice == null) {
            return;
        }
        this.color = choice;
        this.updateModel();
        this.refreshWidget();
    }

    public ColorRGB getValue() {
        if (this.useAlpha) {
            return AWTColors.getColorRGBA((Color)this.color);
        }
        return AWTColors.getColorRGB((Color)this.color);
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.getComponent().setLayout(new BoxLayout(this.getComponent(), 0));
        this.choose = new JButton(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.setToolTip(this.choose);
        this.getComponent().add(this.choose);
        this.choose.addActionListener(this);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isType(ColorRGB.class);
    }

    public static Color showColorDialog(Component component, String title, Color initialColor) throws HeadlessException {
        JColorChooser pane = SwingColorWidget.createColorChooser(initialColor);
        class ColorTracker
        implements ActionListener {
            private final JColorChooser chooser;
            private Color color;

            public ColorTracker(JColorChooser c) {
                this.chooser = c;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.color = this.chooser.getColor();
            }

            public Color getColor() {
                return this.color;
            }
        }
        ColorTracker ok = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(component, title, true, pane, ok, null);
        dialog.setVisible(true);
        return ok.getColor();
    }

    private static JColorChooser createColorChooser(Color initialColor) {
        JColorChooser chooser = new JColorChooser(initialColor != null ? initialColor : Color.white);
        AbstractColorChooserPanel[] panels = (AbstractColorChooserPanel[])chooser.getChooserPanels().clone();
        Arrays.sort(panels, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return this.value(o1) - this.value(o2);
            }

            private int value(Object o) {
                String className = o.getClass().getName();
                if (className.equals(SwingColorWidget.HSB_CLASS_NAME)) {
                    return 1;
                }
                if (className.equals(SwingColorWidget.RGB_CLASS_NAME)) {
                    return 2;
                }
                if (className.equals(SwingColorWidget.SWATCHES_CLASS_NAME)) {
                    return 3;
                }
                return 4;
            }
        });
        chooser.setChooserPanels(panels);
        return chooser;
    }

    private static int widgetHeight() {
        try {
            return UIManager.getFont("TextField.font").getSize();
        }
        catch (Exception exception) {
            return 16;
        }
    }

    public void doRefresh() {
        this.useAlpha = this.get().isType(ColorRGBA.class);
        ColorRGB value = (ColorRGB)this.get().getValue();
        this.color = AWTColors.getColor((ColorRGB)value);
        int imageType = this.useAlpha ? 2 : 1;
        BufferedImage image = new BufferedImage(64, SWATCH_HEIGHT, imageType);
        Graphics g = image.getGraphics();
        g.setColor(this.color);
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        g.dispose();
        ImageIcon icon = new ImageIcon(image);
        this.choose.setIcon(icon);
    }
}

