/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scijava.log.LogService;
import org.scijava.module.ModuleService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;
import org.scijava.ui.swing.widget.SpinnerNumberModelFactory;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.NumberWidget;
import org.scijava.widget.WidgetModel;
import org.scijava.widget.WidgetStyle;

@Plugin(type=InputWidget.class)
public class SwingNumberWidget
extends SwingInputWidget<Number>
implements NumberWidget<JPanel>,
AdjustmentListener,
ChangeListener,
MouseWheelListener {
    @Parameter
    private ThreadService threadService;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private LogService log;
    private CalibratedScrollBar scrollBar;
    private CalibratedSlider slider;
    private JSpinner spinner;

    public Number getValue() {
        return (Number)this.spinner.getValue();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        Number min = model.getMin();
        Number max = model.getMax();
        Number softMin = model.getSoftMin();
        Number softMax = model.getSoftMax();
        Number stepSize = model.getStepSize();
        if (model.isStyle("scroll bar")) {
            this.addScrollBar(softMin, softMax, stepSize);
        } else if (model.isStyle("slider")) {
            this.addSlider(softMin, softMax, stepSize);
        }
        Class type = model.getItem().getType();
        Number value = (Number)model.getValue();
        SpinnerNumberModel spinnerModel = new SpinnerNumberModelFactory().createModel(value, min, max, stepSize);
        this.spinner = new JSpinner(spinnerModel);
        String format = WidgetStyle.getStyleModifier((String)model.getItem().getWidgetStyle(), (String)"format");
        if (format == null) {
            format = this.suitableFormat(value, stepSize, min, max);
        }
        this.spinner.setEditor(new JSpinner.NumberEditor(this.spinner, format));
        Dimension spinnerSize = this.spinner.getPreferredSize();
        spinnerSize.width = 50;
        this.spinner.setPreferredSize(spinnerSize);
        this.fixSpinner(type);
        this.setToolTip(this.spinner);
        this.getComponent().add(this.spinner);
        this.limitWidth(200);
        this.spinner.addChangeListener(this);
        this.refreshWidget();
        this.syncSliders();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.isNumber();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        Number value = this.scrollBar.getCalibratedValue();
        this.spinner.setValue(value);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.slider) {
            Number value = this.slider.getCalibratedValue();
            this.spinner.setValue(value);
        } else if (source == this.spinner) {
            this.syncSliders();
        }
        this.updateModel();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Double value = this.getValue().doubleValue() + (double)e.getWheelRotation() * this.get().getStepSize().doubleValue();
        value = Math.min(value, this.get().getMax().doubleValue());
        value = Math.max(value, this.get().getMin().doubleValue());
        this.spinner.setValue(value);
        this.syncSliders();
    }

    private void addScrollBar(Number min, Number max, Number step) {
        if (min == null || max == null || step == null) {
            this.log.warn((Object)"Invalid min/max/step; cannot render scroll bar");
            return;
        }
        int sMin = 0;
        int sMax = (int)((max.doubleValue() - min.doubleValue()) / step.doubleValue());
        long range = sMax - sMin;
        if (range > Integer.MAX_VALUE) {
            this.log.warn((Object)"Scrollbar span too large; max - min < 2^31 required.");
            return;
        }
        this.scrollBar = new CalibratedScrollBar(min, max, step);
        this.setToolTip(this.scrollBar);
        this.getComponent().add(this.scrollBar);
        this.scrollBar.addAdjustmentListener(this);
        this.scrollBar.addMouseWheelListener(this);
    }

    private void addSlider(Number min, Number max, Number step) {
        if (min == null || max == null || step == null) {
            this.log.warn((Object)"Invalid min/max/step; cannot render slider");
            return;
        }
        int sMin = 0;
        int sMax = (int)((max.doubleValue() - min.doubleValue()) / step.doubleValue());
        long range = sMax - sMin;
        if (range > Integer.MAX_VALUE) {
            this.log.warn((Object)"Slider span too large; max - min < 2^31 required.");
            return;
        }
        this.slider = new CalibratedSlider(min, max, step);
        this.setToolTip(this.slider);
        this.getComponent().add(this.slider);
        this.slider.addChangeListener(this);
        this.slider.addMouseWheelListener(this);
    }

    private void limitWidth(int maxWidth) {
        Dimension minSize = this.spinner.getMinimumSize();
        if (minSize.width > maxWidth) {
            minSize.width = maxWidth;
            this.spinner.setMinimumSize(minSize);
        }
        Dimension prefSize = this.spinner.getPreferredSize();
        if (prefSize.width > maxWidth) {
            prefSize.width = maxWidth;
            this.spinner.setPreferredSize(prefSize);
        }
    }

    private void fixSpinner(Class<?> type) {
        this.fixSpinnerType(type);
        this.fixSpinnerFocus();
    }

    private void fixSpinnerType(Class<?> type) {
        if (!BigDecimal.class.isAssignableFrom(type) && !BigInteger.class.isAssignableFrom(type)) {
            return;
        }
        JComponent editor = this.spinner.getEditor();
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)editor;
        DecimalFormat decimalFormat = numberEditor.getFormat();
        decimalFormat.setParseBigDecimal(true);
    }

    private void fixSpinnerFocus() {
        for (Component c : this.spinner.getEditor().getComponents()) {
            if (!(c instanceof JTextField)) continue;
            final JTextField textField = (JTextField)c;
            textField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    this.queueSelection();
                }

                @Override
                public void focusLost(FocusEvent e) {
                    this.queueSelection();
                }

                private void queueSelection() {
                    SwingNumberWidget.this.threadService.queue(new Runnable(){

                        @Override
                        public void run() {
                            textField.selectAll();
                        }
                    });
                }
            });
        }
    }

    private void syncSliders() {
        Number value;
        if (this.slider != null) {
            value = this.getValue();
            if (value.doubleValue() < this.slider.getCalibratedMinimum().doubleValue()) {
                value = this.slider.getCalibratedMinimum();
            } else if (value.doubleValue() > this.slider.getCalibratedMaximum().doubleValue()) {
                value = this.slider.getCalibratedMaximum();
            }
            this.slider.removeChangeListener(this);
            this.slider.setCalibratedValue(value);
            this.slider.addChangeListener(this);
        }
        if (this.scrollBar != null) {
            value = this.getValue();
            if (value.doubleValue() < this.scrollBar.getCalibratedMinimum().doubleValue()) {
                value = this.scrollBar.getCalibratedMinimum();
            } else if (value.doubleValue() > this.scrollBar.getCalibratedMaximum().doubleValue()) {
                value = this.scrollBar.getCalibratedMaximum();
            }
            this.scrollBar.removeAdjustmentListener(this);
            this.scrollBar.setCalibratedValue(value);
            this.scrollBar.addAdjustmentListener(this);
        }
    }

    private String suitableFormat(Number ... values) {
        Integer maxScale = Arrays.stream(values).map(n -> new BigDecimal("" + (n == null ? 0.0 : n.doubleValue())).stripTrailingZeros().scale()).max(Integer::compare).get();
        return this.formatForScale(maxScale);
    }

    private String formatForScale(int scale) {
        if (scale <= 0) {
            return "0";
        }
        return "0." + String.join((CharSequence)"", Collections.nCopies(scale, "0"));
    }

    public void doRefresh() {
        Object value = this.get().getValue();
        if (this.spinner.getValue().equals(value)) {
            return;
        }
        this.spinner.setValue(value);
    }

    private class CalibratedScrollBar
    extends JScrollBar {
        private Number min;
        private Number max;
        private Number stepSize;

        private CalibratedScrollBar(Number min, Number max, Number stepSize) {
            super(0, 0, 1, 0, 1);
            this.min = min;
            this.max = max;
            this.stepSize = stepSize;
            int sMin = 0;
            int sMax = (int)((max.doubleValue() - min.doubleValue()) / stepSize.doubleValue()) + 1;
            this.max = min.doubleValue() + (double)(sMax - sMin) * stepSize.doubleValue();
            this.setMinimum(sMin);
            this.setMaximum(sMax);
            this.setValue(sMin);
        }

        private void setCalibratedValue(Number value) {
            this.setValue(this.fromCalibrated(value));
        }

        private Number getCalibratedValue() {
            return this.toCalibrated(this.getValue());
        }

        private Number getCalibratedMinimum() {
            return this.min;
        }

        private Number getCalibratedMaximum() {
            return this.max;
        }

        private int fromCalibrated(Number n) {
            return (int)Math.round((n.doubleValue() - this.min.doubleValue()) / this.stepSize.doubleValue());
        }

        private Number toCalibrated(int n) {
            return (double)n * this.stepSize.doubleValue() + this.min.doubleValue();
        }
    }

    private class CalibratedSlider
    extends JSlider {
        private Number min;
        private Number max;
        private Number stepSize;

        private CalibratedSlider(Number min, Number max, Number stepSize) {
            this.min = min;
            this.max = max;
            this.stepSize = stepSize;
            int sMin = 0;
            int sMax = (int)((max.doubleValue() - min.doubleValue()) / stepSize.doubleValue());
            this.max = min.doubleValue() + (double)(sMax - sMin) * stepSize.doubleValue();
            this.setMinimum(sMin);
            this.setMaximum(sMax);
            this.setValue(sMin);
            int scale = Math.max(0, new BigDecimal(stepSize.toString()).stripTrailingZeros().scale());
            JLabel minLabel = this.makeLabel(min, scale);
            JLabel maxLabel = this.makeLabel(max, scale);
            int labelWidth = Math.max(minLabel.getText().length(), maxLabel.getText().length());
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>(2);
            labelTable.put(sMin, minLabel);
            labelTable.put(sMax, maxLabel);
            if (labelWidth < 5 && sMax % 5 == 0) {
                labelTable.put(1 * sMax / 5, this.makeLabel(this.toCalibrated(1 * sMax / 5), scale));
                labelTable.put(2 * sMax / 5, this.makeLabel(this.toCalibrated(2 * sMax / 5), scale));
                labelTable.put(3 * sMax / 5, this.makeLabel(this.toCalibrated(3 * sMax / 5), scale));
                labelTable.put(4 * sMax / 5, this.makeLabel(this.toCalibrated(4 * sMax / 5), scale));
            } else if (labelWidth < 6) {
                labelTable.put(1 * sMax / 4, this.makeLabel(this.toCalibrated(1 * sMax / 4), scale));
                labelTable.put(2 * sMax / 4, this.makeLabel(this.toCalibrated(2 * sMax / 4), scale));
                labelTable.put(3 * sMax / 4, this.makeLabel(this.toCalibrated(3 * sMax / 4), scale));
            }
            this.setLabelTable(labelTable);
            this.setPaintLabels(true);
            this.setMinorTickSpacing(1);
            this.setPaintTicks(sMax < 100);
        }

        private void setCalibratedValue(Number value) {
            this.setValue(this.fromCalibrated(value));
        }

        private Number getCalibratedValue() {
            return this.toCalibrated(this.getValue());
        }

        private Number getCalibratedMinimum() {
            return this.min;
        }

        private Number getCalibratedMaximum() {
            return this.max;
        }

        private int fromCalibrated(Number n) {
            return (int)Math.round((n.doubleValue() - this.min.doubleValue()) / this.stepSize.doubleValue());
        }

        private Number toCalibrated(int n) {
            return (double)n * this.stepSize.doubleValue() + this.min.doubleValue();
        }

        private JLabel makeLabel(Number n, int scale) {
            return new JLabel(String.format("%." + scale + "f", n.doubleValue()));
        }
    }
}

