/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class AIMReader
extends FormatReader {
    private long pixelOffset;

    public AIMReader() {
        super("AIM", "aim");
        this.domains = new String[]{"Unknown"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int planeSize = FormatTools.getPlaneSize((IFormatReader)this);
        long offset = this.pixelOffset + (long)planeSize * (long)no;
        if (offset < this.in.length()) {
            this.in.seek(offset);
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.pixelOffset = 0L;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        String[] lines;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        String version = this.in.readString(16);
        boolean widerOffsets = version.startsWith("AIMDATA_V030");
        if (widerOffsets) {
            this.in.seek(96L);
            m.sizeX = (int)this.in.readLong();
            m.sizeY = (int)this.in.readLong();
            m.sizeZ = (int)this.in.readLong();
            this.in.seek(280L);
        } else {
            this.in.seek(56L);
            m.sizeX = this.in.readInt();
            m.sizeY = this.in.readInt();
            m.sizeZ = this.in.readInt();
            this.in.seek(160L);
        }
        m.sizeC = 1;
        m.sizeT = 1;
        m.imageCount = this.getSizeZ();
        m.pixelType = 2;
        m.dimensionOrder = "XYZCT";
        String processingLog = this.in.readCString();
        this.pixelOffset = this.in.getFilePointer();
        String date = null;
        Double xSize = null;
        Double xLength = null;
        Double ySize = null;
        Double yLength = null;
        Double zSize = null;
        Double zLength = null;
        for (String line : lines = processingLog.split("\n")) {
            String[] tokens;
            int split = (line = line.trim()).indexOf("  ");
            if (split <= 0) continue;
            String key = line.substring(0, split).trim();
            String value = line.substring(split).trim();
            this.addGlobalMeta(key, value);
            if (key.equals("Original Creation-Date")) {
                date = DateTools.formatDate(value, "dd-MMM-yyyy HH:mm:ss", ".");
                continue;
            }
            if (key.equals("Orig-ISQ-Dim-p")) {
                for (String token : tokens = value.split(" ")) {
                    if ((token = token.trim()).length() <= 0) continue;
                    if (xSize == null) {
                        xSize = DataTools.parseDouble(token);
                        continue;
                    }
                    if (ySize == null) {
                        ySize = DataTools.parseDouble(token);
                        continue;
                    }
                    if (zSize != null) continue;
                    zSize = DataTools.parseDouble(token);
                }
                continue;
            }
            if (!key.equals("Orig-ISQ-Dim-um")) continue;
            for (String token : tokens = value.split(" ")) {
                if ((token = token.trim()).length() <= 0) continue;
                if (xLength == null) {
                    xLength = DataTools.parseDouble(token);
                    continue;
                }
                if (yLength == null) {
                    yLength = DataTools.parseDouble(token);
                    continue;
                }
                if (zLength != null) continue;
                zLength = DataTools.parseDouble(token);
            }
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Double size;
            Length physicalSize;
            if (xSize != null && xLength != null && (physicalSize = FormatTools.getPhysicalSizeX((Double)(size = Double.valueOf(xLength / xSize)))) != null) {
                store.setPixelsPhysicalSizeX(physicalSize, 0);
            }
            if (ySize != null && yLength != null && (physicalSize = FormatTools.getPhysicalSizeY((Double)(size = Double.valueOf(yLength / ySize)))) != null) {
                store.setPixelsPhysicalSizeY(physicalSize, 0);
            }
            if (zSize != null && zLength != null && (physicalSize = FormatTools.getPhysicalSizeZ((Double)(size = Double.valueOf(zLength / zSize)))) != null) {
                store.setPixelsPhysicalSizeZ(physicalSize, 0);
            }
        }
    }
}

