/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness;

import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.janelia.thickness.inference.Options;
import org.janelia.thickness.lut.LUTRealTransform;

public class ShiftCoordinates {
    public static <T extends RealType<T>> void collectShiftsFromMatrix(double[] coordinates, RandomAccessibleInterval<T> correlations, double[] multipliers, RandomAccessibleInterval<double[]> localFits, double[] shiftsArray, double[] weightSums, double[] shiftWeights, Options options) {
        int stride = 2 * options.comparisonRange;
        RandomAccess corrAccess1 = correlations.randomAccess();
        RandomAccess corrAccess2 = correlations.randomAccess();
        double[] reference = new double[1];
        Cursor cursor = Views.iterable(localFits).cursor();
        long width = correlations.dimension(0);
        long height = correlations.dimension(1);
        int i = 0;
        while ((long)i < height) {
            corrAccess1.setPosition(i, 1);
            corrAccess2.setPosition(i, 1);
            double[] localFit = (double[])cursor.next();
            LUTRealTransform lut = new LUTRealTransform(localFit, 1, 1);
            double minMeasurement1 = Double.MAX_VALUE;
            double minMeasurement2 = Double.MAX_VALUE;
            boolean startDist = true;
            double w = shiftWeights[i];
            int dist = 1;
            int up = i + 1;
            int down = i - 1;
            while (dist <= options.comparisonRange) {
                double shift;
                double rel;
                double measurement;
                if ((long)up < width) {
                    corrAccess1.setPosition(up, 0);
                    measurement = ((RealType)corrAccess1.get()).getRealDouble();
                    if (!(Double.isNaN(measurement) || measurement <= options.minimumCorrelationValue || options.forceMonotonicity.booleanValue() && measurement >= minMeasurement1)) {
                        minMeasurement1 = measurement;
                        reference[0] = -measurement;
                        lut.applyInverse(reference, reference);
                        if (Double.isFinite(reference[0]) && reference[0] != Double.MAX_VALUE && reference[0] != -1.7976931348623157E308) {
                            rel = coordinates[i] - coordinates[up];
                            shift = up < i ? rel - reference[0] : rel + reference[0];
                            int n = up;
                            shiftsArray[n] = shiftsArray[n] + shift * w;
                            int n2 = up;
                            weightSums[n2] = weightSums[n2] + w;
                        }
                    }
                }
                if (down >= 0) {
                    corrAccess2.setPosition(down, 0);
                    measurement = ((RealType)corrAccess2.get()).getRealDouble();
                    if (!(Double.isFinite(reference[0]) && Double.isNaN(measurement) || measurement <= options.minimumCorrelationValue || options.forceMonotonicity.booleanValue() && measurement >= minMeasurement2)) {
                        minMeasurement2 = measurement;
                        reference[0] = -measurement;
                        lut.applyInverse(reference, reference);
                        if (reference[0] != Double.MAX_VALUE && reference[0] != -1.7976931348623157E308) {
                            rel = coordinates[i] - coordinates[down];
                            shift = down < i ? rel - reference[0] : rel + reference[0];
                            int n = down;
                            shiftsArray[n] = shiftsArray[n] + shift;
                            int n3 = down;
                            weightSums[n3] = weightSums[n3] + w;
                        }
                    }
                }
                ++dist;
                ++up;
                --down;
            }
            ++i;
        }
    }
}

