/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.thickness.trakem2;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.plugin.TPlugIn;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.FeatureTransform;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AffineModel2D;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.align.Align;
import net.imglib2.img.imageplus.ImagePlusImg;
import net.imglib2.img.imageplus.ImagePlusImgs;
import org.janelia.thickness.inference.InferFromMatrix;
import org.janelia.thickness.inference.Options;
import org.janelia.thickness.inference.fits.GlobalCorrelationFitAverage;
import org.janelia.thickness.trakem2.RealSumARGBNCC;

public class LayerZPosition
implements TPlugIn {
    protected LayerSet layerset = null;
    protected static int radius = 10;
    protected static int iterations = 100;
    protected static double regularize = 0.6;
    protected static int innerIterations = 10;
    protected static double innerRegularize = 0.1;
    protected static boolean reorder = true;
    protected static double scale = -1.0;
    protected static boolean showMatrix = true;
    protected static Align.Param siftParam = Align.param.clone();
    protected static final String[] similarityMethods = new String[]{"NCC (aligned)", "SIFT consensus (unaligned)"};
    protected static String similarityMethod = similarityMethods[0];

    private Layer currentLayer(Object ... params) {
        Display front;
        Object param;
        Object layer = params != null && params[0] != null ? (Layer.class.isInstance(param = params[0]) ? (Layer)param : (LayerSet.class.isInstance(param) ? ((LayerSet)param).getLayer(0) : (Displayable.class.isInstance(param) ? ((Displayable)param).getLayer() : null))) : ((front = Display.getFront()) == null ? ((Project)Project.getProjects().get(0)).getRootLayerSet().getLayer(0) : front.getLayer());
        return layer;
    }

    private static Rectangle getRoi(LayerSet layerset) {
        Display front = Display.getFront();
        Roi roi = front == null ? null : front.getRoi();
        if (roi == null) {
            return new Rectangle(0, 0, (int)layerset.getLayerWidth(), (int)layerset.getLayerHeight());
        }
        return roi.getBounds();
    }

    private double suggestScale(List<Layer> layers) {
        if (layers.size() < 2) {
            return 0.0;
        }
        Layer layer1 = layers.get(0);
        Layer layer2 = layers.get(1);
        Calibration calib = layer1.getParent().getCalibration();
        double width = (calib.pixelWidth + calib.pixelHeight) * 0.5;
        double depth = calib.pixelDepth;
        return (layer2.getZ() - layer1.getZ()) * width / depth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setup(Object ... params) {
        if (params != null && params[0] != null) {
            Object param = params[0];
            if (LayerSet.class.isInstance(param)) {
                this.layerset = (LayerSet)param;
                return true;
            } else {
                if (!Displayable.class.isInstance(param)) return false;
                this.layerset = ((Displayable)param).getLayerSet();
            }
            return true;
        } else {
            Display front = Display.getFront();
            this.layerset = front == null ? ((Project)Project.getProjects().get(0)).getRootLayerSet() : front.getLayerSet();
        }
        return true;
    }

    private static ColorProcessor getColorProcessor(Layer layer, Rectangle fov, double s) {
        Collection filteredDisplayables = layer.getDisplayables(Patch.class, fov);
        ArrayList<Patch> filteredPatches = new ArrayList<Patch>();
        for (Displayable d : filteredDisplayables) {
            if (!d.isVisible()) continue;
            filteredPatches.add((Patch)d);
        }
        if (filteredPatches.size() > 0) {
            Image imgi = layer.getProject().getLoader().getFlatAWTImage(layer, fov, s, -1, 4, Patch.class, filteredPatches, true, new Color(0xFFFFFF, true));
            return new ColorProcessor(imgi);
        }
        return null;
    }

    private static int[] getPixels(Layer layer, Rectangle fov, double s) {
        ColorProcessor ip = LayerZPosition.getColorProcessor(layer, fov, s);
        if (ip == null) {
            return null;
        }
        return (int[])ip.getPixels();
    }

    public static void optimize(List<Layer> layers, FloatProcessor matrix, int rad, int iter, double reg, int innerIter, double innerReg, boolean reord) throws Exception {
        Options options = Options.generateDefaultOptions();
        options.comparisonRange = rad;
        options.nIterations = iter;
        options.shiftProportion = reg;
        options.scalingFactorEstimationIterations = innerIter;
        options.scalingFactorRegularizerWeight = innerReg;
        options.withReorder = reord;
        options.regularizationType = InferFromMatrix.RegularizationType.BORDER;
        options.minimumSectionThickness = 0.0;
        double zMin = layers.get(0).getZ();
        double zScale = 1.0 / (layers.get(1).getZ() - zMin);
        double[] lut = new double[layers.size()];
        for (int i = 0; i < lut.length; ++i) {
            lut[i] = (layers.get(i).getZ() - zMin) * zScale;
        }
        IJ.log((String)Arrays.toString(lut));
        InferFromMatrix inference = new InferFromMatrix(new GlobalCorrelationFitAverage());
        ImagePlusImg raMatrix = ImagePlusImgs.from((ImagePlus)new ImagePlus("", (ImageProcessor)matrix));
        double[] lutCorrected = inference.estimateZCoordinates(raMatrix, lut, options);
        IJ.log((String)Arrays.toString(lutCorrected));
        for (int i = 0; i < lutCorrected.length; ++i) {
            layers.get(i).setZ(lutCorrected[i] / zScale + zMin);
        }
    }

    private static FloatProcessor initMatrix(int size) {
        FloatProcessor ip = new FloatProcessor(size, size);
        float[] ipPixels = (float[])ip.getPixels();
        for (int i = 0; i < ipPixels.length; ++i) {
            ipPixels[i] = Float.NaN;
        }
        ip.setMinAndMax(-0.2, 1.0);
        return ip;
    }

    public static FloatProcessor calculateNCCSimilarity(List<Layer> layers, final Rectangle fov, int r, final double s) throws InterruptedException, ExecutionException {
        ImagePlus impMatrix;
        final FloatProcessor ip = LayerZPosition.initMatrix(layers.size());
        if (showMatrix) {
            impMatrix = new ImagePlus("Similarity matrix", (ImageProcessor)ip);
            impMatrix.show();
        } else {
            impMatrix = null;
        }
        for (int i = 0; i < layers.size(); ++i) {
            final int fi = i;
            Layer li = layers.get(i);
            final int[] argbi = LayerZPosition.getPixels(li, fov, s);
            if (argbi == null) continue;
            ip.setf(fi, fi, 1.0f);
            ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            ArrayList<Future<FloatProcessor>> tasks = new ArrayList<Future<FloatProcessor>>();
            for (int j = i + 1; j < layers.size() && j <= i + r; ++j) {
                final int n = j;
                final Layer lj = layers.get(j);
                tasks.add(exec.submit(new Runnable(){

                    @Override
                    public void run() {
                        int[] argbj = LayerZPosition.getPixels(lj, fov, s);
                        if (argbj != null) {
                            Double d = new RealSumARGBNCC(argbi, argbj).call();
                            ip.setf(fi, n, d.floatValue());
                            ip.setf(n, fi, d.floatValue());
                            if (impMatrix != null) {
                                impMatrix.updateAndDraw();
                            }
                        }
                    }
                }, ip));
            }
            for (Future future : tasks) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    exec.shutdownNow();
                    throw e;
                }
                catch (ExecutionException e) {
                    exec.shutdownNow();
                    throw e;
                }
            }
            tasks.clear();
            exec.shutdown();
            if (impMatrix == null) continue;
            impMatrix.updateAndDraw();
        }
        return ip;
    }

    public static void runNCC(List<Layer> layers, Rectangle fov, int r, double s, int iter, double reg, int innerIter, double innerReg, boolean reord) throws InterruptedException, ExecutionException {
        FloatProcessor matrix = LayerZPosition.calculateNCCSimilarity(layers, fov, r, s);
        try {
            LayerZPosition.optimize(layers, matrix, r, iter, reg, innerIter, innerReg, reord);
        }
        catch (Exception e) {
            throw new ExecutionException(e.getCause());
        }
    }

    public void invokeNCC(List<Layer> layers, Rectangle fov) throws InterruptedException, ExecutionException {
        GenericDialog gd = new GenericDialog("Correct layer z-positions - NCC");
        gd.addNumericField("scale :", scale < 0.0 ? this.suggestScale(layers) : scale, 2, 6, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        scale = gd.getNextNumber();
        LayerZPosition.runNCC(layers, fov, radius, scale, iterations, regularize, innerIterations, innerRegularize, reorder);
    }

    protected static ArrayList<Feature> extract(SIFT ijSIFT, ImageProcessor ip) {
        ArrayList<Feature> features = new ArrayList<Feature>();
        ijSIFT.extractFeatures(ip, features);
        return features;
    }

    private static double match(Align.Param param, ArrayList<Feature> features1, ArrayList<Feature> features2) {
        ArrayList candidates = new ArrayList();
        ArrayList inliers = new ArrayList();
        if (features1.size() > 0 && features2.size() > 0) {
            TranslationModel2D model;
            FeatureTransform.matchFeatures(features1, features2, candidates, (float)param.rod);
            switch (param.expectedModelIndex) {
                case 0: {
                    model = new TranslationModel2D();
                    break;
                }
                case 1: {
                    model = new RigidModel2D();
                    break;
                }
                case 2: {
                    model = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    model = new AffineModel2D();
                    break;
                }
                case 4: {
                    model = new HomographyModel2D();
                    break;
                }
                default: {
                    return 0.0;
                }
            }
            boolean modelFound = false;
            try {
                modelFound = model.filterRansac(candidates, inliers, 1000, (double)param.maxEpsilon, (double)param.minInlierRatio, param.minNumInliers, 3.0);
            }
            catch (NotEnoughDataPointsException e) {
                modelFound = false;
            }
            if (modelFound) {
                return (double)inliers.size() / (double)candidates.size();
            }
            return 0.0;
        }
        return 0.0;
    }

    private static List<ArrayList<Feature>> extractFeatures(final List<Layer> layers, final Align.Param param, final Rectangle fov) throws InterruptedException {
        final double s = Math.min(1.0, Math.min((double)param.sift.maxOctaveSize / fov.getWidth(), (double)param.sift.maxOctaveSize / fov.getHeight()));
        final ArrayList[] featuresArray = new ArrayList[layers.size()];
        final AtomicInteger i = new AtomicInteger(0);
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int t = 0; t < Runtime.getRuntime().availableProcessors(); ++t) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    FloatArray2DSIFT sift = new FloatArray2DSIFT(param.sift);
                    SIFT ijSIFT = new SIFT(sift);
                    int k = i.getAndIncrement();
                    while (k < layers.size()) {
                        ArrayList<Feature> features = LayerZPosition.extract(ijSIFT, (ImageProcessor)LayerZPosition.getColorProcessor((Layer)layers.get(k), fov, s));
                        IJ.log((String)(k + ": " + features.size() + " features extracted"));
                        featuresArray[k] = features;
                        k = i.getAndIncrement();
                    }
                }
            });
            threads.add(thread);
            thread.start();
        }
        for (Thread t : threads) {
            t.join();
        }
        return Arrays.asList(featuresArray);
    }

    public static FloatProcessor calculateSIFTSimilarity(final List<Layer> layers, Rectangle fov, int r, final Align.Param p) throws InterruptedException, ExecutionException {
        ImagePlus impMatrix;
        final List<ArrayList<Feature>> featuresList = LayerZPosition.extractFeatures(layers, p, fov);
        final FloatProcessor ip = LayerZPosition.initMatrix(layers.size());
        if (showMatrix) {
            impMatrix = new ImagePlus("Similarity matrix", (ImageProcessor)ip);
            impMatrix.show();
        } else {
            impMatrix = null;
        }
        for (int i = 0; i < layers.size(); ++i) {
            final int fi = i;
            final ArrayList<Feature> f1 = featuresList.get(fi);
            if (f1 == null || f1.size() == 0) continue;
            ip.setf(fi, fi, 1.0f);
            final AtomicInteger j = new AtomicInteger(fi + 1);
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int t = 0; t < Runtime.getRuntime().availableProcessors(); ++t) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        int k = j.getAndIncrement();
                        while (k < layers.size() && k < fi + radius) {
                            ArrayList f2 = (ArrayList)featuresList.get(k);
                            if (f2 == null || f2.size() == 0) {
                                if (impMatrix != null) {
                                    impMatrix.updateAndDraw();
                                }
                            } else {
                                float inlierRatio = (float)LayerZPosition.match(p, f1, f2);
                                ip.setf(fi, k, inlierRatio);
                                ip.setf(k, fi, inlierRatio);
                                if (impMatrix != null) {
                                    impMatrix.updateAndDraw();
                                }
                            }
                            k = j.getAndIncrement();
                        }
                    }
                });
                threads.add(thread);
                thread.start();
            }
            for (Thread t : threads) {
                t.join();
            }
            if (impMatrix == null) continue;
            impMatrix.updateAndDraw();
        }
        return ip;
    }

    public static void runSIFT(List<Layer> layers, Rectangle fov, int r, Align.Param p) throws InterruptedException, ExecutionException {
        FloatProcessor matrix = LayerZPosition.calculateSIFTSimilarity(layers, fov, r, p);
        try {
            LayerZPosition.optimize(layers, matrix, r, iterations, regularize, innerIterations, innerRegularize, reorder);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    public void invokeSIFT(List<Layer> layers, Rectangle fov) throws InterruptedException, ExecutionException {
        GenericDialog gd = new GenericDialog("Correct layer z-positions - SIFT consensus");
        gd.addMessage("Scale Invariant Features :");
        siftParam.addSIFTFields(gd);
        gd.addMessage("Consensus Filter :");
        siftParam.addGeometricConsensusFilterFields(gd);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        siftParam.readSIFTFields(gd);
        siftParam.readGeometricConsensusFilterFields(gd);
        LayerZPosition.runSIFT(layers, fov, radius, siftParam.clone());
    }

    public Object invoke(Object ... params) {
        if (!this.setup(params)) {
            return null;
        }
        Layer layer = this.currentLayer(params);
        GenericDialog gd = new GenericDialog("Correct layer z-positions");
        Utils.addLayerRangeChoices((Layer)layer, (GenericDialog)gd);
        gd.addMessage("Layer neighborhood range :");
        gd.addNumericField("test_maximally :", (double)radius, 0, 6, "layers");
        gd.addMessage("Optimizer :");
        gd.addNumericField("outer_iterations :", (double)iterations, 0, 6, "");
        gd.addNumericField("outer_regularization :", regularize, 2, 6, "");
        gd.addNumericField("inner_iterations :", (double)innerIterations, 0, 6, "");
        gd.addNumericField("inner_regularization :", innerRegularize, 2, 6, "");
        gd.addCheckbox(" allow_reordering", reorder);
        gd.addChoice("Similarity_method :", similarityMethods, similarityMethod);
        gd.addCheckbox("show_matrix", showMatrix);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        List<Layer> layers = this.layerset.getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1);
        radius = (int)gd.getNextNumber();
        int method = gd.getNextChoiceIndex();
        similarityMethod = similarityMethods[method];
        showMatrix = gd.getNextBoolean();
        try {
            switch (method) {
                case 1: {
                    this.invokeSIFT(layers, LayerZPosition.getRoi(this.layerset));
                    break;
                }
                default: {
                    this.invokeNCC(layers, LayerZPosition.getRoi(this.layerset));
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            Utils.log((String)"Layer Z-Spacing Correction interrupted.");
        }
        catch (ExecutionException e) {
            Utils.log((String)"Layer Z-Spacing Correction ExecutiuonException occurred:");
            e.printStackTrace(System.out);
        }
        return null;
    }

    public boolean applies(Object ob) {
        return true;
    }
}

