/*
 * Decompiled with CFR 0.152.
 */
package selection;

import ij.IJ;
import java.awt.Frame;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import mpicbg.models.Point;
import selection.ExtendedPointMatch;
import selection.Select_Points;

public class LoadListener
implements ActionListener {
    final ArrayList<ExtendedPointMatch> matches;
    final Frame frame;
    final List list1;
    final List list2;

    public LoadListener(Frame frame, List list1, List list2, ArrayList<ExtendedPointMatch> matches) {
        this.matches = matches;
        this.frame = frame;
        this.list1 = list1;
        this.list2 = list2;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String filename = File.separator + "txt";
        JFileChooser fc = new JFileChooser(new File(filename));
        fc.showOpenDialog(this.frame);
        File file = fc.getSelectedFile();
        IJ.log((String)("Loading '" + file + "' ..."));
        BufferedReader in = LoadListener.openFileRead(file);
        try {
            while (in.ready()) {
                String[] l = in.readLine().trim().split("\t");
                if (l.length != 16) {
                    IJ.log((String)"Wrong line size, cancel.");
                    in.close();
                    return;
                }
                Point p1 = new Point(new double[]{Double.parseDouble(l[0]), Double.parseDouble(l[1]), Double.parseDouble(l[2])}, new double[]{Double.parseDouble(l[3]), Double.parseDouble(l[4]), Double.parseDouble(l[5])});
                Point p2 = new Point(new double[]{Double.parseDouble(l[8]), Double.parseDouble(l[9]), Double.parseDouble(l[10])}, new double[]{Double.parseDouble(l[11]), Double.parseDouble(l[12]), Double.parseDouble(l[13])});
                ExtendedPointMatch pm = new ExtendedPointMatch(p1, p2, Double.parseDouble(l[6]), Double.parseDouble(l[7]), Double.parseDouble(l[14]), Double.parseDouble(l[15]));
                this.matches.add(pm);
                this.list1.add(Select_Points.getStringForPoint(pm.getP1(), pm.radius1W));
                this.list2.add(Select_Points.getStringForPoint(pm.getP2(), pm.radius2W));
            }
            in.close();
        }
        catch (Exception e) {
            IJ.log((String)("Cannot load file '" + file + "': " + e));
            e.printStackTrace();
            return;
        }
    }

    private static BufferedReader openFileRead(File file) {
        BufferedReader inputFile;
        try {
            inputFile = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            System.out.println("TextFileAccess.openFileRead(): " + e);
            inputFile = null;
        }
        return inputFile;
    }
}

