/*
 * Decompiled with CFR 0.152.
 */
package io.scif.lifesci;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import io.scif.img.axes.SCIFIOAxes;
import io.scif.lifesci.SDTInfo;
import io.scif.util.FormatTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;
import org.scijava.util.Bytes;

@Plugin(type=Format.class)
public class SDTFormat
extends AbstractFormat {
    public String getFormatName() {
        return "SPCImage Data";
    }

    protected String[] makeSuffixArray() {
        return new String[]{"sdt"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        protected String[] createDomainArray() {
            return new String[]{"Fluorescence-Lifetime Imaging"};
        }

        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            int row;
            int col;
            int tmpOff;
            Metadata m = (Metadata)this.getMetadata();
            byte[] buf = plane.getBytes();
            FormatTools.checkPlaneForReading((io.scif.Metadata)m, (int)imageIndex, (long)planeIndex, (int)buf.length, (Interval)bounds);
            int sizeX = (int)m.get(imageIndex).getAxisLength(Axes.X);
            int sizeY = (int)m.get(imageIndex).getAxisLength(Axes.Y);
            int bpp = FormatTools.getBytesPerPixel((int)m.get(imageIndex).getPixelType());
            boolean little = m.get(imageIndex).isLittleEndian();
            int paddedWidth = sizeX + (4 - sizeX % 4) % 4;
            int planeSize = paddedWidth * sizeY * m.getTimeBins() * bpp;
            int x = (int)bounds.min(m.get(imageIndex).getAxisIndex(Axes.X));
            int y = (int)bounds.min(m.get(imageIndex).getAxisIndex(Axes.Y));
            int w = (int)bounds.dimension(m.get(imageIndex).getAxisIndex(Axes.X));
            int h = (int)bounds.dimension(m.get(imageIndex).getAxisIndex(Axes.Y));
            boolean merge = m.mergeIntensity();
            byte[] b = !merge ? buf : new byte[sizeY * sizeX * m.getTimeBins() * bpp];
            SDTInfo info = m.getSDTInfo();
            if (info.measMode == 13) {
                tmpOff = info.dataBlockOffs;
                this.getHandle().seek((long)tmpOff);
                info.readBlockHeader((DataHandle<Location>)this.getHandle());
                int channelIndex = (int)(planeIndex % (long)info.noOfDataBlocks);
                int blockIndex = (int)(planeIndex / (long)info.noOfDataBlocks);
                for (int i = 0; i < blockIndex; ++i) {
                    tmpOff = info.nextBlockOffs;
                    this.getHandle().seek((long)tmpOff);
                    info.readBlockHeader((DataHandle<Location>)this.getHandle());
                }
                this.getHandle().skip((long)(channelIndex * planeSize + y * paddedWidth * bpp * m.getTimeBins()));
            } else if (info.noOfDataBlocks > 1) {
                int row2;
                boolean crop;
                tmpOff = info.dataBlockOffs;
                boolean bl = crop = x == 0 && y == 0 && w == sizeX && y == sizeY;
                if (crop && !merge) {
                    b = new byte[sizeY * sizeX * m.getTimeBins() * bpp];
                }
                for (row2 = h - 1; row2 >= 0; --row2) {
                    for (col = 0; col < w; ++col) {
                        this.getHandle().seek((long)tmpOff);
                        info.readBlockHeader((DataHandle<Location>)this.getHandle());
                        this.getHandle().skip(planeIndex * (long)m.getTimeBins() * (long)bpp);
                        this.getHandle().read(b, (row2 * w + col) * m.getTimeBins() * bpp, m.getTimeBins() * bpp);
                        tmpOff = info.nextBlockOffs;
                    }
                }
                if (crop) {
                    for (row2 = 0; row2 < h; ++row2) {
                        System.arraycopy(b, (row2 * sizeX + x) * bpp * m.getTimeBins(), buf, row2 * w * bpp * m.getTimeBins(), w * m.getTimeBins() * bpp);
                    }
                }
            } else {
                this.getHandle().seek((long)m.getBinOffset() + planeIndex * (long)planeSize + (long)(y * paddedWidth * bpp * m.getTimeBins()));
            }
            if (info.measMode == 13 || info.noOfDataBlocks == 1) {
                for (row = 0; row < h; ++row) {
                    this.getHandle().skipBytes(x * bpp * m.getTimeBins());
                    this.getHandle().read(b, row * bpp * m.getTimeBins() * w, w * m.getTimeBins() * bpp);
                    this.getHandle().skipBytes(bpp * m.getTimeBins() * (paddedWidth - x - w));
                }
            }
            if (!merge) {
                return plane;
            }
            for (row = 0; row < h; ++row) {
                int yi = (y + row) * sizeX * m.getTimeBins() * bpp;
                int ri = row * w * bpp;
                for (col = 0; col < w; ++col) {
                    int xi = yi + (x + col) * m.getTimeBins() * bpp;
                    int ci = ri + col * bpp;
                    int sum = 0;
                    for (int t = 0; t < m.getTimeBins(); ++t) {
                        sum = (short)(sum + Bytes.toShort((byte[])b, (int)(xi + t * bpp), (boolean)little));
                    }
                    Bytes.unpack((long)sum, (byte[])buf, (int)ci, (int)2, (boolean)little);
                }
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        private boolean mergeIntensity = false;

        public boolean mergeIntensity() {
            return this.mergeIntensity;
        }

        public void setMergeIntensity(boolean mergeIntensity) {
            this.mergeIntensity = mergeIntensity;
        }

        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            stream.setLittleEndian(true);
            this.log().info((Object)"Reading SDT header");
            SDTInfo info = new SDTInfo(stream, meta.getTable());
            meta.setSDTInfo(info);
            meta.setBinOffset(info.dataBlockOffs + 22);
            meta.setTimeBins(info.timeBins);
            meta.setChannels(info.channels);
            meta.getTable().put((Object)"time bins", (Object)meta.getTimeBins());
            meta.getTable().put((Object)"channels", (Object)meta.getChannels());
            double timeBase = 1.0E9 * (double)info.tacR / (double)info.tacG;
            meta.getTable().put((Object)"time base", (Object)timeBase);
            meta.timeBase = timeBase;
            meta.mergeIntensity = this.mergeIntensity;
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private SDTInfo info;
        private int binOffset;
        private int timeBins;
        private int channels;
        private boolean mergeIntensity = false;
        private double timeBase;

        public double getTimeBase() {
            return this.timeBase;
        }

        public void setTimeBase(double timeBase) {
            this.timeBase = timeBase;
        }

        public SDTInfo getSDTInfo() {
            return this.info;
        }

        public void setSDTInfo(SDTInfo info) {
            this.info = info;
        }

        public int getBinOffset() {
            return this.binOffset;
        }

        public void setBinOffset(int binOffset) {
            this.binOffset = binOffset;
        }

        public int getTimeBins() {
            return this.timeBins;
        }

        public void setTimeBins(int timeBins) {
            this.timeBins = timeBins;
        }

        public int getChannels() {
            return this.channels;
        }

        public void setChannels(int channels) {
            this.channels = channels;
        }

        public boolean mergeIntensity() {
            return this.mergeIntensity;
        }

        public void setMergeIntensity(boolean mergeIntensity) {
            if (mergeIntensity != this.mergeIntensity) {
                this.mergeIntensity = mergeIntensity;
                this.populateImageMetadata();
            }
        }

        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata iMeta = this.get(0);
            if (!this.mergeIntensity()) {
                iMeta.addAxis(SCIFIOAxes.LIFETIME, (long)this.getSDTInfo().timeBins);
                CalibratedAxis axis = iMeta.getAxis(SCIFIOAxes.LIFETIME);
                axis.setUnit("ns");
                double scale = this.getTimeBase() / (double)this.getSDTInfo().timeBins;
                FormatTools.calibrate((CalibratedAxis)iMeta.getAxis(SCIFIOAxes.LIFETIME), (double)scale, (double)0.0);
                iMeta.setPlanarAxisCount(3);
            }
            iMeta.addAxis(Axes.X, (long)this.getSDTInfo().width);
            iMeta.addAxis(Axes.Y, (long)this.getSDTInfo().height);
            iMeta.addAxis(SCIFIOAxes.SPECTRA, (long)this.channels);
            iMeta.setPixelType(3);
            iMeta.setLittleEndian(true);
            iMeta.setIndexed(false);
            iMeta.setFalseColor(false);
            iMeta.setMetadataComplete(true);
        }

        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.channels = 0;
                this.timeBins = 0;
                this.binOffset = 0;
                this.info = null;
            }
        }
    }
}

