/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.util.concurrent.atomic.AtomicBoolean;
import mpicbg.ij.InverseTransformMapping;
import mpicbg.models.InverseCoordinateTransform;

public class PaintInvertibleCoordinateTransformThread
extends Thread {
    protected final ImagePlus imp;
    protected final ImageProcessor source;
    protected final ImageProcessor target;
    protected final AtomicBoolean pleaseRepaint;
    protected final InverseCoordinateTransform transform;
    protected final InverseTransformMapping<?> mapping;

    public PaintInvertibleCoordinateTransformThread(ImagePlus imp, ImageProcessor source, ImageProcessor target, AtomicBoolean pleaseRepaint, InverseCoordinateTransform transform) {
        this.imp = imp;
        this.source = source;
        this.target = target;
        this.pleaseRepaint = pleaseRepaint;
        this.transform = transform;
        this.mapping = new InverseTransformMapping<InverseCoordinateTransform>(transform);
        this.setName("PaintInvertibleCoordinateTransformThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            try {
                if (this.pleaseRepaint.compareAndSet(true, false)) {
                    this.mapping.map(this.source, this.target);
                    this.imp.updateAndDraw();
                    continue;
                }
                PaintInvertibleCoordinateTransformThread paintInvertibleCoordinateTransformThread = this;
                synchronized (paintInvertibleCoordinateTransformThread) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

