/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.FloatProcessor;
import mpicbg.ij.integral.BlockStatistics;

public class RemoveOutliers
extends BlockStatistics {
    protected final FloatProcessor fpOriginal;

    public RemoveOutliers(FloatProcessor fp) {
        super(fp);
        this.fpOriginal = (FloatProcessor)fp.duplicate();
    }

    public void removeOutliers(int blockRadiusX, int blockRadiusY, float meanFactor) {
        int numSaturatedPixelsBefore;
        this.fp.setPixels(this.fpOriginal.getPixelsCopy());
        int width = this.fp.getWidth();
        int height = this.fp.getHeight();
        int wh = width * height;
        int w = width - 1;
        int h = height - 1;
        for (int y = 0; y < height; ++y) {
            int row = y * width;
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x < width; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                long bs = (xMax - xMin) * bh;
                double scale = 1.0 / (double)bs;
                double scale1 = 1.0 / (double)(bs - 1L);
                double scale2 = 1.0 / (double)(bs * bs - bs);
                double sum = this.sums.getDoubleSum(xMin, yMin, xMax, yMax);
                double var = scale1 * this.sumsOfSquares.getDoubleSum(xMin, yMin, xMax, yMax) - scale2 * sum * sum;
                int i = row + x;
                float mean = (float)(sum * scale);
                float std = var < 0.0 ? 0.0f : (float)Math.sqrt(var);
                float v = this.fp.getf(i);
                float min = mean - meanFactor * std;
                float max = mean + meanFactor * std;
                if (!(v < min) && !(v > max)) continue;
                this.fp.setf(i, Float.NaN);
            }
        }
        FloatProcessor fpCopy = (FloatProcessor)this.fp.duplicate();
        int numSaturatedPixels = 0;
        do {
            numSaturatedPixelsBefore = numSaturatedPixels;
            numSaturatedPixels = 0;
            for (int i = 0; i < wh; ++i) {
                float r;
                float l;
                float v = this.fp.getf(i);
                if (!Float.isNaN(v)) continue;
                ++numSaturatedPixels;
                int y = i / width;
                int x = i % width;
                float s = 0.0f;
                float n = 0.0f;
                if (y > 0) {
                    float tr;
                    float t;
                    float tl;
                    if (x > 0 && !Float.isNaN(tl = this.fp.getf(x - 1, y - 1))) {
                        s += 0.5f * tl;
                        n += 0.5f;
                    }
                    if (!Float.isNaN(t = this.fp.getf(x, y - 1))) {
                        s += t;
                        n += 1.0f;
                    }
                    if (x < w && !Float.isNaN(tr = this.fp.getf(x + 1, y - 1))) {
                        s += 0.5f * tr;
                        n += 0.5f;
                    }
                }
                if (x > 0 && !Float.isNaN(l = this.fp.getf(x - 1, y))) {
                    s += l;
                    n += 1.0f;
                }
                if (x < w && !Float.isNaN(r = this.fp.getf(x + 1, y))) {
                    s += r;
                    n += 1.0f;
                }
                if (y < h) {
                    float br;
                    float b;
                    float bl;
                    if (x > 0 && !Float.isNaN(bl = this.fp.getf(x - 1, y + 1))) {
                        s += 0.5f * bl;
                        n += 0.5f;
                    }
                    if (!Float.isNaN(b = this.fp.getf(x, y + 1))) {
                        s += b;
                        n += 1.0f;
                    }
                    if (x < w && !Float.isNaN(br = this.fp.getf(x + 1, y + 1))) {
                        s += 0.5f * br;
                        n += 0.5f;
                    }
                }
                if (!(n > 0.0f)) continue;
                fpCopy.setf(i, s / n);
            }
            this.fp.setPixels(fpCopy.getPixelsCopy());
        } while (numSaturatedPixels != numSaturatedPixelsBefore);
    }
}

