/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;

public class AffineModel2D
extends AbstractAffineModel2D<AffineModel2D> {
    private static final long serialVersionUID = 2323673888015396528L;
    protected static final int MIN_NUM_MATCHES = 3;
    protected double m00 = 1.0;
    protected double m10 = 0.0;
    protected double m01 = 0.0;
    protected double m11 = 1.0;
    protected double m02 = 0.0;
    protected double m12 = 0.0;
    protected double i00 = 1.0;
    protected double i10 = 0.0;
    protected double i01 = 0.0;
    protected double i11 = 1.0;
    protected double i02 = 0.0;
    protected double i12 = 0.0;
    private boolean isInvertible = true;

    @Override
    public final int getMinNumMatches() {
        return 3;
    }

    @Override
    public final AffineTransform createAffine() {
        return new AffineTransform(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
    }

    @Override
    public final AffineTransform createInverseAffine() {
        return new AffineTransform(this.i00, this.i10, this.i01, this.i11, this.i02, this.i12);
    }

    @Override
    public final double[] apply(double[] l) {
        assert (l.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(double[] l) {
        assert (l.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        double l0 = l[0];
        l[0] = l0 * this.m00 + l[1] * this.m01 + this.m02;
        l[1] = l0 * this.m10 + l[1] * this.m11 + this.m12;
    }

    @Override
    public final double[] applyInverse(double[] l) throws NoninvertibleModelException {
        assert (l.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        double[] transformed = (double[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(double[] l) throws NoninvertibleModelException {
        assert (l.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        double l0 = l[0];
        l[0] = l0 * this.i00 + l[1] * this.i01 + this.i02;
        l[1] = l0 * this.i10 + l[1] * this.i11 + this.i12;
    }

    @Override
    public final void fit(double[][] p, double[][] q, double[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 3) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d affine model, at least " + 3 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] qX = q[0];
            double[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * pX[i];
            pcy += ww * pY[i];
            qcx += ww * qX[i];
            qcy += ww * qY[i];
        }
        pcx /= ws;
        pcy /= ws;
        qcx /= ws;
        qcy /= ws;
        double b11 = 0.0;
        double b10 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a11 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] qX = q[0];
            double[] qY = q[1];
            double ww = w[i];
            double px = pX[i] - pcx;
            double py = pY[i] - pcy;
            double qx = qX[i] - qcx;
            double qy = qY[i] - qcy;
            a00 += ww * px * px;
            a01 += ww * px * py;
            a11 += ww * py * py;
            b00 += ww * px * qx;
            b01 += ww * px * qy;
            b10 += ww * py * qx;
            b11 += ww * py * qy;
        }
        double det = a00 * a11 - a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = (a11 * b00 - a01 * b10) / det;
        this.m01 = (a00 * b10 - a01 * b00) / det;
        this.m10 = (a11 * b01 - a01 * b11) / det;
        this.m11 = (a00 * b11 - a01 * b01) / det;
        this.m02 = qcx - this.m00 * pcx - this.m01 * pcy;
        this.m12 = qcy - this.m10 * pcx - this.m11 * pcy;
        this.invert();
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d affine transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 3) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d affine model, at least " + 3 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
        }
        pcx /= ws;
        pcy /= ws;
        qcx /= ws;
        qcy /= ws;
        double b11 = 0.0;
        double b10 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a11 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            double px = (double)pX[i] - pcx;
            double py = (double)pY[i] - pcy;
            double qx = (double)qX[i] - qcx;
            double qy = (double)qY[i] - qcy;
            a00 += ww * px * px;
            a01 += ww * px * py;
            a11 += ww * py * py;
            b00 += ww * px * qx;
            b01 += ww * px * qy;
            b10 += ww * py * qx;
            b11 += ww * py * qy;
        }
        double det = a00 * a11 - a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = (a11 * b00 - a01 * b10) / det;
        this.m01 = (a00 * b10 - a01 * b00) / det;
        this.m10 = (a11 * b01 - a01 * b11) / det;
        this.m11 = (a00 * b11 - a01 * b01) / det;
        this.m02 = qcx - this.m00 * pcx - this.m01 * pcy;
        this.m12 = qcy - this.m10 * pcx - this.m11 * pcy;
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 3) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 2d affine model, at least " + 3 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * p[0];
            pcy += w * p[1];
            qcx += w * q[0];
            qcy += w * q[1];
        }
        pcx /= ws;
        pcy /= ws;
        qcx /= ws;
        qcy /= ws;
        double b11 = 0.0;
        double b10 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a11 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            double px = p[0] - pcx;
            double py = p[1] - pcy;
            double qx = q[0] - qcx;
            double qy = q[1] - qcy;
            a00 += w * px * px;
            a01 += w * px * py;
            a11 += w * py * py;
            b00 += w * px * qx;
            b01 += w * px * qy;
            b10 += w * py * qx;
            b11 += w * py * qy;
        }
        double det = a00 * a11 - a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        this.m00 = (a11 * b00 - a01 * b10) / det;
        this.m01 = (a00 * b10 - a01 * b00) / det;
        this.m10 = (a11 * b01 - a01 * b11) / det;
        this.m11 = (a00 * b11 - a01 * b01) / det;
        this.m02 = qcx - this.m00 * pcx - this.m01 * pcy;
        this.m12 = qcy - this.m10 * pcx - this.m11 * pcy;
        this.invert();
    }

    @Override
    public final void set(AffineModel2D m) {
        this.m00 = m.m00;
        this.m01 = m.m01;
        this.m10 = m.m10;
        this.m11 = m.m11;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.invert();
        this.cost = m.getCost();
    }

    public final void reset() {
        this.m00 = 1.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
        this.m11 = 1.0;
        this.m02 = 0.0;
        this.m12 = 0.0;
        this.i00 = 1.0;
        this.i10 = 0.0;
        this.i01 = 0.0;
        this.i11 = 1.0;
        this.i02 = 0.0;
        this.i12 = 0.0;
        this.cost = Double.MAX_VALUE;
    }

    @Override
    public final void set(TranslationModel2D m) {
        this.reset();
        this.m02 = m.tx;
        this.m12 = m.ty;
        this.cost = m.getCost();
        this.invert();
    }

    @Override
    public final void set(RigidModel2D m) {
        this.m00 = m.cos;
        this.m01 = -m.sin;
        this.m02 = m.tx;
        this.m10 = m.sin;
        this.m11 = m.cos;
        this.m12 = m.ty;
        this.cost = m.getCost();
        this.invert();
    }

    @Override
    public final void set(SimilarityModel2D m) {
        this.m00 = m.scos;
        this.m01 = -m.ssin;
        this.m02 = m.tx;
        this.m10 = m.ssin;
        this.m11 = m.scos;
        this.m12 = m.ty;
        this.cost = m.getCost();
        this.invert();
    }

    @Override
    public AffineModel2D copy() {
        AffineModel2D m = new AffineModel2D();
        m.m00 = this.m00;
        m.m01 = this.m01;
        m.m10 = this.m10;
        m.m11 = this.m11;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.cost = this.cost;
        m.invert();
        return m;
    }

    protected final void invert() {
        double det = this.m00 * this.m11 - this.m01 * this.m10;
        if (det == 0.0) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        this.i00 = this.m11 / det;
        this.i01 = -this.m01 / det;
        this.i02 = (this.m01 * this.m12 - this.m02 * this.m11) / det;
        this.i10 = -this.m10 / det;
        this.i11 = this.m00 / det;
        this.i12 = (this.m02 * this.m10 - this.m00 * this.m12) / det;
    }

    @Override
    public final void preConcatenate(AffineModel2D model) {
        double a00 = model.m00 * this.m00 + model.m01 * this.m10;
        double a01 = model.m00 * this.m01 + model.m01 * this.m11;
        double a02 = model.m00 * this.m02 + model.m01 * this.m12 + model.m02;
        double a10 = model.m10 * this.m00 + model.m11 * this.m10;
        double a11 = model.m10 * this.m01 + model.m11 * this.m11;
        double a12 = model.m10 * this.m02 + model.m11 * this.m12 + model.m12;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.invert();
    }

    @Override
    public final void concatenate(TranslationModel2D model) {
        this.m02 = this.m00 * model.tx + this.m01 * model.ty + this.m02;
        this.m12 = this.m10 * model.tx + this.m11 * model.ty + this.m12;
        this.invert();
    }

    @Override
    public final void preConcatenate(TranslationModel2D model) {
        this.m02 += model.tx;
        this.m12 += model.ty;
        this.invert();
    }

    @Override
    public final void concatenate(AffineModel2D model) {
        double a00 = this.m00 * model.m00 + this.m01 * model.m10;
        double a01 = this.m00 * model.m01 + this.m01 * model.m11;
        double a02 = this.m00 * model.m02 + this.m01 * model.m12 + this.m02;
        double a10 = this.m10 * model.m00 + this.m11 * model.m10;
        double a11 = this.m10 * model.m01 + this.m11 * model.m11;
        double a12 = this.m10 * model.m02 + this.m11 * model.m12 + this.m12;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.invert();
    }

    public final void set(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
        this.invert();
    }

    @Override
    public final void set(AffineTransform a) {
        this.m00 = a.getScaleX();
        this.m10 = a.getShearY();
        this.m01 = a.getShearX();
        this.m11 = a.getScaleY();
        this.m02 = a.getTranslateX();
        this.m12 = a.getTranslateY();
        this.invert();
    }

    @Override
    public AffineModel2D createInverse() {
        AffineModel2D ict = new AffineModel2D();
        ict.m00 = this.i00;
        ict.m10 = this.i10;
        ict.m01 = this.i01;
        ict.m11 = this.i11;
        ict.m02 = this.i02;
        ict.m12 = this.i12;
        ict.i00 = this.m00;
        ict.i10 = this.m10;
        ict.i01 = this.m01;
        ict.i11 = this.m11;
        ict.i02 = this.m02;
        ict.i12 = this.m12;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m01;
        data[3] = this.m11;
        data[4] = this.m02;
        data[5] = this.m12;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][2] = this.m12;
    }
}

