/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.kdtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import mpicbg.imglib.algorithm.kdtree.DistanceComparator;
import mpicbg.imglib.algorithm.kdtree.KDTree;
import mpicbg.imglib.algorithm.kdtree.NNearestNeighborSearch;
import mpicbg.imglib.algorithm.kdtree.NearestNeighborSearch;
import mpicbg.imglib.algorithm.kdtree.RadiusNeighborSearch;
import mpicbg.imglib.algorithm.kdtree.node.SimpleNode;

public class TestKDTree {
    protected static boolean testNNearestNeighbor(int neighbors, int numDimensions, int numPoints, int numTests, float min, float max) {
        ArrayList<SimpleNode> points = new ArrayList<SimpleNode>();
        Random rnd = new Random(435435435L);
        float[] p = new float[numDimensions];
        for (int i = 0; i < numPoints; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (max - min) + min;
            }
            SimpleNode t = new SimpleNode(p);
            points.add(t);
        }
        long start = System.currentTimeMillis();
        KDTree kdTree = new KDTree(points);
        NNearestNeighborSearch kd = new NNearestNeighborSearch(kdTree);
        long kdSetupTime = System.currentTimeMillis() - start;
        System.out.println("kdtree setup took: " + kdSetupTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode[] nnKdtree = (SimpleNode[])kd.findNNearestNeighbors(t, neighbors);
            SimpleNode[] nnExhaustive = TestKDTree.findNNearestNeighborExhaustive(points, t, neighbors);
            for (int j = 0; j < neighbors; ++j) {
                if (nnKdtree[j].equals(nnExhaustive[j])) continue;
                System.out.println(j + 1 + " - Nearest neighbor to: " + t);
                System.out.println("KD-Tree says: " + nnKdtree[j] + " (" + nnKdtree[j].distanceTo(t) + ")");
                System.out.println("Exhaustive says: " + nnExhaustive[j] + " (" + nnExhaustive[j].distanceTo(t) + ")");
                return false;
            }
        }
        long compareTime = System.currentTimeMillis() - start;
        System.out.println("comparison (kd-exhaustive) search took: " + compareTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
        }
        long initTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode[] nnKdtree = (SimpleNode[])kd.findNNearestNeighbors(t, neighbors);
            nnKdtree.clone();
        }
        long kdTime = System.currentTimeMillis() - start;
        System.out.println("kdtree search took: " + (kdTime - initTime) + " ms.");
        System.out.println("kdtree all together took: " + (kdSetupTime + kdTime - initTime) + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode[] nnExhaustive = TestKDTree.findNNearestNeighborExhaustive(points, t, neighbors);
            nnExhaustive.clone();
        }
        long exhaustiveTime = System.currentTimeMillis() - start;
        System.out.println("exhaustive search took: " + (exhaustiveTime - initTime) + " ms.");
        return true;
    }

    protected static boolean testRadiusSearch(int numDimensions, int numPoints, int numTests, float min, float max) {
        SimpleNode t;
        ArrayList<SimpleNode> points = new ArrayList<SimpleNode>();
        Random rnd = new Random(435435435L);
        float[] p = new float[numDimensions];
        for (int i = 0; i < numPoints; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (max - min) + min;
            }
            SimpleNode t2 = new SimpleNode(p);
            points.add(t2);
        }
        long start = System.currentTimeMillis();
        KDTree kdTree = new KDTree(points);
        RadiusNeighborSearch kd = new RadiusNeighborSearch(kdTree);
        long kdSetupTime = System.currentTimeMillis() - start;
        System.out.println("kdtree setup took: " + kdSetupTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            double radius = rnd.nextDouble() * (double)(max - min) / 10.0;
            t = new SimpleNode(p);
            ArrayList<SimpleNode> radiusKdtree = kd.findNeighborsSorted(t, radius);
            ArrayList<SimpleNode> radiusExhaustive = TestKDTree.findNeighborsRadiusExhaustive(points, t, radius);
            if (radiusKdtree.size() != radiusExhaustive.size()) {
                System.out.println("Not same number of points within radius(" + radius + ") of " + t + " found, kdTree = " + radiusKdtree.size() + ", exhaustive = " + radiusExhaustive.size());
                System.out.println("KDTree:");
                for (SimpleNode n : radiusKdtree) {
                    System.out.println(n + ", distance: " + n.distanceTo(t));
                }
                System.out.println("Exhaustive:");
                for (SimpleNode n : radiusExhaustive) {
                    System.out.println(n + ", distance: " + n.distanceTo(t));
                }
                return false;
            }
            boolean success = true;
            for (int j = 0; j < radiusKdtree.size(); ++j) {
                if (radiusKdtree.get(j) == radiusExhaustive.get(j) || radiusKdtree.get(j).distanceTo(t) == radiusExhaustive.get(j).distanceTo(t)) continue;
                System.out.println("Point " + j + " disagrees within radius(" + radius + ") of " + t + " found, \n\tkdTree = " + radiusKdtree.get(j) + ", distance: " + radiusKdtree.get(j).distanceTo(t) + ", \n\texhaustive = " + radiusExhaustive.get(j) + ", distance: " + radiusExhaustive.get(j).distanceTo(t));
                success = false;
            }
            if (success) continue;
            return false;
        }
        long compareTime = System.currentTimeMillis() - start;
        System.out.println("comparison (kdtree <-> exhaustive) successfull, took: " + compareTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            t = new SimpleNode(p);
            t.getClass();
        }
        long initTime = System.currentTimeMillis() - start;
        double radius = (max - min) / 20.0f;
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (max - min) + min;
            }
            SimpleNode t3 = new SimpleNode(p);
            ArrayList<SimpleNode> nnKdtree = kd.findNeighborsSorted(t3, radius);
            nnKdtree.getClass();
        }
        long kdTime = System.currentTimeMillis() - start;
        System.out.println("kdtree search took: " + (kdTime - initTime) + " ms.");
        System.out.println("kdtree all together took: " + (kdSetupTime + kdTime - initTime) + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (max - min) + min;
            }
            SimpleNode t4 = new SimpleNode(p);
            ArrayList<SimpleNode> nnExhaustive = TestKDTree.findNeighborsRadiusExhaustive(points, t4, radius);
            nnExhaustive.getClass();
        }
        long exhaustiveTime = System.currentTimeMillis() - start;
        System.out.println("exhaustive search took: " + (exhaustiveTime - initTime) + " ms.");
        return true;
    }

    protected static boolean testNearestNeighbor(int numDimensions, int numPoints, int numTests, float min, float max) {
        ArrayList<SimpleNode> points = new ArrayList<SimpleNode>();
        Random rnd = new Random(435435435L);
        float[] p = new float[numDimensions];
        for (int i = 0; i < numPoints; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (max - min) + min;
            }
            SimpleNode t = new SimpleNode(p);
            points.add(t);
        }
        long start = System.currentTimeMillis();
        KDTree kdTree = new KDTree(points);
        NearestNeighborSearch kd = new NearestNeighborSearch(kdTree);
        long kdSetupTime = System.currentTimeMillis() - start;
        System.out.println("kdtree setup took: " + kdSetupTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            SimpleNode nnExhaustive;
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode nnKdtree = kd.findNearestNeighbor(t);
            if (nnKdtree.equals(nnExhaustive = TestKDTree.findNearestNeighborExhaustive(points, t))) continue;
            System.out.println("Nearest neighbor to: " + t);
            System.out.println("KD-Tree says: " + nnKdtree);
            System.out.println("Exhaustive says: " + nnExhaustive);
            return false;
        }
        long compareTime = System.currentTimeMillis() - start;
        System.out.println("comparison (kdtree <-> exhaustive) search took: " + compareTime + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            t.getClass();
        }
        long initTime = System.currentTimeMillis() - start;
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode nnKdtree = kd.findNearestNeighbor(t);
            nnKdtree.getClass();
        }
        long kdTime = System.currentTimeMillis() - start;
        System.out.println("kdtree search took: " + (kdTime - initTime) + " ms.");
        System.out.println("kdtree all together took: " + (kdSetupTime + kdTime - initTime) + " ms.");
        start = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            for (int d = 0; d < numDimensions; ++d) {
                p[d] = rnd.nextFloat() * (2.0f * max - 2.0f * min) + 2.0f * min;
            }
            SimpleNode t = new SimpleNode(p);
            SimpleNode nnExhaustive = TestKDTree.findNearestNeighborExhaustive(points, t);
            nnExhaustive.getClass();
        }
        long exhaustiveTime = System.currentTimeMillis() - start;
        System.out.println("exhaustive search took: " + (exhaustiveTime - initTime) + " ms.");
        return true;
    }

    private static SimpleNode findNearestNeighborExhaustive(ArrayList<SimpleNode> points, SimpleNode t) {
        float minDistance = Float.MAX_VALUE;
        SimpleNode nearest = null;
        for (SimpleNode n : points) {
            float dist = n.distanceTo(t);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            nearest = n;
        }
        return new SimpleNode(nearest);
    }

    private static ArrayList<SimpleNode> findNeighborsRadiusExhaustive(ArrayList<SimpleNode> points, SimpleNode t, double radius) {
        ArrayList<SimpleNode> withinRadius = new ArrayList<SimpleNode>();
        for (SimpleNode n : points) {
            float dist = n.distanceTo(t);
            if (!((double)dist <= radius)) continue;
            withinRadius.add(n);
        }
        Collections.sort(withinRadius, new DistanceComparator<SimpleNode>(t));
        return withinRadius;
    }

    private static SimpleNode[] findNNearestNeighborExhaustive(ArrayList<SimpleNode> points, SimpleNode t, int n) {
        SimpleNode[] nearest = new SimpleNode[n];
        float[] minDistance = new float[n];
        for (int i = 0; i < n; ++i) {
            minDistance[i] = Float.MAX_VALUE;
        }
        block1: for (SimpleNode node : points) {
            float dist = node.distanceTo(t);
            for (int i = 0; i < n; ++i) {
                if (!(dist < minDistance[i])) continue;
                for (int j = n - 2; j >= i; --j) {
                    nearest[j + 1] = nearest[j];
                    minDistance[j + 1] = minDistance[j];
                }
                nearest[i] = node;
                minDistance[i] = dist;
                continue block1;
            }
        }
        return nearest;
    }

    public static void main(String[] args) {
        if (TestKDTree.testRadiusSearch(3, 100000, 1000, -100.0f, 100.0f)) {
            System.out.println("Radius neighbor test (3) successfull\n");
        }
        if (TestKDTree.testNNearestNeighbor(3, 3, 100000, 1000, -5.0f, 5.0f)) {
            System.out.println("N-Nearest neighbor test (3) successfull\n");
        }
        if (TestKDTree.testNearestNeighbor(3, 100000, 1000, -5.0f, 5.0f)) {
            System.out.println("Nearest neighbor test successfull\n");
        }
    }
}

