/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.pde;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.MultiThreadedBenchmarkAlgorithm;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.RealType;

public class AnisotropicDiffusion<T extends RealType<T>>
extends MultiThreadedBenchmarkAlgorithm {
    private Image<T> image;
    private double deltat;
    private DiffusionFunction fun;
    private int[] dimensions;

    public AnisotropicDiffusion(Image<T> image, double deltat, DiffusionFunction function) {
        this.image = image;
        this.deltat = deltat;
        this.fun = function;
        this.processingTime = 0L;
        this.dimensions = new int[image.getNumDimensions()];
        for (int i = 0; i < this.dimensions.length; ++i) {
            this.dimensions[i] = i;
        }
    }

    public AnisotropicDiffusion(Image<T> image, double deltat, double kappa) {
        this(image, deltat, new StrongEdgeEnhancer(kappa));
    }

    @Override
    public boolean checkInput() {
        if (this.deltat <= 0.0) {
            this.errorMessage = "Time interval must bu strictly positive, got " + this.deltat + ".";
            return false;
        }
        return true;
    }

    @Override
    public boolean process() {
        long start = System.currentTimeMillis();
        final int ndim = this.dimensions.length;
        final double nneighbors = Math.pow(3.0, ndim) - 1.0;
        final AtomicInteger ai = new AtomicInteger(0);
        final Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(this.image.getNumPixels(), this.numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(this.numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void run() {
                    centralPosition = new int[ndim];
                    position = new int[ndim];
                    mainCursor = AnisotropicDiffusion.access$000(AnisotropicDiffusion.this).createLocalizableCursor();
                    cursor = AnisotropicDiffusion.access$000(AnisotropicDiffusion.this).createLocalizableByDimCursor(new OutOfBoundsStrategyMirrorFactory<T>());
                    threadNumber = ai.getAndIncrement();
                    chunk = (Chunk)chunks.get(threadNumber);
                    increment = (RealType)((RealType)mainCursor.getType()).createVariable();
                    mainCursor.fwd(chunk.getStartPosition());
                    for (j = 0L; j < chunk.getLoopSize(); ++j) {
                        mainCursor.fwd();
                        cursor.setPosition(mainCursor);
                        centralValue = (RealType)mainCursor.getType();
                        for (dim = 0; dim < ndim; ++dim) {
                            centralPosition[dim] = mainCursor.getPosition(AnisotropicDiffusion.access$100(AnisotropicDiffusion.this)[dim]);
                            position[dim] = -1;
                        }
                        position[0] = -2;
                        amount = 0.0;
                        while (true) {
                            for (dim = 0; dim < ndim; ++dim) {
                                if (position[dim] < 1) {
                                    v0 = dim;
                                    position[v0] = position[v0] + 1;
                                    break;
                                }
                                position[dim] = -1;
                            }
                            for (dim = 0; dim < ndim; ++dim) {
                                cursor.setPosition(centralPosition[dim] + position[dim], AnisotropicDiffusion.access$100(AnisotropicDiffusion.this)[dim]);
                            }
                            dx2 = 0.0;
                            for (dim = 0; dim < ndim; ++dim) {
                                dx2 += (double)(position[dim] * position[dim]);
                            }
                            if (dx2 == 0.0) ** continue;
                            di = ((RealType)cursor.getType()).getRealDouble() - centralValue.getRealDouble();
                            g = AnisotropicDiffusion.access$200(AnisotropicDiffusion.this).eval(di, position);
                            amount += 1.0 / dx2 * g * di;
                            finished = true;
                            for (dim = 0; dim < ndim; ++dim) {
                                if (position[dim] == 1) continue;
                                finished = false;
                                break;
                            }
                            if (finished) break;
                        }
                        increment.setReal(AnisotropicDiffusion.access$300(AnisotropicDiffusion.this) * amount / nneighbors);
                        ((RealType)mainCursor.getType()).add(increment);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        long end = System.currentTimeMillis();
        this.processingTime += end - start;
        return true;
    }

    public void setDeltaT(float deltat) {
        this.deltat = deltat;
    }

    public void setDiffusionFunction(DiffusionFunction function) {
        this.fun = function;
    }

    public void setDimensions(int[] dimensions) {
        this.dimensions = dimensions;
    }

    static /* synthetic */ Image access$000(AnisotropicDiffusion x0) {
        return x0.image;
    }

    static /* synthetic */ int[] access$100(AnisotropicDiffusion x0) {
        return x0.dimensions;
    }

    static /* synthetic */ DiffusionFunction access$200(AnisotropicDiffusion x0) {
        return x0.fun;
    }

    static /* synthetic */ double access$300(AnisotropicDiffusion x0) {
        return x0.deltat;
    }

    public static class WideRegionEnhancer
    implements DiffusionFunction {
        private double kappa;

        public WideRegionEnhancer(double kappa) {
            this.kappa = kappa;
        }

        @Override
        public double eval(double gradi, int[] position) {
            return 1.0 / (1.0 + gradi * gradi / this.kappa / this.kappa);
        }
    }

    public static class StrongEdgeEnhancer
    implements DiffusionFunction {
        private double kappa;

        public StrongEdgeEnhancer(double kappa) {
            this.kappa = kappa;
        }

        @Override
        public double eval(double gradi, int[] position) {
            return Math.exp(-(gradi * gradi / this.kappa / this.kappa));
        }
    }

    public static interface DiffusionFunction {
        public double eval(double var1, int[] var3);
    }
}

