/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.peak;

import Jama.Matrix;
import mpicbg.imglib.algorithm.peak.FitFunction;

public class LevenbergMarquardtSolver {
    public static final double chiSquared(double[][] x, double[] a, double[] y, FitFunction f) {
        int npts = y.length;
        double sum = 0.0;
        for (int i = 0; i < npts; ++i) {
            double d = y[i] - f.val(x[i], a);
            sum += d * d;
        }
        return sum;
    }

    public static final int solve(double[][] x, double[] a, double[] y, FitFunction f, double lambda, double termepsilon, int maxiter) throws Exception {
        int npts = y.length;
        int nparm = a.length;
        double e0 = LevenbergMarquardtSolver.chiSquared(x, a, y, f);
        boolean done = false;
        double[][] H = new double[nparm][nparm];
        double[] g = new double[nparm];
        int iter = 0;
        int term = 0;
        do {
            int r;
            ++iter;
            for (r = 0; r < nparm; ++r) {
                for (int c = 0; c < nparm; ++c) {
                    H[r][c] = 0.0;
                    for (int i = 0; i < npts; ++i) {
                        double[] xi = x[i];
                        double[] dArray = H[r];
                        int n = c;
                        dArray[n] = dArray[n] + f.grad(xi, a, r) * f.grad(xi, a, c);
                    }
                }
            }
            r = 0;
            while (r < nparm) {
                double[] dArray = H[r];
                int n = r++;
                dArray[n] = dArray[n] * (1.0 + lambda);
            }
            for (r = 0; r < nparm; ++r) {
                g[r] = 0.0;
                for (int i = 0; i < npts; ++i) {
                    double[] xi = x[i];
                    int n = r;
                    g[n] = g[n] + (y[i] - f.val(xi, a)) * f.grad(xi, a, r);
                }
            }
            double[] d = null;
            try {
                d = new Matrix(H).lu().solve(new Matrix(g, nparm)).getRowPackedCopy();
            }
            catch (RuntimeException re) {
                lambda *= 10.0;
                continue;
            }
            double[] na = new Matrix(a, nparm).plus(new Matrix(d, nparm)).getRowPackedCopy();
            double e1 = LevenbergMarquardtSolver.chiSquared(x, na, y, f);
            if (Math.abs(e1 - e0) > termepsilon) {
                term = 0;
            } else if (++term == 4) {
                done = true;
            }
            if (iter >= maxiter) {
                done = true;
            }
            if (e1 > e0 || Double.isNaN(e1)) {
                lambda *= 10.0;
                continue;
            }
            lambda *= 0.1;
            e0 = e1;
            for (int i = 0; i < nparm; ++i) {
                a[i] = na[i];
            }
        } while (!done);
        return iter;
    }
}

