/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.scalespace;

import mpicbg.imglib.algorithm.kdtree.node.Leaf;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.cursor.Localizable;
import mpicbg.imglib.type.numeric.NumericType;
import mpicbg.imglib.util.Util;

public class DifferenceOfGaussianPeak<T extends NumericType<T>>
implements Localizable,
Leaf<DifferenceOfGaussianPeak<T>> {
    DifferenceOfGaussian.SpecialPoint specialPoint;
    String errorMessage;
    protected final int[] pixelLocation;
    protected final float[] subPixelLocationOffset;
    protected final T value;
    protected final T fitValue;
    protected final T sumValue;
    final int numDimensions;

    public DifferenceOfGaussianPeak(int[] pixelLocation, T value, DifferenceOfGaussian.SpecialPoint specialPoint) {
        this.specialPoint = specialPoint;
        this.pixelLocation = (int[])pixelLocation.clone();
        this.subPixelLocationOffset = new float[pixelLocation.length];
        this.numDimensions = pixelLocation.length;
        this.value = (NumericType)value.copy();
        this.sumValue = (NumericType)value.copy();
        this.fitValue = (NumericType)value.createVariable();
        this.fitValue.setZero();
        this.errorMessage = "";
    }

    public DifferenceOfGaussianPeak<T> copy() {
        DifferenceOfGaussianPeak<T> copy = new DifferenceOfGaussianPeak<T>(this.pixelLocation, this.value, this.specialPoint);
        copy.setFitValue(this.fitValue);
        copy.setSubPixelLocationOffset(this.subPixelLocationOffset);
        return copy;
    }

    public boolean isMin() {
        return this.specialPoint == DifferenceOfGaussian.SpecialPoint.MIN;
    }

    public boolean isMax() {
        return this.specialPoint == DifferenceOfGaussian.SpecialPoint.MAX;
    }

    public boolean isValid() {
        return this.specialPoint != DifferenceOfGaussian.SpecialPoint.INVALID;
    }

    public DifferenceOfGaussian.SpecialPoint getPeakType() {
        return this.specialPoint;
    }

    public float[] getSubPixelPositionOffset() {
        return (float[])this.subPixelLocationOffset.clone();
    }

    public float getSubPixelPositionOffset(int dim) {
        return this.subPixelLocationOffset[dim];
    }

    public float[] getSubPixelPosition() {
        float[] loc = (float[])this.subPixelLocationOffset.clone();
        for (int d = 0; d < loc.length; ++d) {
            int n = d;
            loc[n] = loc[n] + (float)this.pixelLocation[d];
        }
        return loc;
    }

    public void getSubPixelPosition(float[] loc) {
        for (int d = 0; d < loc.length; ++d) {
            loc[d] = this.subPixelLocationOffset[d] + (float)this.pixelLocation[d];
        }
    }

    public float getSubPixelPosition(int dim) {
        return this.subPixelLocationOffset[dim] + (float)this.pixelLocation[dim];
    }

    public T getValue() {
        return this.sumValue;
    }

    public T getImgValue() {
        return this.value;
    }

    public T getFitValue() {
        return this.fitValue;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setPeakType(DifferenceOfGaussian.SpecialPoint specialPoint) {
        this.specialPoint = specialPoint;
    }

    public void setSubPixelLocationOffset(float subPixelLocationOffset, int dim) {
        this.subPixelLocationOffset[dim] = subPixelLocationOffset;
    }

    public void setSubPixelLocationOffset(float[] subPixelLocationOffset) {
        for (int d = 0; d < this.pixelLocation.length; ++d) {
            this.subPixelLocationOffset[d] = subPixelLocationOffset[d];
        }
    }

    public void setPixelLocation(int location, int dim) {
        this.pixelLocation[dim] = location;
    }

    public void setPixelLocation(int[] pixelLocation) {
        for (int d = 0; d < pixelLocation.length; ++d) {
            this.pixelLocation[d] = pixelLocation[d];
        }
    }

    public void setImgValue(T value) {
        this.value.set(value);
        this.sumValue.set(this.value);
        this.sumValue.add(this.fitValue);
    }

    public void setFitValue(T value) {
        this.fitValue.set(value);
        this.sumValue.set(this.value);
        this.sumValue.add(this.fitValue);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.pixelLocation.length; ++d) {
            position[d] = this.pixelLocation[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.pixelLocation.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.pixelLocation[dim];
    }

    @Override
    public String getPositionAsString() {
        return Util.printCoordinates(this.pixelLocation);
    }

    @Override
    public void fwd(long steps) {
    }

    @Override
    public void fwd() {
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public float get(int k) {
        return this.getSubPixelPosition(k);
    }

    @Override
    public float distanceTo(DifferenceOfGaussianPeak<T> other) {
        double sum = 0.0;
        for (int d = 0; d < this.numDimensions; ++d) {
            double tmp = other.get(d) - this.get(d);
            sum += tmp * tmp;
        }
        return (float)Math.sqrt(sum);
    }

    @Override
    public int getNumDimensions() {
        return this.numDimensions;
    }

    public DifferenceOfGaussianPeak<T>[] createArray(int n) {
        return new DifferenceOfGaussianPeak[n];
    }

    @Override
    public DifferenceOfGaussianPeak<T> getEntry() {
        return this;
    }
}

