/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.array;

import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.cursor.LocalizablePlaneCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.Type;

public class ArrayLocalizablePlaneCursor<T extends Type<T>>
extends ArrayLocalizableCursor<T>
implements LocalizablePlaneCursor<T> {
    protected int planeDimA;
    protected int planeDimB;
    protected int planeSizeA;
    protected int planeSizeB;
    protected int incPlaneA;
    protected int incPlaneB;
    protected int maxI;

    public ArrayLocalizablePlaneCursor(Array<T, ?> container, Image<T> image, T type) {
        super(container, image, type);
    }

    @Override
    public boolean hasNext() {
        return this.type.getIndex() < this.maxI;
    }

    @Override
    public void fwd() {
        if (this.position[this.planeDimA] < this.dimensions[this.planeDimA] - 1) {
            int n = this.planeDimA;
            this.position[n] = this.position[n] + 1;
            this.type.incIndex(this.incPlaneA);
        } else if (this.position[this.planeDimB] < this.dimensions[this.planeDimB] - 1) {
            this.position[this.planeDimA] = 0;
            int n = this.planeDimB;
            this.position[n] = this.position[n] + 1;
            this.type.incIndex(this.incPlaneB);
            this.type.decIndex((this.planeSizeA - 1) * this.incPlaneA);
        }
    }

    @Override
    public void reset(int planeDimA, int planeDimB, int[] dimensionPositions) {
        this.planeDimA = planeDimA;
        this.planeDimB = planeDimB;
        this.planeSizeA = this.container.getDimension(planeDimA);
        this.planeSizeB = this.container.getDimension(planeDimB);
        int[] steps = Array.createAllocationSteps(this.container.getDimensions());
        int[] dimPos = (int[])dimensionPositions.clone();
        this.incPlaneA = steps[planeDimA];
        dimPos[planeDimA] = 0;
        if (planeDimB > -1 && planeDimB < steps.length) {
            this.incPlaneB = steps[planeDimB];
            dimPos[planeDimB] = 0;
        } else {
            this.incPlaneB = 0;
        }
        this.setPosition(dimPos);
        this.isClosed = false;
        this.type.decIndex(this.incPlaneA);
        this.position[planeDimA] = -1;
        dimPos[planeDimA] = this.dimensions[planeDimA] - 1;
        if (planeDimB > -1 && planeDimB < steps.length) {
            dimPos[planeDimB] = this.dimensions[planeDimB] - 1;
        }
        this.maxI = this.container.getPos(dimPos);
        this.type.updateContainer(this);
    }

    @Override
    public void reset(int planeDimA, int planeDimB) {
        if (this.dimensions == null) {
            return;
        }
        this.reset(planeDimA, planeDimB, new int[this.numDimensions]);
    }

    @Override
    public void reset() {
        if (this.dimensions == null) {
            return;
        }
        this.reset(0, 1, new int[this.numDimensions]);
    }

    @Override
    public void getPosition(int[] position) {
        for (int d = 0; d < this.numDimensions; ++d) {
            position[d] = this.position[d];
        }
    }

    @Override
    public int[] getPosition() {
        return (int[])this.position.clone();
    }

    @Override
    public int getPosition(int dim) {
        return this.position[dim];
    }

    protected void setPosition(int[] position) {
        this.type.updateIndex(this.container.getPos(position));
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
        }
    }
}

