/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.interpolation.lanczos;

import mpicbg.imglib.image.Image;
import mpicbg.imglib.interpolation.InterpolatorFactory;
import mpicbg.imglib.interpolation.lanczos.LanczosInterpolator;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.numeric.RealType;

public class LanczosInterpolatorFactory<T extends RealType<T>>
extends InterpolatorFactory<T> {
    int alpha;
    boolean clipping;

    public LanczosInterpolatorFactory(OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory, int alpha, boolean clipping) {
        super(outOfBoundsStrategyFactory);
        this.alpha = alpha;
        this.clipping = clipping;
    }

    public LanczosInterpolatorFactory(OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        this(outOfBoundsStrategyFactory, 3, true);
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setClipping(boolean clipping) {
        this.clipping = clipping;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public boolean getClipping() {
        return this.clipping;
    }

    @Override
    public LanczosInterpolator<T> createInterpolator(Image<T> img) {
        return new LanczosInterpolator<T>(img, this, this.outOfBoundsStrategyFactory, this.alpha, this.clipping);
    }
}

