/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.outofbounds;

import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.util.Util;

public class OutOfBoundsStrategyMirrorExpWindowing<T extends RealType<T>>
extends OutOfBoundsStrategy<T> {
    final LocalizableCursor<T> parentCursor;
    final LocalizableByDimCursor<T> mirrorCursor;
    final T type;
    final T mirrorType;
    final int numDimensions;
    final int[] dimension;
    final int[] position;
    final int[] mirroredPosition;
    final int[] currentDirection;
    final int[] tmp;
    final float[][] weights;
    final float cutOff = 1.0E-4f;

    public OutOfBoundsStrategyMirrorExpWindowing(LocalizableCursor<T> parentCursor, int[] fadeOutDistance, float exponent) {
        super(parentCursor);
        int d;
        this.parentCursor = parentCursor;
        this.mirrorCursor = parentCursor.getImage().createLocalizableByDimCursor();
        this.mirrorType = (RealType)this.mirrorCursor.getType();
        this.type = (RealType)this.mirrorType.createVariable();
        this.numDimensions = parentCursor.getImage().getNumDimensions();
        this.dimension = parentCursor.getImage().getDimensions();
        this.position = new int[this.numDimensions];
        this.mirroredPosition = new int[this.numDimensions];
        this.currentDirection = new int[this.numDimensions];
        this.tmp = new int[this.numDimensions];
        this.weights = new float[this.numDimensions][];
        for (d = 0; d < this.numDimensions; ++d) {
            this.weights[d] = new float[Math.max(1, fadeOutDistance[d])];
        }
        for (d = 0; d < this.numDimensions; ++d) {
            int maxDistance = this.weights[d].length;
            if (maxDistance > 1) {
                for (int pos = 0; pos < maxDistance; ++pos) {
                    float relPos = (float)pos / (float)(maxDistance - 1);
                    this.weights[d][pos] = Util.isApproxEqual(exponent, 1.0f, 1.0E-4f) ? 1.0f - relPos : (float)(1.0 - 1.0 / Math.pow(exponent, 1.0f - relPos)) * (1.0f + 1.0f / (exponent - 1.0f));
                }
                continue;
            }
            this.weights[d][0] = 0.0f;
        }
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public final void notifyOutOfBOunds() {
        int d;
        this.parentCursor.getPosition(this.position);
        this.getMirrorCoordinate(this.position, this.mirroredPosition);
        this.mirrorCursor.setPosition(this.mirroredPosition);
        this.type.set(this.mirrorType);
        this.type.mul(this.getWeight(this.position));
        for (d = 0; d < this.numDimensions; ++d) {
            this.tmp[d] = this.position[d] + 1;
        }
        this.getMirrorCoordinate(this.tmp, this.currentDirection);
        for (d = 0; d < this.numDimensions; ++d) {
            this.currentDirection[d] = this.currentDirection[d] - this.mirroredPosition[d];
        }
    }

    protected final float getWeight(int[] position) {
        float weight = 1.0f;
        for (int d = 0; d < this.numDimensions; ++d) {
            int distance;
            int pos = position[d];
            if (pos < 0) {
                distance = -pos - 1;
            } else {
                if (pos < this.dimension[d]) continue;
                distance = pos - this.dimension[d];
            }
            if (distance < this.weights[d].length) {
                weight *= this.weights[d][distance];
                continue;
            }
            return 0.0f;
        }
        return weight;
    }

    @Override
    public void notifyOutOfBOunds(int steps, int dim) {
        if (Math.abs(steps) > 10) {
            this.notifyOutOfBOunds();
        } else if (steps > 0) {
            for (int i = 0; i < steps; ++i) {
                this.notifyOutOfBOundsFwd(dim);
            }
        } else {
            for (int i = 0; i < -steps; ++i) {
                this.notifyOutOfBOundsBck(dim);
            }
        }
    }

    @Override
    public void notifyOutOfBOundsFwd(int dim) {
        if (this.currentDirection[dim] == 1) {
            if (this.mirrorCursor.getPosition(dim) + 1 == this.dimension[dim]) {
                this.mirrorCursor.bck(dim);
                this.currentDirection[dim] = -1;
            } else {
                this.mirrorCursor.fwd(dim);
            }
        } else if (this.mirrorCursor.getPosition(dim) == 0) {
            this.currentDirection[dim] = 1;
            this.mirrorCursor.fwd(dim);
        } else {
            this.mirrorCursor.bck(dim);
        }
        this.type.set(this.mirrorType);
        this.parentCursor.getPosition(this.position);
        this.type.mul(this.getWeight(this.position));
    }

    @Override
    public void notifyOutOfBOundsBck(int dim) {
        if (this.currentDirection[dim] == 1) {
            if (this.mirrorCursor.getPosition(dim) == 0) {
                this.mirrorCursor.fwd(dim);
                this.currentDirection[dim] = -1;
            } else {
                this.mirrorCursor.bck(dim);
            }
        } else if (this.mirrorCursor.getPosition(dim) + 1 == this.dimension[dim]) {
            this.mirrorCursor.bck(dim);
            this.currentDirection[dim] = 1;
        } else {
            this.mirrorCursor.fwd(dim);
        }
        this.type.set(this.mirrorType);
        this.parentCursor.getPosition(this.position);
        this.type.mul(this.getWeight(this.position));
    }

    @Override
    public void initOutOfBOunds() {
        this.notifyOutOfBOunds();
    }

    protected void getMirrorCoordinate(int[] position, int[] mirroredPosition) {
        for (int d = 0; d < this.numDimensions; ++d) {
            mirroredPosition[d] = position[d];
            if (mirroredPosition[d] >= this.dimension[d]) {
                mirroredPosition[d] = this.dimension[d] - (mirroredPosition[d] - this.dimension[d] + 2);
            }
            if (mirroredPosition[d] >= 0) continue;
            int tmp = 0;
            int dir = 1;
            while (mirroredPosition[d] < 0) {
                if ((tmp += dir) == this.dimension[d] - 1 || tmp == 0) {
                    dir *= -1;
                }
                int n = d;
                mirroredPosition[n] = mirroredPosition[n] + 1;
            }
            mirroredPosition[d] = tmp;
        }
    }

    @Override
    public void close() {
        this.mirrorCursor.close();
    }
}

