/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.gauss.GaussianConvolutionReal;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.RealType;
import script.imglib.math.Compute;
import script.imglib.math.fn.IFunction;

public class Gauss<T extends RealType<T>>
extends Image<T> {
    public Gauss(Image<T> img, double sigma) throws Exception {
        this(img, new OutOfBoundsStrategyMirrorFactory(), sigma);
    }

    public Gauss(Image<T> img, double[] sigma) throws Exception {
        this(img, new OutOfBoundsStrategyMirrorFactory(), sigma);
    }

    public Gauss(IFunction fn, double sigma) throws Exception {
        this(Compute.inDoubles(fn), new OutOfBoundsStrategyMirrorFactory(), sigma);
    }

    public Gauss(IFunction fn, double[] sigma) throws Exception {
        this(Compute.inDoubles(fn), new OutOfBoundsStrategyMirrorFactory(), sigma);
    }

    public Gauss(Image<T> img, OutOfBoundsStrategyFactory<T> oobs, double sigma) throws Exception {
        this(img, oobs, Gauss.asArray(sigma, img.getNumDimensions()));
    }

    public Gauss(Image<T> img, OutOfBoundsStrategyFactory<T> oobs, double[] sigma) throws Exception {
        super(Gauss.process(img, oobs, sigma).getContainer(), img.createType());
    }

    public Gauss(IFunction fn, OutOfBoundsStrategyFactory<T> oobs, double sigma) throws Exception {
        this(Compute.inDoubles(fn), oobs, sigma);
    }

    public Gauss(IFunction fn, OutOfBoundsStrategyFactory<T> oobs, double[] sigma) throws Exception {
        this(Compute.inDoubles(fn), oobs, sigma);
    }

    private static final double[] asArray(double sigma, int nDimensions) {
        double[] s = new double[nDimensions];
        for (int i = 0; i < s.length; ++i) {
            s[i] = sigma;
        }
        return s;
    }

    private static final <R extends RealType<R>> Image<R> process(Image<R> img, OutOfBoundsStrategyFactory<R> oobs, double[] sigma) throws Exception {
        GaussianConvolutionReal<R> gcr = new GaussianConvolutionReal<R>(img, oobs, sigma);
        if (!gcr.checkInput() || !gcr.process()) {
            throw new Exception("Gauss: " + gcr.getErrorMessage());
        }
        return gcr.getResult();
    }
}

