/*
 * Decompiled with CFR 0.152.
 */
package script.imglib.algorithm;

import mpicbg.imglib.algorithm.fft.FourierTransform;
import mpicbg.imglib.algorithm.fft.InverseFourierTransform;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.complex.ComplexDoubleType;
import script.imglib.algorithm.FFT;

public class InverseFFT<T extends RealType<T>>
extends Image<T> {
    public InverseFFT(FFT<T> fftImage) throws Exception {
        super(InverseFFT.process(fftImage, fftImage.fft).getContainer(), fftImage.value.copy(), "Inverse FFT");
    }

    public InverseFFT(Image<ComplexDoubleType> img, FFT<T> fftImage) throws Exception {
        super(InverseFFT.process(img, fftImage.fft).getContainer(), fftImage.value.copy(), "Inverse FFT");
    }

    private static final <T extends RealType<T>> Image<T> process(Image<ComplexDoubleType> fftImage, FourierTransform<T, ComplexDoubleType> fft) throws Exception {
        InverseFourierTransform<FourierTransform<FourierTransform<T, ComplexDoubleType>, ComplexDoubleType>, ComplexDoubleType> ifft = new InverseFourierTransform<FourierTransform<FourierTransform<T, ComplexDoubleType>, ComplexDoubleType>, ComplexDoubleType>(fftImage, fft);
        if (!ifft.checkInput() || !ifft.process()) {
            throw new Exception("FFT: failed to process for image " + fftImage.getClass() + " -- " + ifft.getErrorMessage());
        }
        return ifft.getResult();
    }
}

