/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook.chart;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.imagej.axis.Axes;
import net.imagej.space.TypedSpace;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.view.Views;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.CategoryChart;
import org.knowm.xchart.CategoryChartBuilder;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.style.CategoryStyler;

public final class Charts {
    private static final Color RED = new Color(15549239);
    private static final Color GREEN = new Color(9492576);
    private static final Color BLUE = new Color(7965183);

    public static <T extends RealType<T>> List<RandomAccessibleInterval<T>> channels(RandomAccessibleInterval<T> image) {
        int cAxis = image instanceof TypedSpace ? ((TypedSpace)image).dimensionIndex(Axes.CHANNEL) : -1;
        return Charts.slices(image, cAxis);
    }

    public static <T extends RealType<T>> List<RandomAccessibleInterval<T>> slices(RandomAccessibleInterval<T> image, int axis) {
        if (axis < 0 || axis >= image.numDimensions()) {
            return Arrays.asList(image);
        }
        long dimSize = image.dimension(axis);
        if (dimSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Dimension #" + axis + " of length " + dimSize + " is too large to slice");
        }
        int sliceCount = (int)dimSize;
        ArrayList<RandomAccessibleInterval<T>> slices = new ArrayList<RandomAccessibleInterval<T>>(sliceCount);
        for (int i = 0; i < sliceCount; ++i) {
            slices.add((RandomAccessibleInterval<T>)Views.hyperSlice(image, (int)axis, (long)i));
        }
        return slices;
    }

    public static BufferedImage plot(Histogram1d<?> ... histograms) {
        return Charts.plot(Arrays.asList(histograms));
    }

    public static BufferedImage plot(List<Histogram1d<?>> histograms) {
        Function<Integer, Color> colors;
        Function<Integer, String> cNames;
        int channelCount = histograms.size();
        if (channelCount == 1) {
            cNames = index -> "Counts";
            colors = index -> Color.yellow.darker();
        } else if (channelCount == 3) {
            String[] rgbNames = new String[]{"red", "green", "blue"};
            Color[] rgbColors = new Color[]{RED, GREEN, BLUE};
            cNames = index -> rgbNames[index];
            colors = index -> rgbColors[index];
        } else {
            Function<Color, float[]> hsb = c -> Color.RGBtoHSB(RED.getRed(), RED.getGreen(), RED.getBlue(), null);
            float[] hsbRed = hsb.apply(RED);
            float[] hsbBlue = hsb.apply(BLUE);
            cNames = index -> "Channel " + index;
            colors = index -> {
                float norm = (float)index.intValue() / (float)(channelCount - 1);
                float h = hsbRed[0] * (1.0f - norm) + hsbBlue[0] * norm;
                float s = hsbRed[1] * (1.0f - norm) + hsbBlue[1] * norm;
                float b = hsbRed[2] * (1.0f - norm) + hsbBlue[2] * norm;
                return new Color(Color.HSBtoRGB(h, s, b));
            };
        }
        CategoryChart chart = ((CategoryChartBuilder)((CategoryChartBuilder)((CategoryChartBuilder)new CategoryChartBuilder().width(800)).height(400)).title("Histogram")).xAxisTitle("Bin").yAxisTitle("Count").build();
        ((CategoryStyler)chart.getStyler()).setOverlapped(true).setPlotGridVerticalLinesVisible(false);
        for (int c2 = 0; c2 < histograms.size(); ++c2) {
            Histogram1d<?> histogram = histograms.get(c2);
            Class<?> dataType = histogram.firstDataValue().getClass();
            if (!RealType.class.isAssignableFrom(dataType)) {
                throw new IllegalArgumentException("Unsupported histogram type: " + dataType.getName());
            }
            double[][] data = Charts.valuesAndCounts(histogram);
            chart.addSeries(cNames.apply(c2), data[0], data[1]).setFillColor(colors.apply(c2));
        }
        return BitmapEncoder.getBufferedImage((Chart)chart);
    }

    private static <T extends RealType<T>> double[][] valuesAndCounts(Histogram1d<T> histogram) {
        long size = histogram.size();
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Histogram is too large to plot");
        }
        int binCount = (int)size;
        Cursor cursor = histogram.cursor();
        RealType value = (RealType)((RealType)histogram.firstDataValue()).createVariable();
        double[] values = new double[binCount];
        double[] counts = new double[binCount];
        for (int b = 0; b < binCount; ++b) {
            counts[b] = ((LongType)cursor.next()).getRealDouble();
            histogram.getCenterValue((long)b, (Object)value);
            values[b] = value.getRealDouble();
        }
        return new double[][]{values, counts};
    }
}

