/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook.table;

import java.io.IOException;
import net.imagej.notebook.mime.HTMLObject;
import net.imagej.notebook.mime.MIMEConverter;
import org.apache.commons.text.StringEscapeUtils;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.table.Table;

@Plugin(type=Converter.class)
public class TableToHTMLConverter
extends MIMEConverter<Table<?, ?>, HTMLObject> {
    @Parameter
    private ConvertService convertService;

    @Override
    protected HTMLObject convert(Table<?, ?> table) {
        return () -> this.html(table);
    }

    private String html(Table<?, ?> table) throws IOException {
        boolean colLabels = false;
        for (int col = 0; col < table.getColumnCount(); ++col) {
            if (table.getColumnHeader(col) == null) continue;
            colLabels = true;
            break;
        }
        boolean rowLabels = false;
        for (int row = 0; row < table.getRowCount(); ++row) {
            if (table.getRowHeader(row) == null) continue;
            rowLabels = true;
            break;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<table class =\"scijava\">");
        if (colLabels) {
            sb.append("<thead><tr>");
            if (rowLabels) {
                sb.append("<th class=\"rowLabel\">&nbsp;</th>");
            }
            for (int col = 0; col < table.getColumnCount(); ++col) {
                sb.append("<th>" + this.html(table.getColumnHeader(col)) + "</th>");
            }
            sb.append("</tr></thead>");
        }
        sb.append("<tbody>");
        for (int row = 0; row < table.getRowCount(); ++row) {
            sb.append("<tr>");
            if (rowLabels) {
                sb.append("<td class =\"rowLabel\">" + this.html(table.getRowHeader(row)) + "</td>");
            }
            for (int col = 0; col < table.getColumnCount(); ++col) {
                sb.append("<td>" + this.html(table.get(col, row)) + "</td>");
            }
            sb.append("</tr>");
        }
        sb.append("</tbody></table>");
        return sb.toString();
    }

    private String html(Object o) throws IOException {
        if (o == null) {
            return "";
        }
        HTMLObject htmlObj = (HTMLObject)this.convertService.convert(o, HTMLObject.class);
        return htmlObj == null ? TableToHTMLConverter.escape(o.toString()) : htmlObj.data();
    }

    private static String escape(String text) {
        return StringEscapeUtils.escapeHtml4((String)text);
    }
}

