/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import sc.fiji.i5d.gui.Image5DLayout;
import sc.fiji.i5d.gui.Image5DWindow;

public class Image5DCanvas
extends ImageCanvas {
    private static final long serialVersionUID = -8563611296852137396L;

    public Image5DCanvas(ImagePlus imp) {
        super(imp);
    }

    public ImagePlus getImage() {
        return this.imp;
    }

    protected Dimension resizeCanvasI5D(int width, int height) {
        double magnification = this.getMagnification();
        if ((double)width > (double)this.imageWidth * magnification) {
            width = (int)((double)this.imageWidth * magnification);
        }
        if ((double)height > (double)this.imageHeight * magnification) {
            height = (int)((double)this.imageHeight * magnification);
        }
        this.setDrawingSize(width, height);
        Dimension dim = new Dimension(width, height);
        int newSrcRectWidth = (int)((double)width / magnification);
        if ((double)Math.round(magnification) != magnification && (int)((double)(width + 1) / magnification) >= this.imageWidth) {
            newSrcRectWidth = this.imageWidth;
        }
        int newSrcRectHeight = (int)((double)height / magnification);
        if ((double)Math.round(magnification) != magnification && (int)((double)(height + 1) / magnification) >= this.imageHeight) {
            newSrcRectHeight = this.imageHeight;
        }
        this.srcRect.x += (this.srcRect.width - newSrcRectWidth) / 2;
        if (this.srcRect.x < 0) {
            this.srcRect.x = 0;
        }
        this.srcRect.y += (this.srcRect.height - newSrcRectHeight) / 2;
        if (this.srcRect.y < 0) {
            this.srcRect.y = 0;
        }
        this.srcRect.width = newSrcRectWidth;
        this.srcRect.height = newSrcRectHeight;
        if (this.srcRect.x + this.srcRect.width > this.imageWidth) {
            this.srcRect.x = this.imageWidth - this.srcRect.width;
        }
        if (this.srcRect.y + this.srcRect.height > this.imageHeight) {
            this.srcRect.y = this.imageHeight - this.srcRect.height;
        }
        this.repaint();
        this.adaptChannelCanvasses();
        return dim;
    }

    public void setSrcRectI5d(Rectangle rect) {
        this.srcRect = rect;
    }

    public void setCursorLoc(int xMouse, int yMouse) {
        this.xMouse = xMouse;
        this.yMouse = yMouse;
    }

    public void setModifiers(int flags) {
        this.flags = flags;
    }

    public Dimension getDrawingSize() {
        return new Dimension(this.dstWidth, this.dstHeight);
    }

    public void zoomOut(int x, int y) {
        if (this.magnification <= 0.03125) {
            return;
        }
        double newMag = Image5DCanvas.getLowerZoomLevel((double)this.magnification);
        if ((double)this.imageWidth * newMag > (double)this.dstWidth) {
            int h;
            int w = (int)Math.round((double)this.dstWidth / newMag);
            if ((double)w * newMag < (double)this.dstWidth) {
                ++w;
            }
            if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
                ++h;
            }
            x = this.offScreenX(x);
            y = this.offScreenY(y);
            Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
            if (r.x < 0) {
                r.x = 0;
            }
            if (r.y < 0) {
                r.y = 0;
            }
            if (r.x + w > this.imageWidth) {
                r.x = this.imageWidth - w;
            }
            if (r.y + h > this.imageHeight) {
                r.y = this.imageHeight - h;
            }
            this.srcRect = r;
            this.setMagnification(newMag);
            this.adaptChannelCanvasses();
        } else {
            this.srcRect = new Rectangle(0, 0, this.imageWidth, this.imageHeight);
            this.setDrawingSize((int)((double)this.imageWidth * newMag), (int)((double)this.imageHeight * newMag));
            this.setMagnification(newMag);
            this.adaptChannelCanvasses();
            this.imp.getWindow().pack();
        }
        this.repaint();
    }

    public void zoomIn(int x, int y) {
        int newHeight;
        if (this.magnification >= 32.0) {
            return;
        }
        double newMag = Image5DCanvas.getHigherZoomLevel((double)this.magnification);
        int newWidth = (int)((double)this.imageWidth * newMag);
        Dimension newSize = this.canEnlarge(newWidth, newHeight = (int)((double)this.imageHeight * newMag));
        if (newSize != null) {
            this.setDrawingSize(newSize.width, newSize.height);
            if (newSize.width != newWidth || newSize.height != newHeight) {
                this.adjustSourceRectI5d(newMag, x, y);
            } else {
                this.setMagnification(newMag);
            }
            this.adaptChannelCanvasses();
            this.imp.getWindow().pack();
        } else {
            this.adjustSourceRectI5d(newMag, x, y);
            this.adaptChannelCanvasses();
        }
        this.repaint();
    }

    protected void adjustSourceRectI5d(double newMag, int x, int y) {
        int h;
        int w = (int)Math.round((double)this.dstWidth / newMag);
        if ((double)w * newMag < (double)this.dstWidth) {
            ++w;
        }
        if ((double)(h = (int)Math.round((double)this.dstHeight / newMag)) * newMag < (double)this.dstHeight) {
            ++h;
        }
        x = this.offScreenX(x);
        y = this.offScreenY(y);
        Rectangle r = new Rectangle(x - w / 2, y - h / 2, w, h);
        if (r.x < 0) {
            r.x = 0;
        }
        if (r.y < 0) {
            r.y = 0;
        }
        if (r.x + w > this.imageWidth) {
            r.x = this.imageWidth - w;
        }
        if (r.y + h > this.imageHeight) {
            r.y = this.imageHeight - h;
        }
        this.srcRect = r;
        this.setMagnification(newMag);
    }

    protected void scroll(int sx, int sy) {
        super.scroll(sx, sy);
        this.adaptChannelCanvasses();
        this.repaint();
    }

    protected Dimension canEnlarge(int newWidth, int newHeight) {
        boolean fitsVertically;
        if ((this.flags & 1) != 0 || IJ.shiftKeyDown()) {
            return null;
        }
        ImageWindow win = this.imp.getWindow();
        if (win == null) {
            return null;
        }
        Rectangle r1 = win.getBounds();
        Dimension prefSize = ((Image5DLayout)win.getLayout()).preferredLayoutSize((Container)win, newWidth, newHeight);
        r1.width = prefSize.width;
        r1.height = prefSize.height;
        Rectangle max = ((Image5DWindow)win).getMaxWindowI5d();
        boolean fitsHorizontally = r1.x + r1.width < max.x + max.width;
        boolean bl = fitsVertically = r1.y + r1.height < max.y + max.height;
        if (fitsHorizontally && fitsVertically) {
            return new Dimension(newWidth, newHeight);
        }
        if (fitsVertically && newHeight < this.dstWidth) {
            return new Dimension(this.dstWidth, newHeight);
        }
        if (fitsHorizontally && newWidth < this.dstHeight) {
            return new Dimension(newWidth, this.dstHeight);
        }
        return null;
    }

    public void mouseDragged(MouseEvent e) {
        boolean selectionBrush = Toolbar.getToolId() == 1 && Toolbar.getBrushSize() > 0;
        Roi oldMainRoi = null;
        Image5DWindow win = (Image5DWindow)this.imp.getWindow();
        if (win != null) {
            oldMainRoi = win.getImagePlus().getRoi();
        }
        super.mouseDragged(e);
        this.adaptChannelMouse();
        Roi newMainRoi = null;
        if (win != null) {
            newMainRoi = win.getImagePlus().getRoi();
        }
        if (oldMainRoi != newMainRoi || selectionBrush) {
            this.adaptChannelRois(false);
        } else {
            this.adaptChannelRois(true);
        }
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        this.adaptChannelMouse();
        Roi roi = this.imp.getRoi();
        if (roi != null && (roi.getType() == 2 || roi.getType() == 6 || roi.getType() == 8) && roi.getState() == 0) {
            this.adaptChannelRois(true);
        }
    }

    public void mousePressed(MouseEvent e) {
        boolean selectionBrush = Toolbar.getToolId() == 1 && Toolbar.getBrushSize() > 0;
        this.setThisChannelAsCurrent();
        Roi oldMainRoi = null;
        Image5DWindow win = (Image5DWindow)this.imp.getWindow();
        if (win != null) {
            oldMainRoi = win.getImagePlus().getRoi();
        }
        super.mousePressed(e);
        this.adaptChannelMouse();
        Roi newMainRoi = null;
        if (win != null) {
            newMainRoi = win.getImagePlus().getRoi();
        }
        if (oldMainRoi != newMainRoi || selectionBrush) {
            this.adaptChannelRois(false);
        } else {
            this.adaptChannelRois(true);
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.adaptChannelMouse();
        this.adaptChannelRois(true);
    }

    protected void adaptChannelCanvasses() {
        Image5DWindow win = (Image5DWindow)this.imp.getWindow();
        if (win != null) {
            win.adaptCanvasses(this);
        }
    }

    protected void adaptChannelRois(boolean thisChannel) {
        Image5DWindow win = (Image5DWindow)this.imp.getWindow();
        if (win != null) {
            if (thisChannel) {
                win.adaptRois(this);
            } else {
                win.adaptRois((Image5DCanvas)win.getCanvas());
            }
        }
    }

    protected void adaptChannelMouse() {
        Image5DWindow win = (Image5DWindow)this.imp.getWindow();
        if (win != null) {
            win.adaptMouse(this);
        }
    }

    protected void setThisChannelAsCurrent() {
        Image5DWindow win = (Image5DWindow)this.imp.getWindow();
        if (win != null) {
            win.setChannelAsCurrent(this);
        }
    }
}

