/*
 * Decompiled with CFR 0.152.
 */
import Jama.Matrix;
import ij.IJ;
import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Remove_Slope
implements PlugInFilter {
    protected ImagePlus imagePlus;

    public int setup(String string, ImagePlus imagePlus) {
        this.imagePlus = imagePlus;
        return 40;
    }

    public void run(ImageProcessor ip) {
        byte[] mask;
        Rectangle selection = ip.getRoi();
        int selectionX = selection.width;
        int selectionY = selection.height;
        ByteProcessor maskProcessor = (ByteProcessor)this.imagePlus.getMask();
        if (maskProcessor != null) {
            mask = (byte[])maskProcessor.getPixels();
        } else {
            mask = new byte[selectionX * selectionY];
            for (int jj = 0; jj < mask.length; ++jj) {
                mask[jj] = -1;
            }
        }
        int numMaskPixels = 0;
        for (int ii = 0; ii < mask.length; ++ii) {
            if (mask[ii] >= 0) continue;
            ++numMaskPixels;
        }
        if (numMaskPixels < 4) {
            IJ.write((String)("" + mask.length));
            IJ.write((String)"Selection is not big enough.  Please Try Again");
            return;
        }
        float[] pixels = (float[])ip.getPixels();
        int width = ip.getWidth();
        int height = ip.getHeight();
        double sumX = 0.0;
        double sumX2 = 0.0;
        double sumXY = 0.0;
        double sumY = 0.0;
        double sumY2 = 0.0;
        double sumXZ = 0.0;
        double sumYZ = 0.0;
        double sumZ = 0.0;
        double sumPoints = 0.0;
        for (int yy = 0; yy < selectionY; ++yy) {
            for (int xx = 0; xx < selectionX; ++xx) {
                int actualY = selection.y + yy;
                int actualX = selection.x + xx;
                float currentZ = pixels[actualY * width + actualX];
                if (mask[yy * selectionX + xx] >= 0) continue;
                sumX += (double)actualX;
                sumX2 += (double)(actualX * actualX);
                sumXY += (double)(actualX * actualY);
                sumY += (double)actualY;
                sumY2 += (double)(actualY * actualY);
                sumXZ += (double)((float)actualX * currentZ);
                sumYZ += (double)((float)actualY * currentZ);
                sumZ += (double)currentZ;
                sumPoints += 1.0;
            }
        }
        Matrix A = new Matrix(3, 3);
        A.set(0, 0, sumX2);
        A.set(0, 1, sumXY);
        A.set(0, 2, sumX);
        A.set(1, 0, sumXY);
        A.set(1, 1, sumY2);
        A.set(1, 2, sumY);
        A.set(2, 0, sumX);
        A.set(2, 1, sumY);
        A.set(2, 2, sumPoints);
        Matrix B = new Matrix(3, 1);
        B.set(0, 0, sumXZ);
        B.set(1, 0, sumYZ);
        B.set(2, 0, sumZ);
        double[] result = A.solve(B).getRowPackedCopy();
        for (int yy = 0; yy < height; ++yy) {
            for (int xx = 0; xx < width; ++xx) {
                int offset = yy * width + xx;
                float zfit = (float)((double)xx * result[0] + (double)yy * result[1] + result[2]);
                pixels[offset] = pixels[offset] - zfit;
            }
        }
        FloatProcessor fip = (FloatProcessor)ip;
        fip.resetMinAndMax();
        fip.findMinAndMax();
        fip.setMinAndMax(fip.getMin(), fip.getMax());
    }
}

