/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jhotdraw.draw.AbstractAttributedFigure;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.handle.DragHandle;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.geom.Geom;
import org.scijava.ui.awt.AWTColors;
import org.scijava.util.ColorRGB;

public class PointFigure
extends AbstractAttributedFigure {
    protected Rectangle2D.Double bounds;
    private final Rectangle2D.Double rect;
    private final List<double[]> points;
    private Color fillColor = Color.yellow;
    private Color lineColor = Color.white;

    public PointFigure() {
        this(new double[2]);
    }

    public PointFigure(double[] pt) {
        this(Arrays.asList(new double[][]{pt}));
    }

    public PointFigure(List<double[]> pts) {
        this.bounds = new Rectangle2D.Double();
        this.rect = new Rectangle2D.Double();
        this.points = new ArrayList<double[]>();
        this.setPoints(pts);
    }

    public void setPoints(List<double[]> pts) {
        this.points.clear();
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (double[] pt : pts) {
            this.points.add((double[])pt.clone());
            if (pt[0] < minX) {
                minX = pt[0];
            }
            if (pt[0] > maxX) {
                maxX = pt[0];
            }
            if (pt[1] < minY) {
                minY = pt[1];
            }
            if (!(pt[1] > maxY)) continue;
            maxY = pt[1];
        }
        this.bounds.x = minX;
        this.bounds.y = minY;
        this.bounds.width = maxX - minX + 0.1;
        this.bounds.height = maxY - minY + 0.1;
    }

    public void setFillColor(ColorRGB c) {
        this.fillColor = AWTColors.getColor((ColorRGB)c);
    }

    public void setLineColor(ColorRGB c) {
        this.lineColor = AWTColors.getColor((ColorRGB)c);
    }

    public double getX() {
        return this.bounds.x;
    }

    public double getY() {
        return this.bounds.y;
    }

    public List<double[]> getPoints() {
        return this.points;
    }

    public void move(double dx, double dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
        for (double[] pt : this.points) {
            pt[0] = pt[0] + dx;
            pt[1] = pt[1] + dy;
        }
    }

    protected void drawFill(Graphics2D g) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.bounds.clone();
        double grow = AttributeKeys.getPerpendicularFillGrowth((Figure)this);
        Geom.grow((Rectangle2D.Double)r, (double)grow, (double)grow);
        g.fill(r);
    }

    protected void drawStroke(Graphics2D g) {
        Rectangle2D.Double r = (Rectangle2D.Double)this.bounds.clone();
        double grow = AttributeKeys.getPerpendicularDrawGrowth((Figure)this);
        Geom.grow((Rectangle2D.Double)r, (double)grow, (double)grow);
        g.draw(r);
    }

    public Rectangle2D.Double getBounds() {
        Rectangle2D.Double b = (Rectangle2D.Double)this.bounds.clone();
        return b;
    }

    public Rectangle2D.Double getDrawingArea() {
        Rectangle2D.Double r = (Rectangle2D.Double)this.bounds.clone();
        double grow = AttributeKeys.getPerpendicularHitGrowth((Figure)this) + 1.0;
        Geom.grow((Rectangle2D.Double)r, (double)grow, (double)grow);
        return r;
    }

    public boolean contains(Point2D.Double p) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        for (double[] pt : this.points) {
            r.x = pt[0];
            r.y = pt[1];
            r.width = 1.0;
            r.height = 1.0;
            double grow = AttributeKeys.getPerpendicularHitGrowth((Figure)this) + 1.0;
            Geom.grow((Rectangle2D.Double)r, (double)grow, (double)grow);
            if (!r.contains(p)) continue;
            return true;
        }
        return false;
    }

    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        double dx = anchor.x - this.bounds.x;
        double dy = anchor.y - this.bounds.y;
        this.move(dx, dy);
    }

    public void transform(AffineTransform tx) {
        Point2D.Double anchor = new Point2D.Double(this.bounds.x, this.bounds.y);
        tx.transform(anchor, anchor);
        this.setBounds(anchor, anchor);
    }

    public void restoreTransformTo(Object geometry) {
        this.setBounds((Point2D.Double)geometry, (Point2D.Double)geometry);
    }

    public Object getTransformRestoreData() {
        return new Point2D.Double(this.bounds.x, this.bounds.y);
    }

    public PointFigure clone() {
        PointFigure that = (PointFigure)super.clone();
        that.bounds = (Rectangle2D.Double)this.bounds.clone();
        return that;
    }

    public List<Handle> createHandles(int detailLevel) {
        DragHandle handle = new DragHandle((Figure)this);
        return Arrays.asList(handle);
    }

    public void draw(Graphics2D g) {
        Color origC = g.getColor();
        double sx = g.getTransform().getScaleX();
        double sy = g.getTransform().getScaleY();
        for (double[] pt : this.points) {
            double ctrX = pt[0];
            double ctrY = pt[1];
            g.setColor(Color.black);
            this.rect.x = ctrX - 2.0 / sx;
            this.rect.y = ctrY - 2.0 / sy;
            this.rect.width = 5.0 / sx;
            this.rect.height = 5.0 / sy;
            g.fill(this.rect);
            g.setColor(this.fillColor);
            this.rect.x = ctrX - 1.0 / sx;
            this.rect.y = ctrY - 1.0 / sy;
            this.rect.width = 3.0 / sx;
            this.rect.height = 3.0 / sy;
            g.fill(this.rect);
            g.setColor(this.lineColor);
            this.rect.x = ctrX + 3.0 / sx;
            this.rect.y = ctrY;
            this.rect.width = 4.0 / sx;
            this.rect.height = 1.0 / sy;
            g.fill(this.rect);
            this.rect.x = ctrX - 6.0 / sx;
            this.rect.y = ctrY;
            this.rect.width = 4.0 / sx;
            this.rect.height = 1.0 / sy;
            g.fill(this.rect);
            this.rect.x = ctrX;
            this.rect.y = ctrY - 6.0 / sy;
            this.rect.width = 1.0 / sx;
            this.rect.height = 4.0 / sy;
            g.fill(this.rect);
            this.rect.x = ctrX;
            this.rect.y = ctrY + 3.0 / sy;
            this.rect.width = 1.0 / sx;
            this.rect.height = 4.0 / sy;
            g.fill(this.rect);
            g.setColor(origC);
        }
    }
}

