/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.ui;

import ij.Prefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.janelia.saalfeldlab.n5.metadata.imagej.MetadataTemplateMapper;

public class N5MetadataSpecDialog {
    private String metadataSpecText;
    private String mapperString;
    private MetadataTemplateMapper mapper;
    private WindowListener listener;

    public N5MetadataSpecDialog() {
    }

    public N5MetadataSpecDialog(WindowListener listener) {
        this.listener = listener;
    }

    public String getMapperString() {
        return this.mapperString;
    }

    public MetadataTemplateMapper getMapper() {
        return this.mapper;
    }

    public JFrame show(String init) {
        final JFrame frame = new JFrame("Metadata translation");
        double guiScale = Prefs.getGuiScale();
        int frameSizeX = (int)(guiScale * 600.0);
        int frameSizeY = (int)(guiScale * 400.0);
        frame.setPreferredSize(new Dimension(frameSizeX, frameSizeY));
        frame.setMinimumSize(frame.getPreferredSize());
        JPanel panel = new JPanel(new BorderLayout());
        if (this.listener != null) {
            frame.addWindowListener(this.listener);
        }
        final JTextArea textArea = new JTextArea();
        textArea.setText(init);
        textArea.setFont(textArea.getFont().deriveFont((float)guiScale * 18.0f));
        JScrollPane textView = new JScrollPane(textArea);
        panel.add((Component)textView, "Center");
        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                N5MetadataSpecDialog.this.metadataSpecText = textArea.getText();
                N5MetadataSpecDialog.this.mapper = new MetadataTemplateMapper(N5MetadataSpecDialog.this.metadataSpecText);
                frame.setVisible(false);
                frame.dispatchEvent(new WindowEvent(frame, 201));
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                frame.setVisible(false);
                frame.dispatchEvent(new WindowEvent(frame, 201));
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add((Component)okButton, "West");
        buttonPanel.add((Component)cancelButton, "East");
        panel.add((Component)buttonPanel, "South");
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
        return frame;
    }
}

