/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apposed.appose.builder.Tool;
import org.apposed.appose.util.Downloads;
import org.apposed.appose.util.Environments;
import org.apposed.appose.util.Platforms;

class Mamba
extends Tool {
    private static final Path MICROMAMBA_RELATIVE_PATH = Platforms.isWindows() ? Paths.get("Library", "bin", "micromamba.exe") : Paths.get("bin", "micromamba");
    public static final String BASE_PATH = Paths.get(Environments.apposeEnvsDir(), ".mamba").toString();
    public static final String MICROMAMBA_PLATFORM = Mamba.microMambaPlatform();
    public static final String MICROMAMBA_URL = MICROMAMBA_PLATFORM == null ? null : "https://micro.mamba.pm/api/micromamba/" + MICROMAMBA_PLATFORM + "/latest";

    private static String microMambaPlatform() {
        switch (Platforms.PLATFORM) {
            case "LINUX|X64": {
                return "linux-64";
            }
            case "LINUX|ARM64": {
                return "linux-aarch64";
            }
            case "LINUX|PPC64LE": {
                return "linux-ppc64le";
            }
            case "MACOS|X64": {
                return "osx-64";
            }
            case "MACOS|ARM64": {
                return "osx-arm64";
            }
            case "WINDOWS|X64": {
                return "win-64";
            }
        }
        return null;
    }

    public Mamba() {
        this(null);
    }

    public Mamba(String rootdir) {
        super("micromamba", MICROMAMBA_URL, Paths.get(rootdir == null ? BASE_PATH : rootdir, new String[0]).resolve(MICROMAMBA_RELATIVE_PATH).toAbsolutePath().toString(), rootdir == null ? BASE_PATH : rootdir);
    }

    @Override
    protected void decompress(File archive) throws IOException, InterruptedException {
        boolean executableSet;
        File tempTarFile = File.createTempFile("micromamba", ".tar");
        tempTarFile.deleteOnExit();
        Downloads.unBZip2(archive, tempTarFile);
        File mambaBaseDir = new File(this.rootdir);
        if (!mambaBaseDir.isDirectory() && !mambaBaseDir.mkdirs()) {
            throw new IOException("Failed to create Micromamba default directory " + mambaBaseDir.getParentFile().getAbsolutePath() + ". Please try installing it in another directory.");
        }
        Downloads.unTar(tempTarFile, mambaBaseDir);
        File mmFile = new File(this.command);
        if (!mmFile.exists()) {
            throw new IOException("Expected micromamba binary is missing: " + this.command);
        }
        if (!mmFile.canExecute() && !(executableSet = new File(this.command).setExecutable(true))) {
            throw new IOException("Cannot set file as executable due to missing permissions, please do it manually: " + this.command);
        }
    }

    public void create(File envDir) throws IOException, InterruptedException {
        this.checkInstalled();
        this.exec("create", "--prefix", envDir.getAbsolutePath(), "-y", "--no-rc");
    }

    public void update(File envDir, File envYaml) throws IOException, InterruptedException {
        this.checkInstalled();
        this.exec("env", "update", "-y", "--prefix", envDir.getAbsolutePath(), "-f", envYaml.getAbsolutePath());
    }

    @Override
    public String version() throws IOException, InterruptedException {
        List<String> cmd = Platforms.baseCommand();
        cmd.add(this.command);
        cmd.add("--version");
        Process process = this.processBuilder(this.rootdir, false).command(cmd).start();
        if (process.waitFor() != 0) {
            throw new RuntimeException("Error getting Micromamba version");
        }
        return new BufferedReader(new InputStreamReader(process.getInputStream())).readLine();
    }
}

