/*
 * Decompiled with CFR 0.152.
 */
package org.apposed.appose.scheme;

import org.apposed.appose.Scheme;

public class PyProjectTomlScheme
implements Scheme {
    @Override
    public String name() {
        return "pyproject.toml";
    }

    @Override
    public double priority() {
        return 100.0;
    }

    @Override
    public String envName(String content) {
        if (content == null) {
            return null;
        }
        String[] lines = content.split("\n");
        boolean inProjectSection = false;
        for (String line : lines) {
            String trimmed = line.trim();
            if (trimmed.equals("[project]")) {
                inProjectSection = true;
                continue;
            }
            if (trimmed.startsWith("[") && !trimmed.startsWith("[project")) {
                inProjectSection = false;
            }
            if (!inProjectSection || !trimmed.startsWith("name") || !trimmed.contains("=")) continue;
            int equalsIndex = trimmed.indexOf(61);
            String value = trimmed.substring(equalsIndex + 1).trim();
            if ((value = value.replaceAll("^[\"']|[\"']$", "")).isEmpty()) continue;
            return value;
        }
        return null;
    }

    @Override
    public boolean supportsContent(String content) {
        if (content == null) {
            return false;
        }
        String trimmed = content.trim();
        if (!trimmed.matches("(?s).*\\[.*\\].*")) {
            return false;
        }
        if (!trimmed.contains("[project]")) {
            return false;
        }
        return trimmed.contains("[tool.pixi.") || trimmed.contains("[project.dependencies]") || trimmed.matches("(?s).*\\[project\\].*dependencies\\s*=.*");
    }

    @Override
    public boolean supportsFilename(String filename) {
        return filename.endsWith("pyproject.toml");
    }
}

