/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.translators;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.formats.ICSFormat;
import io.scif.ome.OMEMetadata;
import io.scif.ome.services.OMEMetadataService;
import io.scif.ome.translators.FromOMETranslator;
import io.scif.ome.translators.ToOMETranslator;
import io.scif.util.FormatTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import net.imagej.axis.Axes;
import ome.units.UNITS;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;
import org.scijava.plugin.Plugin;

public class ICSTranslator {

    @Plugin(type=ToOMETranslator.class, priority=100.0)
    public static class ICSOMETranslator
    extends ToOMETranslator<ICSFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return ICSFormat.Metadata.class;
        }

        public Class<? extends Metadata> dest() {
            return OMEMetadata.class;
        }

        protected void translateFormatMetadata(ICSFormat.Metadata source, OMEMetadata dest) {
            OMEXMLMetadata store = dest.getRoot();
            boolean imageIndex = false;
            Double[] pixelSizes = null;
            Double[] timestamps = null;
            Double[] stagePos = null;
            Double laserPower = null;
            Double laserRepetitionRate = null;
            Double lensNA = null;
            Double workingDistance = null;
            Double magnification = null;
            Double exposureTime = null;
            Integer[] emWaves = null;
            Integer[] exWaves = null;
            int[] sizes = null;
            String[] units = null;
            String[] axes = null;
            String imageName = source.getSourceLocation().getName();
            String date = null;
            String description = null;
            String microscopeModel = null;
            String microscopeManufacturer = null;
            String experimentType = null;
            String laserManufacturer = null;
            String laserModel = null;
            String filterSetModel = null;
            String dichroicModel = null;
            String excitationModel = null;
            String emissionModel = null;
            String objectiveModel = null;
            String immersion = null;
            String detectorManufacturer = null;
            String detectorModel = null;
            String lastName = null;
            Map<Integer, Double> gains = new HashMap();
            Map channelNames = new HashMap();
            Map pinholes = new HashMap();
            Map wavelengths = new HashMap();
            FilterMetadata filter = new FilterMetadata((MetadataStore)store, source.isFiltered());
            filter.createRoot();
            OMEMetadataService omeMetaService = (OMEMetadataService)this.getContext().service(OMEMetadataService.class);
            omeMetaService.populatePixels((MetadataStore)filter, (Metadata)source, true);
            store.setImageName(imageName, 0);
            date = source.getDate();
            if (date != null) {
                store.setImageAcquisitionDate(new Timestamp(date), 0);
            }
            description = source.getDescription();
            store.setImageDescription(description, 0);
            String instrumentID = omeMetaService.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            microscopeModel = source.getMicroscopeModel();
            store.setMicroscopeModel(microscopeModel, 0);
            microscopeManufacturer = source.getMicroscopeManufacturer();
            store.setMicroscopeManufacturer(microscopeManufacturer, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            store.setExperimentID(omeMetaService.createLSID("Experiment", 0), 0);
            experimentType = source.getExperimentType();
            try {
                store.setExperimentType(omeMetaService.getExperimentType(experimentType), 0);
            }
            catch (FormatException e) {
                this.log().debug((Object)"Could not set experiment type", (Throwable)e);
            }
            pixelSizes = source.getParameterScales();
            units = source.getParameterUnits();
            axes = source.getAxes();
            sizes = source.getAxesSizes();
            if (pixelSizes != null) {
                if (units != null && units.length == pixelSizes.length - 1) {
                    ArrayList<String> realUnits = new ArrayList<String>();
                    int unitIndex = 0;
                    for (int i = 0; i < axes.length; ++i) {
                        if (axes[i].equalsIgnoreCase("ch")) {
                            realUnits.add("nm");
                            continue;
                        }
                        realUnits.add(units[unitIndex++]);
                    }
                    units = realUnits.toArray(new String[realUnits.size()]);
                }
                for (int i = 0; i < pixelSizes.length; ++i) {
                    String unit;
                    Double pixelSize = pixelSizes[i];
                    if (pixelSize == null) continue;
                    String axis = axes != null && axes.length > i ? axes[i] : "";
                    String string = unit = units != null && units.length > i ? units[i] : "";
                    if (axis.equals("x")) {
                        if (pixelSize > 0.0 && this.checkUnit(unit, "um", "microns", "micrometers")) {
                            store.setPixelsPhysicalSizeX(new Length((Number)pixelSize, UNITS.MICROMETER), 0);
                            continue;
                        }
                        this.log().warn((Object)("Expected positive value for PhysicalSizeX; got " + pixelSize));
                        continue;
                    }
                    if (axis.equals("y")) {
                        if (pixelSize > 0.0 && this.checkUnit(unit, "um", "microns", "micrometers")) {
                            store.setPixelsPhysicalSizeY(new Length((Number)pixelSize, UNITS.MICROMETER), 0);
                            continue;
                        }
                        this.log().warn((Object)("Expected positive value for PhysicalSizeY; got " + pixelSize));
                        continue;
                    }
                    if (axis.equals("z")) {
                        if (pixelSize > 0.0 && this.checkUnit(unit, "um", "microns", "micrometers")) {
                            store.setPixelsPhysicalSizeZ(new Length((Number)pixelSize, UNITS.MICROMETER), 0);
                            continue;
                        }
                        this.log().warn((Object)("Expected positive value for PhysicalSizeZ; got " + pixelSize));
                        continue;
                    }
                    if (!axis.equals("t")) continue;
                    if (this.checkUnit(unit, "ms")) {
                        store.setPixelsTimeIncrement(new Time((Number)(1000.0 * pixelSize), UNITS.SECOND), 0);
                        continue;
                    }
                    if (!this.checkUnit(unit, "seconds") && !this.checkUnit(unit, "s")) continue;
                    store.setPixelsTimeIncrement(new Time((Number)pixelSize, UNITS.SECOND), 0);
                }
            } else if (sizes != null) {
                if (sizes.length > 0 && sizes[0] > 0) {
                    store.setPixelsPhysicalSizeX(new Length((Number)sizes[0], UNITS.MICROMETER), 0);
                } else {
                    this.log().warn((Object)("Expected positive value for PhysicalSizeX; got " + sizes[0]));
                }
                if (sizes.length > 1) {
                    sizes[1] = (int)((long)sizes[1] / source.get(0).getAxisLength(Axes.Y));
                    if (sizes[1] > 0) {
                        store.setPixelsPhysicalSizeY(new Length((Number)sizes[1], UNITS.MICROMETER), 0);
                    } else {
                        this.log().warn((Object)("Expected positive value for PhysicalSizeY; got " + sizes[1]));
                    }
                }
            }
            if ((timestamps = source.getTimestamps()) != null) {
                for (int t = 0; t < timestamps.length && (long)t < source.get(0).getAxisLength(Axes.TIME); ++t) {
                    double deltaT;
                    if (timestamps[t] == null || Double.isNaN(deltaT = timestamps[t].doubleValue())) continue;
                    long planeCount = source.get(0).getPlaneCount();
                    long tLen = source.get(0).getAxisLength(Axes.TIME);
                    long zLen = source.get(0).getAxisLength(Axes.Z);
                    long effSizeC = planeCount / (tLen * zLen);
                    String dimOrder = omeMetaService.findDimensionOrder((Metadata)source, 0);
                    int z = 0;
                    while ((long)z < zLen) {
                        int c = 0;
                        while ((long)c < effSizeC) {
                            long[] lengths = omeMetaService.zctToArray(dimOrder, (int)zLen, (int)effSizeC, (int)tLen);
                            int index = (int)FormatTools.positionToRaster((long[])lengths, (long[])omeMetaService.zctToArray(dimOrder, z, c, t));
                            store.setPlaneDeltaT(new Time((Number)deltaT, UNITS.SECOND), 0, index);
                            ++c;
                        }
                        ++z;
                    }
                }
            }
            channelNames = source.getChannelNames();
            source.addStepChannel(channelNames);
            source.addCubeChannel(channelNames);
            pinholes = source.getPinholes();
            emWaves = source.getEMWaves();
            if (emWaves == null) {
                emWaves = source.getEMSingleton();
            }
            if ((exWaves = source.getEXWaves()) == null) {
                exWaves = source.getEXSingleton();
            }
            long planeCount = source.get(0).getPlaneCount();
            long tLen = source.get(0).getAxisLength(Axes.TIME);
            long zLen = source.get(0).getAxisLength(Axes.Z);
            long effSizeC = planeCount / (tLen * zLen);
            int i = 0;
            while ((long)i < effSizeC) {
                if (channelNames.containsKey(i)) {
                    store.setChannelName((String)channelNames.get(i), 0, i);
                }
                if (pinholes.containsKey(i)) {
                    store.setChannelPinholeSize(new Length((Number)pinholes.get(i), UNITS.MICROMETER), 0, i);
                }
                if (emWaves != null && i < emWaves.length) {
                    if (emWaves[i] > 0) {
                        store.setChannelEmissionWavelength(new Length((Number)emWaves[i], UNITS.MICROMETER), 0, i);
                    } else {
                        this.log().warn((Object)("Expected positive value for EmissionWavelength; got " + emWaves[i]));
                    }
                }
                if (exWaves != null && i < exWaves.length) {
                    if (exWaves[i] > 0) {
                        store.setChannelExcitationWavelength(new Length((Number)exWaves[i], UNITS.MICROMETER), 0, i);
                    } else {
                        this.log().warn((Object)("Expected positive value for ExcitationWavelength; got " + exWaves[i]));
                    }
                }
                ++i;
            }
            wavelengths = source.getWavelengths();
            source.addLaserWavelength(wavelengths);
            laserManufacturer = source.getLaserManufacturer();
            laserModel = source.getLaserModel();
            laserPower = source.getLaserPower();
            laserRepetitionRate = source.getLaserRepetitionRate();
            Object[] lasers = wavelengths.keySet().toArray(new Integer[0]);
            Arrays.sort(lasers);
            for (int i2 = 0; i2 < lasers.length; ++i2) {
                store.setLaserID(omeMetaService.createLSID("LightSource", 0, i2), 0, i2);
                if ((Integer)wavelengths.get(lasers[i2]) > 0) {
                    store.setLaserWavelength(new Length((Number)wavelengths.get(lasers[i2]), UNITS.MICROMETER), 0, i2);
                } else {
                    this.log().warn((Object)("Expected positive value for wavelength; got " + wavelengths.get(lasers[i2])));
                }
                try {
                    store.setLaserType(omeMetaService.getLaserType("Other"), 0, i2);
                }
                catch (FormatException e) {
                    this.log().warn((Object)"Failed to set laser type", (Throwable)e);
                }
                try {
                    store.setLaserLaserMedium(omeMetaService.getLaserMedium("Other"), 0, i2);
                }
                catch (FormatException e) {
                    this.log().warn((Object)"Failed to set laser medium", (Throwable)e);
                }
                store.setLaserManufacturer(laserManufacturer, 0, i2);
                store.setLaserModel(laserModel, 0, i2);
                store.setLaserPower(new Power((Number)laserPower, UNITS.MICROWATT), 0, i2);
                store.setLaserRepetitionRate(new Frequency((Number)laserRepetitionRate, UNITS.MEGAHERTZ), 0, i2);
            }
            if (lasers.length == 0 && laserManufacturer != null) {
                store.setLaserID(omeMetaService.createLSID("LightSource", 0, 0), 0, 0);
                try {
                    store.setLaserType(omeMetaService.getLaserType("Other"), 0, 0);
                }
                catch (FormatException e) {
                    this.log().warn((Object)"Failed to set laser type", (Throwable)e);
                }
                try {
                    store.setLaserLaserMedium(omeMetaService.getLaserMedium("Other"), 0, 0);
                }
                catch (FormatException e) {
                    this.log().warn((Object)"Failed to set laser medium", (Throwable)e);
                }
                store.setLaserManufacturer(laserManufacturer, 0, 0);
                store.setLaserModel(laserModel, 0, 0);
                store.setLaserPower(new Power((Number)laserPower, UNITS.WATT), 0, 0);
                store.setLaserRepetitionRate(new Frequency((Number)laserRepetitionRate, UNITS.MEGAHERTZ), 0, 0);
            }
            filterSetModel = source.getFilterSetModel();
            dichroicModel = source.getDichroicModel();
            excitationModel = source.getExcitationModel();
            emissionModel = source.getEmissionModel();
            if (filterSetModel != null) {
                store.setFilterSetID(omeMetaService.createLSID("FilterSet", 0, 0), 0, 0);
                store.setFilterSetModel(filterSetModel, 0, 0);
                String dichroicID = omeMetaService.createLSID("Dichroic", 0, 0);
                String emFilterID = omeMetaService.createLSID("Filter", 0, 0);
                String exFilterID = omeMetaService.createLSID("Filter", 0, 1);
                store.setDichroicID(dichroicID, 0, 0);
                store.setDichroicModel(dichroicModel, 0, 0);
                store.setFilterSetDichroicRef(dichroicID, 0, 0);
                store.setFilterID(emFilterID, 0, 0);
                store.setFilterModel(emissionModel, 0, 0);
                store.setFilterSetEmissionFilterRef(emFilterID, 0, 0, 0);
                store.setFilterID(exFilterID, 0, 1);
                store.setFilterModel(excitationModel, 0, 1);
                store.setFilterSetExcitationFilterRef(exFilterID, 0, 0, 0);
            }
            objectiveModel = source.getObjectiveModel();
            immersion = source.getImmersion();
            lensNA = source.getLensNA();
            workingDistance = source.getWorkingDistance();
            magnification = source.getMagnification();
            if (objectiveModel != null) {
                store.setObjectiveModel(objectiveModel, 0, 0);
            }
            if (immersion == null) {
                immersion = "Other";
            }
            try {
                store.setObjectiveImmersion(omeMetaService.getImmersion(immersion), 0, 0);
            }
            catch (FormatException e) {
                this.log().warn((Object)"failed to set objective immersion", (Throwable)e);
            }
            if (lensNA != null) {
                store.setObjectiveLensNA(lensNA, 0, 0);
            }
            if (workingDistance != null) {
                store.setObjectiveWorkingDistance(new Length((Number)workingDistance, UNITS.MICROMETER), 0, 0);
            }
            if (magnification != null) {
                store.setObjectiveCalibratedMagnification(magnification, 0, 0);
            }
            try {
                store.setObjectiveCorrection(omeMetaService.getCorrection("Other"), 0, 0);
            }
            catch (FormatException e) {
                this.log().warn((Object)"Failed to store objective correction", (Throwable)e);
            }
            String objectiveID = omeMetaService.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveSettingsID(objectiveID, 0);
            detectorManufacturer = source.getDetectorManufacturer();
            detectorModel = source.getDetectorModel();
            String detectorID = omeMetaService.createLSID("Detector", 0, 0);
            store.setDetectorID(detectorID, 0, 0);
            store.setDetectorManufacturer(detectorManufacturer, 0, 0);
            store.setDetectorModel(detectorModel, 0, 0);
            try {
                store.setDetectorType(omeMetaService.getDetectorType("Other"), 0, 0);
            }
            catch (FormatException e) {
                this.log().warn((Object)"Failed to store detector type", (Throwable)e);
            }
            gains = source.getGains();
            gains.forEach((key, value) -> {
                int index = key;
                if ((long)index < effSizeC) {
                    store.setDetectorSettingsGain(value, 0, index);
                    store.setDetectorSettingsID(detectorID, 0, index);
                }
            });
            lastName = source.getAuthorLastName();
            if (lastName != null) {
                String experimenterID = omeMetaService.createLSID("Experimenter", 0);
                store.setExperimenterID(experimenterID, 0);
                store.setExperimenterLastName(lastName, 0);
            }
            if ((stagePos = source.getStagePositions()) == null) {
                stagePos = new Double[]{source.getStageX(), source.getStageY(), source.getStageZ()};
            }
            if ((exposureTime = source.getExposureTime()) != null) {
                for (int i3 = 0; i3 < source.getImageCount(); ++i3) {
                    store.setPlaneExposureTime(new Time((Number)exposureTime, UNITS.SECOND), 0, i3);
                }
            }
            dest.setRoot(store);
        }

        private boolean checkUnit(String actual, String ... expected) {
            if (actual == null || actual.equals("")) {
                return true;
            }
            for (String exp : expected) {
                if (!actual.equals(exp)) continue;
                return true;
            }
            this.log().debug((Object)("Unexpected unit '" + actual + "'; expected '" + expected + "'"));
            return false;
        }
    }

    @Plugin(type=FromOMETranslator.class, priority=100.0)
    public static class OMEICSTranslator
    extends FromOMETranslator<ICSFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return OMEMetadata.class;
        }

        public Class<? extends Metadata> dest() {
            return ICSFormat.Metadata.class;
        }

        protected void translateFormatMetadata(OMEMetadata source, ICSFormat.Metadata dest) {
            OMEXMLMetadata retrieve = source.getRoot();
            Timestamp ts = retrieve.getImageAcquisitionDate(0);
            if (ts != null) {
                dest.putDate((String)ts.getValue());
            }
            dest.putDescription(retrieve.getImageDescription(0));
            if (retrieve.getInstrumentCount() > 0) {
                dest.putMicroscopeModel(retrieve.getMicroscopeModel(0));
                dest.putMicroscopeManufacturer(retrieve.getMicroscopeManufacturer(0));
                HashMap<Integer, Integer> laserWaves = new HashMap<Integer, Integer>();
                for (int i = 0; i < retrieve.getLightSourceCount(0); ++i) {
                    laserWaves.put(i, retrieve.getLaserWavelength(0, i).value().intValue());
                }
                dest.putWavelengths(laserWaves);
                dest.putLaserManufacturer(retrieve.getLaserManufacturer(0, 0));
                dest.putLaserModel(retrieve.getLaserModel(0, 0));
                dest.putLaserPower(Double.valueOf(retrieve.getLaserPower(0, 0).value().doubleValue()));
                dest.putLaserRepetitionRate(Double.valueOf(retrieve.getLaserRepetitionRate(0, 0).value().doubleValue()));
                dest.putFilterSetModel(retrieve.getFilterSetModel(0, 0));
                dest.putDichroicModel(retrieve.getDichroicModel(0, 0));
                dest.putExcitationModel(retrieve.getFilterModel(0, 0));
                dest.putEmissionModel(retrieve.getFilterModel(0, 1));
                dest.putObjectiveModel(retrieve.getObjectiveModel(0, 0));
                dest.putImmersion(retrieve.getObjectiveImmersion(0, 0).getValue());
                dest.putLensNA(retrieve.getObjectiveLensNA(0, 0));
                dest.putWorkingDistance(Double.valueOf(retrieve.getObjectiveWorkingDistance(0, 0).value().doubleValue()));
                dest.putMagnification(retrieve.getObjectiveCalibratedMagnification(0, 0));
                dest.putDetectorManufacturer(retrieve.getDetectorManufacturer(0, 0));
                dest.putDetectorModel(retrieve.getDetectorModel(0, 0));
            }
            if (retrieve.getExperimentCount() > 0) {
                dest.putExperimentType(retrieve.getExperimentType(0).getValue());
                dest.putAuthorLastName(retrieve.getExperimenterLastName(0));
            }
            Double[] pixelSizes = new Double[5];
            String[] units = new String[5];
            String order = retrieve.getPixelsDimensionOrder(0).getValue();
            Length sizex = retrieve.getPixelsPhysicalSizeX(0);
            Length sizey = retrieve.getPixelsPhysicalSizeY(0);
            Length sizez = retrieve.getPixelsPhysicalSizeZ(0);
            Time sizet = retrieve.getPixelsTimeIncrement(0);
            block8: for (int i = 0; i < order.length(); ++i) {
                switch (order.toUpperCase().charAt(i)) {
                    case 'X': {
                        pixelSizes[i] = sizex == null ? 1.0 : sizex.value().doubleValue();
                        units[i] = "um";
                        continue block8;
                    }
                    case 'Y': {
                        pixelSizes[i] = sizey == null ? 1.0 : sizey.value().doubleValue();
                        units[i] = "um";
                        continue block8;
                    }
                    case 'Z': {
                        pixelSizes[i] = sizez == null ? 1.0 : sizez.value().doubleValue();
                        units[i] = "um";
                        continue block8;
                    }
                    case 'T': {
                        pixelSizes[i] = sizet == null ? 1.0 : sizet.value().doubleValue();
                        units[i] = "s";
                        continue block8;
                    }
                    case 'C': {
                        pixelSizes[i] = 1.0;
                        units[i] = "um";
                        continue block8;
                    }
                    default: {
                        pixelSizes[i] = 1.0;
                        units[i] = "um";
                    }
                }
            }
            dest.putPixelSizes(pixelSizes);
            dest.putUnits(units);
            if (retrieve.getPlaneCount(0) > 0) {
                Double[] timestamps = new Double[(int)source.get(0).getAxisLength(Axes.TIME)];
                for (int t = 0; t < timestamps.length; ++t) {
                    timestamps[t] = retrieve.getPlaneDeltaT(0, t).value().doubleValue();
                }
                dest.putTimestamps(timestamps);
                dest.putExposureTime(Double.valueOf(retrieve.getPlaneExposureTime(0, 0).value().doubleValue()));
            }
            HashMap<Integer, String> channelNames = new HashMap<Integer, String>();
            HashMap<Integer, Double> pinholes = new HashMap<Integer, Double>();
            HashMap<Integer, Double> gains = new HashMap<Integer, Double>();
            ArrayList<Integer> emWaves = new ArrayList<Integer>();
            ArrayList<Integer> exWaves = new ArrayList<Integer>();
            long planeCount = source.get(0).getPlaneCount();
            long tLen = source.get(0).getAxisLength(Axes.TIME);
            long zLen = source.get(0).getAxisLength(Axes.Z);
            long effSizeC = planeCount / (tLen * zLen);
            int i = 0;
            while ((long)i < effSizeC) {
                Double chGain;
                Length exWave;
                Length emWave;
                Length pinSize;
                String cName = retrieve.getChannelName(0, i);
                if (cName != null) {
                    channelNames.put(i, cName);
                }
                if ((pinSize = retrieve.getChannelPinholeSize(0, i)) != null) {
                    pinholes.put(i, pinSize.value().doubleValue());
                }
                if ((emWave = retrieve.getChannelEmissionWavelength(0, i)) != null) {
                    emWaves.add(emWave.value().intValue());
                }
                if ((exWave = retrieve.getChannelExcitationWavelength(0, i)) != null) {
                    exWaves.add(exWave.value().intValue());
                }
                if (retrieve.getInstrumentCount() > 0 && retrieve.getDetectorCount(0) > 0 && (chGain = retrieve.getDetectorSettingsGain(0, i)) != null) {
                    gains.put(i, chGain);
                }
                ++i;
            }
            dest.putChannelNames(channelNames);
            dest.putPinholes(pinholes);
            dest.putEXWaves(exWaves.toArray(new Integer[exWaves.size()]));
            dest.putEMWaves(emWaves.toArray(new Integer[emWaves.size()]));
            dest.putGains(gains);
        }
    }
}

