/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kappa.gui;

import com.opencsv.CSVWriter;
import ij.io.FileInfo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import sc.fiji.kappa.curve.BezierGroup;
import sc.fiji.kappa.curve.Curve;
import sc.fiji.kappa.gui.KappaFrame;

public class CurvesExporter {
    private KappaFrame frame;

    public CurvesExporter(KappaFrame frame) {
        this.frame = frame;
    }

    public void export() throws IOException {
        this.export(true);
    }

    public void export(boolean exportAveragePerCurve) throws IOException {
        JFileChooser kappaExport = new JFileChooser();
        FileInfo fileInfo = this.frame.getImageStack().getOriginalFileInfo();
        String dirPath = null;
        if (fileInfo != null && (dirPath = fileInfo.directory) != null) {
            String kappaPath = FilenameUtils.removeExtension((String)this.frame.getImageStack().getOriginalFileInfo().fileName);
            kappaPath = kappaPath + ".csv";
            File fullPath = new File(dirPath, kappaPath);
            kappaExport.setSelectedFile(fullPath);
        }
        kappaExport.setFileFilter(new FileNameExtensionFilter("CSV File", "csv"));
        kappaExport.setDialogTitle("Export Curve Data");
        int returnVal = kappaExport.showSaveDialog(this.frame);
        if (returnVal == 0) {
            File file = kappaExport.getSelectedFile();
            this.exportToFile(file, exportAveragePerCurve);
        }
    }

    public void exportToFile(String file, boolean exportAveragePerCurve) throws IOException {
        this.exportToFile(new File(file), exportAveragePerCurve);
    }

    public void exportToFile(File file, boolean exportAveragePerCurve) throws IOException {
        BezierGroup curves = this.frame.getCurves();
        if (!file.getPath().toLowerCase().endsWith(".csv")) {
            file = new File(file.getPath() + ".csv");
        }
        CSVWriter writer = new CSVWriter((Writer)new FileWriter(file.getAbsoluteFile()));
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Curve Name");
        headers.add("Curve Length (um)");
        headers.add("Average Curvature (um-1)");
        headers.add("Curvature Std (um-1)");
        headers.add("X-Coordinate (um)");
        headers.add("Y-Coordinate (um)");
        headers.add("Point Curvature (um-1)");
        headers.add("Point Curvature Sign");
        headers.add("Red Intensity");
        headers.add("Green Intensity");
        headers.add("Blue Intensity");
        writer.writeNext((String[])headers.stream().toArray(String[]::new));
        int w = this.frame.getCurrImage().getWidth();
        int h = this.frame.getCurrImage().getHeight();
        double[][] averaged = new double[w][h];
        for (Curve c : curves) {
            String[] lines;
            StringWriter out = new StringWriter();
            PrintWriter printWriter = new PrintWriter(out);
            c.printValues(printWriter, averaged, !exportAveragePerCurve);
            writer.flush();
            for (String line : lines = out.toString().split("\n")) {
                writer.writeNext(line.split(","));
            }
        }
        writer.close();
    }
}

