/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.NodeComponent;
import org.scijava.java3d.Texture;
import org.scijava.java3d.Texture3DRetained;

public class Texture3D
extends Texture {
    public Texture3D() {
    }

    public Texture3D(int mipmapMode, int format, int width, int height, int depth) {
        super(mipmapMode, format, width, height);
        int depthLevels = -1;
        depthLevels = Texture3D.getLevelsNPOT(depth);
        ((Texture3DRetained)this.retained).setDepth(depth);
    }

    public Texture3D(int mipmapMode, int format, int width, int height, int depth, int boundaryWidth) {
        super(mipmapMode, format, width, height, boundaryWidth);
        int depthLevels = -1;
        depthLevels = Texture3D.getLevelsNPOT(depth);
        ((Texture3DRetained)this.retained).setDepth(depth);
    }

    public void setBoundaryModeR(int boundaryModeR) {
        this.checkForLiveOrCompiled();
        switch (boundaryModeR) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("Texture31"));
            }
        }
        ((Texture3DRetained)this.retained).initBoundaryModeR(boundaryModeR);
    }

    public int getBoundaryModeR() {
        if (this.isLiveOrCompiled() && !this.getCapability(2)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture3D0"));
        }
        return ((Texture3DRetained)this.retained).getBoundaryModeR();
    }

    public int getDepth() {
        if (this.isLiveOrCompiled() && !this.getCapability(8)) {
            throw new CapabilityNotSetException(J3dI18N.getString("Texture3D2"));
        }
        return ((Texture3DRetained)this.retained).getDepth();
    }

    @Override
    void createRetained() {
        this.retained = new Texture3DRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        Texture3DRetained t3d = (Texture3DRetained)this.retained;
        Texture3D t = new Texture3D(t3d.getMipMapMode(), t3d.format, t3d.width, t3d.height, t3d.depth);
        t.duplicateNodeComponent(this);
        return t;
    }

    @Override
    public void duplicateNodeComponent(NodeComponent originalNodeComponent) {
        this.checkDuplicateNodeComponent(originalNodeComponent);
    }

    @Override
    void duplicateAttributes(NodeComponent originalNodeComponent, boolean forceDuplicate) {
        super.duplicateAttributes(originalNodeComponent, forceDuplicate);
        ((Texture3DRetained)this.retained).initBoundaryModeR(((Texture3DRetained)originalNodeComponent.retained).getBoundaryModeR());
    }
}

