/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Enumeration;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.Interpolator;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeReferenceTable;
import org.scijava.java3d.TransparencyAttributes;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupOnElapsedFrames;

public class TransparencyInterpolator
extends Interpolator {
    TransparencyAttributes target;
    float minimumTransparency;
    float maximumTransparency;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    TransparencyInterpolator() {
    }

    public TransparencyInterpolator(Alpha alpha, TransparencyAttributes target) {
        super(alpha);
        this.target = target;
        this.minimumTransparency = 0.0f;
        this.maximumTransparency = 1.0f;
    }

    public TransparencyInterpolator(Alpha alpha, TransparencyAttributes target, float minimumTransparency, float maximumTransparency) {
        super(alpha);
        this.target = target;
        this.minimumTransparency = minimumTransparency;
        this.maximumTransparency = maximumTransparency;
    }

    public void setMinimumTransparency(float transparency) {
        this.minimumTransparency = transparency;
    }

    public float getMinimumTransparency() {
        return this.minimumTransparency;
    }

    public void setMaximumTransparency(float transparency) {
        this.maximumTransparency = transparency;
    }

    public float getMaximumTransparency() {
        return this.maximumTransparency;
    }

    public void setTarget(TransparencyAttributes target) {
        this.target = target;
    }

    public TransparencyAttributes getTarget() {
        return this.target;
    }

    @Override
    public void processStimulus(Enumeration criteria) {
        WakeupCriterion criterion = this.passiveWakeupCriterion;
        if (this.alpha != null) {
            float value = this.alpha.value();
            if (value != this.prevAlphaValue) {
                float val = (float)((1.0 - (double)value) * (double)this.minimumTransparency + (double)(value * this.maximumTransparency));
                this.target.setTransparency(val);
                this.prevAlphaValue = value;
            }
            if (!this.alpha.finished() && !this.alpha.isPaused()) {
                criterion = this.defaultWakeupCriterion;
            }
        }
        this.wakeupOn(criterion);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        TransparencyInterpolator ti = new TransparencyInterpolator();
        ti.duplicateNode(this, forceDuplicate);
        return ti;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        TransparencyInterpolator ti = (TransparencyInterpolator)originalNode;
        this.setMinimumTransparency(ti.getMinimumTransparency());
        this.setMaximumTransparency(ti.getMaximumTransparency());
        this.setTarget(ti.getTarget());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        super.updateNodeReferences(referenceTable);
        TransparencyAttributes nc = this.getTarget();
        if (nc != null) {
            this.setTarget((TransparencyAttributes)referenceTable.getNewObjectReference(nc));
        }
    }
}

