/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.panorama;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.process.ImageProcessor;
import mpicbg.ij.InverseTransformMapping;
import mpicbg.models.InverseCoordinateTransform;
import mpicbg.panorama.AbstractPanorama_View;
import mpicbg.panorama.EquirectangularProjection;
import mpicbg.panorama.HomogeneousMapping;
import mpicbg.panorama.PanoramaCamera;
import mpicbg.panorama.RectlinearCamera;
import mpicbg.panorama.Util;

public class Panorama_View
extends AbstractPanorama_View {
    private ImageProcessor frontSource;
    private ImageProcessor backSource;
    private ImageProcessor leftSource;
    private ImageProcessor rightSource;
    private ImageProcessor topSource;
    private ImageProcessor bottomSource;
    private static boolean showCubefaces = false;
    private MappingThread painter;

    @Override
    protected boolean setup(ImagePlus imp) {
        GenericDialog gd = new GenericDialog("Panorama Viewer");
        gd.addMessage("Panorama");
        gd.addNumericField("min lambda : ", minLambda / Math.PI * 180.0, 2);
        gd.addNumericField("min phi : ", minPhi / Math.PI * 180.0, 2);
        gd.addNumericField("hfov : ", hfov / Math.PI * 180.0, 2);
        gd.addNumericField("vfov : ", vfov / Math.PI * 180.0, 2);
        gd.addMessage("Viewer Window");
        gd.addNumericField("width : ", (double)width, 0);
        gd.addNumericField("height : ", (double)height, 0);
        gd.addMessage("Miscellaneous");
        gd.addCheckbox("show cube-faces", showCubefaces);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        minLambda = Util.mod(gd.getNextNumber(), 360.0) / 180.0 * Math.PI;
        minPhi = Util.mod(gd.getNextNumber(), 180.0) / 180.0 * Math.PI;
        hfov = Math.min(Math.PI * 2 - minLambda, Util.mod(gd.getNextNumber(), 360.0) / 180.0 * Math.PI);
        vfov = Math.min(Math.PI - minPhi, Util.mod(gd.getNextNumber(), 180.0) / 180.0 * Math.PI);
        if (hfov == 0.0) {
            hfov = Math.PI * 2;
        }
        if (vfov == 0.0) {
            vfov = Math.PI;
        }
        System.out.println(minLambda + " " + minPhi + " " + hfov + " " + vfov);
        width = (int)gd.getNextNumber();
        height = (int)gd.getNextNumber();
        showCubefaces = gd.getNextBoolean();
        return true;
    }

    @Override
    public void run(String arg) {
        this.imp = IJ.getImage();
        if (this.imp == null) {
            IJ.error((String)"No image open.");
            return;
        }
        if (!this.setup(this.imp)) {
            return;
        }
        this.run(this.imp, width, height, minLambda, minPhi, hfov, vfov);
    }

    @Override
    protected MappingThread createPainter(ImagePlus impViewer) {
        int cubeSize = (int)Math.round(Math.max(this.p.getPhiPiScale(), this.p.getLambdaPiScale()) * 2.0 / Math.PI);
        this.frontSource = this.ip.createProcessor(cubeSize + 1, cubeSize + 1);
        this.backSource = this.ip.createProcessor(cubeSize + 1, cubeSize + 1);
        this.leftSource = this.ip.createProcessor(cubeSize + 1, cubeSize + 1);
        this.rightSource = this.ip.createProcessor(cubeSize + 1, cubeSize + 1);
        this.topSource = this.ip.createProcessor(cubeSize + 1, cubeSize + 1);
        this.bottomSource = this.ip.createProcessor(cubeSize + 1, cubeSize + 1);
        this.renderCubeFaces(hfov, vfov);
        CubeFaceMapper mapper = new CubeFaceMapper(this.p);
        return new MappingThread(this.imp, impViewer, mapper, this.ip, this.p);
    }

    private final void renderCubeFaces(double hfov, double vfov) {
        double cubeSize = this.frontSource.getWidth() - 1;
        this.ipSource = this.ip.createProcessor(hfov == Math.PI * 2 ? this.imp.getWidth() + 1 : this.imp.getWidth(), vfov == Math.PI ? this.imp.getHeight() + 1 : this.imp.getHeight());
        Panorama_View.prepareExtendedImage(this.imp.getProcessor(), this.ipSource);
        EquirectangularProjection q = this.p.clone();
        q.resetOrientation();
        q.setTargetWidth(cubeSize);
        q.setTargetHeight(cubeSize);
        q.setF(0.5);
        InverseTransformMapping qMapping = new InverseTransformMapping((InverseCoordinateTransform)q);
        IJ.showStatus((String)"Rendering cube faces...");
        IJ.showProgress((int)0, (int)6);
        qMapping.mapInterpolated(this.ipSource, this.frontSource);
        IJ.showProgress((int)1, (int)6);
        q.pan(Math.PI);
        qMapping.mapInterpolated(this.ipSource, this.backSource);
        IJ.showProgress((int)2, (int)6);
        q.resetOrientation();
        q.pan(1.5707963267948966);
        qMapping.mapInterpolated(this.ipSource, this.leftSource);
        IJ.showProgress((int)3, (int)6);
        q.resetOrientation();
        q.pan(-1.5707963267948966);
        qMapping.mapInterpolated(this.ipSource, this.rightSource);
        IJ.showProgress((int)4, (int)6);
        q.resetOrientation();
        q.tilt(-1.5707963267948966);
        qMapping.mapInterpolated(this.ipSource, this.topSource);
        IJ.showProgress((int)5, (int)6);
        q.resetOrientation();
        q.tilt(1.5707963267948966);
        qMapping.mapInterpolated(this.ipSource, this.bottomSource);
        IJ.showProgress((int)6, (int)6);
        if (showCubefaces) {
            new ImagePlus("front", this.frontSource).show();
            new ImagePlus("back", this.backSource).show();
            new ImagePlus("left", this.leftSource).show();
            new ImagePlus("right", this.rightSource).show();
            new ImagePlus("top", this.topSource).show();
            new ImagePlus("bottom", this.bottomSource).show();
        }
    }

    private final class MappingThread
    extends AbstractPanorama_View.AbstractMappingThread {
        protected final CubeFaceMapper mapper;
        protected final PanoramaCamera<?> camera;

        public MappingThread(ImagePlus impSource, ImagePlus impTarget, CubeFaceMapper mapper, ImageProcessor target, PanoramaCamera<?> camera) {
            super(impSource, impTarget, target);
            this.mapper = mapper;
            this.camera = camera;
        }

        @Override
        protected final void map() {
            Panorama_View.this.lambda += this.dt * Panorama_View.this.dLambda;
            Panorama_View.this.phi += this.dt * Panorama_View.this.dPhi;
            this.camera.setOrientation(Panorama_View.this.lambda, Panorama_View.this.phi, Panorama_View.this.rho);
            this.mapper.map(this.temp);
        }

        @Override
        public final void toggleInterpolation() {
            this.mapper.toggleInterpolation();
        }
    }

    private final class CubeFaceMapper {
        protected boolean interpolate = true;
        private final HomogeneousMapping<RectlinearCamera> mapping = new HomogeneousMapping<RectlinearCamera>(new RectlinearCamera());
        private final PanoramaCamera<?> camera;
        private final RectlinearCamera front;

        public CubeFaceMapper(PanoramaCamera<?> camera) {
            this.camera = camera;
            this.front = new RectlinearCamera();
            this.front.setCamera(camera);
            this.front.setSourceWidth(Panorama_View.this.frontSource.getWidth() - 1);
            this.front.setSourceHeight(Panorama_View.this.frontSource.getHeight() - 1);
        }

        public final void toggleInterpolation() {
            this.interpolate = !this.interpolate;
        }

        public final void map(ImageProcessor target) {
            this.front.setTargetWidth(target.getWidth());
            this.front.setTargetHeight(target.getHeight());
            this.front.setCamera(this.camera);
            RectlinearCamera face = this.front.clone();
            face.resetOrientation();
            target.reset();
            if (this.interpolate) {
                ((RectlinearCamera)this.mapping.getTransform()).set(this.front);
                this.mapping.mapInterpolated(Panorama_View.this.frontSource, target);
                face.pan(1.5707963267948966);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.mapInterpolated(Panorama_View.this.rightSource, target);
                face.resetOrientation();
                face.pan(Math.PI);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.mapInterpolated(Panorama_View.this.backSource, target);
                face.resetOrientation();
                face.pan(4.71238898038469);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.mapInterpolated(Panorama_View.this.leftSource, target);
                face.resetOrientation();
                face.tilt(1.5707963267948966);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.mapInterpolated(Panorama_View.this.topSource, target);
                face.resetOrientation();
                face.tilt(-1.5707963267948966);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.mapInterpolated(Panorama_View.this.bottomSource, target);
            } else {
                ((RectlinearCamera)this.mapping.getTransform()).set(this.front);
                this.mapping.map(Panorama_View.this.frontSource, target);
                face.pan(1.5707963267948966);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.map(Panorama_View.this.rightSource, target);
                face.resetOrientation();
                face.pan(Math.PI);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.map(Panorama_View.this.backSource, target);
                face.resetOrientation();
                face.pan(4.71238898038469);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.map(Panorama_View.this.leftSource, target);
                face.resetOrientation();
                face.tilt(1.5707963267948966);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.map(Panorama_View.this.topSource, target);
                face.resetOrientation();
                face.tilt(-1.5707963267948966);
                face.preConcatenateOrientation(this.front);
                ((RectlinearCamera)this.mapping.getTransform()).set(face);
                this.mapping.map(Panorama_View.this.bottomSource, target);
            }
        }
    }
}

