/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.linalg.eigen;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.algorithm.linalg.eigen.EigenValues;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;

public class TensorEigenValues {
    public static <T extends RealType<T>, U extends RealType<U>> RandomAccessibleInterval<U> calculateEigenValuesSymmetric(RandomAccessibleInterval<T> tensor, RandomAccessibleInterval<U> eigenvalues) {
        int nDim = tensor.numDimensions() - 1;
        assert (eigenvalues.dimension(nDim) * (eigenvalues.dimension(nDim) + 1L) / 2L == tensor.dimension(nDim));
        EigenValues ev = nDim == 1 ? EigenValues.oneDimensional() : (nDim == 2 ? EigenValues.symmetric2D() : (nDim > 2 ? EigenValues.symmetric(nDim) : EigenValues.invalid()));
        return TensorEigenValues.calculateEigenValuesImpl(tensor, eigenvalues, ev);
    }

    public static <T extends RealType<T>, U extends RealType<U>> RandomAccessibleInterval<U> calculateEigenValuesSymmetric(RandomAccessibleInterval<T> tensor, RandomAccessibleInterval<U> eigenvalues, int nTasks, ExecutorService es) {
        int nDim = tensor.numDimensions() - 1;
        assert (eigenvalues.dimension(nDim) * (eigenvalues.dimension(nDim) + 1L) / 2L == tensor.dimension(nDim));
        EigenValues ev = nDim == 1 ? EigenValues.oneDimensional() : (nDim == 2 ? EigenValues.symmetric2D() : (nDim > 2 ? EigenValues.symmetric(nDim) : EigenValues.invalid()));
        return TensorEigenValues.calculateEigenValues(tensor, eigenvalues, ev, nTasks, es);
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> RandomAccessibleInterval<U> calculateEigenValuesSquare(RandomAccessibleInterval<T> tensor, RandomAccessibleInterval<U> eigenvalues) {
        int nDim = tensor.numDimensions() - 1;
        assert (eigenvalues.dimension(nDim) * (eigenvalues.dimension(nDim) + 1L) / 2L == tensor.dimension(nDim));
        EigenValues ev = nDim == 1 ? EigenValues.oneDimensional() : (nDim == 2 ? EigenValues.square2D() : (nDim > 2 ? EigenValues.square(nDim) : EigenValues.invalid()));
        return TensorEigenValues.calculateEigenValuesImpl(tensor, eigenvalues, ev);
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> RandomAccessibleInterval<U> calculateEigenValuesSquare(RandomAccessibleInterval<T> tensor, RandomAccessibleInterval<U> eigenvalues, int nTasks, ExecutorService es) {
        int nDim = tensor.numDimensions() - 1;
        assert (eigenvalues.dimension(nDim) * eigenvalues.dimension(nDim) == tensor.dimension(nDim));
        EigenValues ev = nDim == 1 ? EigenValues.oneDimensional() : (nDim == 2 ? EigenValues.square2D() : (nDim > 2 ? EigenValues.square(nDim) : EigenValues.invalid()));
        return TensorEigenValues.calculateEigenValues(tensor, eigenvalues, ev, nTasks, es);
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> RandomAccessibleInterval<U> calculateEigenValues(RandomAccessibleInterval<T> tensor, RandomAccessibleInterval<U> eigenvalues, EigenValues<T, U> ev) {
        return TensorEigenValues.calculateEigenValuesImpl(tensor, eigenvalues, ev);
    }

    public static <T extends RealType<T>, U extends ComplexType<U>> RandomAccessibleInterval<U> calculateEigenValues(RandomAccessibleInterval<T> tensor, RandomAccessibleInterval<U> eigenvalues, EigenValues<T, U> ev, int nTasks, ExecutorService es) {
        assert (nTasks > 0) : "Passed nTasks < 1";
        int tensorDims = tensor.numDimensions();
        long dimensionMax = Long.MIN_VALUE;
        int dimensionArgMax = -1;
        for (int d = 0; d < tensorDims - 1; ++d) {
            long size = tensor.dimension(d);
            if (size <= dimensionMax) continue;
            dimensionMax = size;
            dimensionArgMax = d;
        }
        long stepSize = Math.max(dimensionMax / (long)nTasks, 1L);
        long stepSizeMinusOne = stepSize - 1L;
        long max = dimensionMax - 1L;
        ArrayList<Callable<RandomAccessibleInterval>> tasks = new ArrayList<Callable<RandomAccessibleInterval>>();
        for (long currentMin = 0L; currentMin < dimensionMax; currentMin += stepSize) {
            long currentMax = Math.min(currentMin + stepSizeMinusOne, max);
            long[] minT = new long[tensorDims];
            long[] maxT = new long[tensorDims];
            long[] minE = new long[tensorDims];
            long[] maxE = new long[tensorDims];
            tensor.min(minT);
            tensor.max(maxT);
            eigenvalues.min(minE);
            eigenvalues.max(maxE);
            minE[dimensionArgMax] = minT[dimensionArgMax] = currentMin;
            maxE[dimensionArgMax] = maxT[dimensionArgMax] = currentMax;
            IntervalView currentTensor = Views.interval(tensor, new FinalInterval(minT, maxT));
            IntervalView currentEigenvalues = Views.interval(eigenvalues, new FinalInterval(minE, maxE));
            tasks.add(() -> TensorEigenValues.calculateEigenValuesImpl(currentTensor, currentEigenvalues, ev.copy()));
        }
        try {
            List futures = es.invokeAll(tasks);
            for (Future f : futures) {
                try {
                    f.get();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return eigenvalues;
    }

    private static <T extends RealType<T>, U extends ComplexType<U>> RandomAccessibleInterval<U> calculateEigenValuesImpl(RandomAccessibleInterval<T> tensor, RandomAccessibleInterval<U> eigenvalues, EigenValues<T, U> ev) {
        RealCursor m = Views.iterable(Views.collapseReal(tensor)).cursor();
        RealCursor e = Views.iterable(Views.collapseNumeric(eigenvalues)).cursor();
        while (m.hasNext()) {
            ev.compute((Composite)m.next(), (Composite)e.next());
        }
        return eigenvalues;
    }

    public static <T extends RealType<T>, U extends RealType<U>> Img<U> createAppropriateResultImg(RandomAccessibleInterval<T> tensor, ImgFactory<U> factory) {
        int nDim = tensor.numDimensions();
        long[] dimensions = new long[nDim];
        tensor.dimensions(dimensions);
        dimensions[nDim - 1] = nDim - 1;
        return factory.create(dimensions);
    }

    @Deprecated
    public static <T extends RealType<T>, U extends RealType<U>> Img<U> createAppropriateResultImg(RandomAccessibleInterval<T> tensor, ImgFactory<U> factory, U u) {
        return TensorEigenValues.createAppropriateResultImg(tensor, factory.imgFactory(u));
    }
}

