/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.math.abstractions;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.math.ImgSource;
import net.imglib2.algorithm.math.Let;
import net.imglib2.algorithm.math.NumberSource;
import net.imglib2.algorithm.math.RandomAccessibleSource;
import net.imglib2.algorithm.math.Var;
import net.imglib2.algorithm.math.abstractions.ABinaryFunction;
import net.imglib2.algorithm.math.abstractions.IBinaryFunction;
import net.imglib2.algorithm.math.abstractions.IFunction;
import net.imglib2.algorithm.math.abstractions.IImgSourceIterable;
import net.imglib2.algorithm.math.abstractions.ITrinaryFunction;
import net.imglib2.algorithm.math.abstractions.IUnaryFunction;
import net.imglib2.algorithm.math.abstractions.OFunction;
import net.imglib2.algorithm.math.abstractions.RandomAccessOnly;
import net.imglib2.algorithm.math.abstractions.SourceInterval;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public class Util {
    public static boolean compatibleIterationOrder(List<RandomAccessibleInterval<?>> images) {
        if (images.isEmpty()) {
            return true;
        }
        Iterator<RandomAccessibleInterval<?>> it = images.iterator();
        RandomAccessibleInterval<?> first = it.next();
        Object order = Views.iterable(first).iterationOrder();
        boolean same_iteration_order = true;
        while (it.hasNext()) {
            RandomAccessibleInterval<?> other = it.next();
            if (other.numDimensions() != first.numDimensions()) {
                throw new RuntimeException("Images have different number of dimensions");
            }
            for (int d = 0; d < first.numDimensions(); ++d) {
                if (first.realMin(d) == other.realMin(d) && first.realMax(d) == other.realMax(d)) continue;
                throw new RuntimeException("Images have different sizes");
            }
            if (order.equals(Views.iterable(other).iterationOrder())) continue;
            same_iteration_order = false;
        }
        return same_iteration_order;
    }

    public static final IFunction wrap(Object o) {
        if (o instanceof RandomAccessibleInterval) {
            return new ImgSource((RandomAccessibleInterval)o);
        }
        if (o instanceof RandomAccessible) {
            return new RandomAccessibleSource((RandomAccessible)o);
        }
        if (o instanceof Number) {
            return new NumberSource(((Number)o).doubleValue());
        }
        if (o instanceof IFunction) {
            return (IFunction)o;
        }
        if (o instanceof String) {
            return new Var((String)o);
        }
        return null;
    }

    public static final Set<RandomAccessibleInterval<?>> findImg(IFunction f) {
        HashSet images = new HashSet();
        LinkedList<IFunction> ops = new LinkedList<IFunction>();
        ops.add(f);
        while (!ops.isEmpty()) {
            IFunction op = (IFunction)ops.removeFirst();
            if (op instanceof ImgSource) {
                images.add(((ImgSource)op).getRandomAccessibleInterval());
                continue;
            }
            if (!(op instanceof IUnaryFunction)) continue;
            ops.addLast(((IUnaryFunction)op).getFirst());
            if (!(op instanceof IBinaryFunction)) continue;
            ops.addLast(((IBinaryFunction)op).getSecond());
            if (!(op instanceof ITrinaryFunction)) continue;
            ops.addLast(((ITrinaryFunction)op).getThird());
        }
        return images;
    }

    public static final RandomAccessibleInterval<?> findFirstImg(IFunction f) {
        LinkedList<IFunction> ops = new LinkedList<IFunction>();
        ops.add(f);
        RandomAccessibleInterval<?> extended = null;
        while (!ops.isEmpty()) {
            IFunction op = (IFunction)ops.removeFirst();
            if (op instanceof ImgSource) {
                return ((ImgSource)op).getRandomAccessibleInterval();
            }
            if (null == extended && op instanceof RandomAccessOnly) {
                RandomAccessOnly rao = (RandomAccessOnly)((Object)op);
                if (!(rao.getRandomAccessible() instanceof ExtendedRandomAccessibleInterval)) continue;
                extended = (RandomAccessibleInterval<?>)((ExtendedRandomAccessibleInterval)rao.getRandomAccessible()).getSource();
                continue;
            }
            if (!(op instanceof IUnaryFunction)) continue;
            ops.addLast(((IUnaryFunction)op).getFirst());
            if (!(op instanceof IBinaryFunction)) continue;
            ops.addLast(((IBinaryFunction)op).getSecond());
            if (!(op instanceof ITrinaryFunction)) continue;
            ops.addLast(((ITrinaryFunction)op).getThird());
        }
        return extended;
    }

    public static final Interval findFirstInterval(IFunction f) {
        LinkedList<IFunction> ops = new LinkedList<IFunction>();
        ops.add(f);
        Interval extended = null;
        while (!ops.isEmpty()) {
            IFunction op = (IFunction)ops.removeFirst();
            if (op instanceof SourceInterval) {
                return ((SourceInterval)((Object)op)).getInterval();
            }
            if (null == extended && op instanceof RandomAccessOnly) {
                RandomAccessOnly rao = (RandomAccessOnly)((Object)op);
                if (!(rao.getRandomAccessible() instanceof ExtendedRandomAccessibleInterval)) continue;
                extended = (Interval)((ExtendedRandomAccessibleInterval)rao.getRandomAccessible()).getSource();
                continue;
            }
            if (!(op instanceof IUnaryFunction)) continue;
            ops.addLast(((IUnaryFunction)op).getFirst());
            if (!(op instanceof IBinaryFunction)) continue;
            ops.addLast(((IBinaryFunction)op).getSecond());
            if (!(op instanceof ITrinaryFunction)) continue;
            ops.addLast(((ITrinaryFunction)op).getThird());
        }
        return extended;
    }

    public static final int dimensions(IFunction f) {
        LinkedList<IFunction> ops = new LinkedList<IFunction>();
        ops.add(f);
        while (!ops.isEmpty()) {
            IFunction op = (IFunction)ops.removeFirst();
            if (op instanceof SourceInterval) {
                return ((SourceInterval)((Object)op)).getInterval().numDimensions();
            }
            if (op instanceof RandomAccessOnly) {
                return ((RandomAccessOnly)((Object)op)).getRandomAccessible().numDimensions();
            }
            if (!(op instanceof IUnaryFunction)) continue;
            ops.addLast(((IUnaryFunction)op).getFirst());
            if (!(op instanceof IBinaryFunction)) continue;
            ops.addLast(((IBinaryFunction)op).getSecond());
            if (!(op instanceof ITrinaryFunction)) continue;
            ops.addLast(((ITrinaryFunction)op).getThird());
        }
        return 0;
    }

    public static final IFunction[] wrapMap(Object caller, Object[] obs) {
        try {
            if (2 == obs.length) {
                return new IFunction[]{Util.wrap(obs[0]), Util.wrap(obs[1])};
            }
            Constructor<?> constructor = caller.getClass().getConstructor(Object.class, Object.class);
            ABinaryFunction a = (ABinaryFunction)constructor.newInstance(obs[0], obs[1]);
            for (int i = 2; i < obs.length - 1; ++i) {
                ABinaryFunction b;
                a = b = (ABinaryFunction)constructor.newInstance(a, obs[i]);
            }
            return new IFunction[]{a, Util.wrap(obs[obs.length - 1])};
        }
        catch (Exception e) {
            throw new RuntimeException("Error with the constructor for class " + caller.getClass(), e);
        }
    }

    public static final <O extends RealType<O>> Converter<RealType<?>, O> genericRealTypeConverter() {
        return new Converter<RealType<?>, O>(){

            @Override
            public final void convert(RealType<?> input, O output) {
                output.setReal(input.getRealDouble());
            }
        };
    }

    public static final <I extends IntegerType<I>, O extends IntegerType<O>> Converter<I, O> genericIntegerTypeConverter() {
        return new Converter<I, O>(){

            @Override
            public final void convert(I input, O output) {
                output.setInteger(input.getIntegerLong());
            }
        };
    }

    public static final <O extends RealType<O>> IImgSourceIterable<?> findFirstIterableImgSource(OFunction<O> f) {
        LinkedList ops = new LinkedList();
        ops.addLast(f);
        while (!ops.isEmpty()) {
            OFunction op = (OFunction)ops.removeFirst();
            for (OFunction cf : op.children()) {
                if (cf instanceof IImgSourceIterable) {
                    return (IImgSourceIterable)((Object)cf);
                }
                ops.addLast(cf);
            }
        }
        return null;
    }

    public static final <O extends RealType<O>> List<IImgSourceIterable<?>> findAllIterableImgSource(OFunction<O> f) {
        LinkedList ops = new LinkedList();
        ops.addLast(f);
        ArrayList iis = new ArrayList();
        while (!ops.isEmpty()) {
            OFunction op = (OFunction)ops.removeFirst();
            for (OFunction cf : op.children()) {
                if (cf instanceof IImgSourceIterable) {
                    iis.add((IImgSourceIterable)((Object)cf));
                    continue;
                }
                ops.addLast(cf);
            }
        }
        return iis;
    }

    public static final String hierarchy(IFunction f) {
        LinkedList<IFunction> ops = new LinkedList<IFunction>();
        ops.add(f);
        StringBuilder hierarchy = new StringBuilder();
        LinkedList<String> indents = new LinkedList<String>();
        indents.add("");
        while (!ops.isEmpty()) {
            IFunction op = (IFunction)ops.removeFirst();
            String indent = (String)indents.removeFirst();
            String pre = "";
            String post = "";
            if (op instanceof IUnaryFunction) {
                ops.addFirst(((IUnaryFunction)op).getFirst());
                indents.addFirst(indent + "  ");
                if (op instanceof IBinaryFunction) {
                    if (op instanceof Let) {
                        post = " \"" + ((Let)op).getVarName() + "\" -> ";
                    }
                    ops.add(1, ((IBinaryFunction)op).getSecond());
                    indents.add(1, indent + "  ");
                    if (op instanceof ITrinaryFunction) {
                        ops.add(2, ((ITrinaryFunction)op).getThird());
                        indents.add(2, indent + "  ");
                    }
                }
            } else if (op instanceof Var) {
                pre = "\"" + ((Var)op).getName() + "\" ";
            }
            hierarchy.append(indent + pre + op.getClass().getSimpleName() + post + "\n");
        }
        return hierarchy.toString();
    }

    public static final String hierarchy(OFunction<?> f) {
        StringBuilder hierarchy = new StringBuilder();
        LinkedList<String> indents = new LinkedList<String>();
        indents.add("");
        LinkedList ops = new LinkedList();
        ops.addLast(f);
        while (!ops.isEmpty()) {
            OFunction op = (OFunction)ops.removeFirst();
            String indent = (String)indents.removeFirst();
            for (OFunction cf : op.children()) {
                ops.addFirst(cf);
                indents.addFirst(indent + "  ");
            }
            hierarchy.append(indent + op.getClass().getSimpleName() + "\n");
        }
        return hierarchy.toString();
    }
}

