/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;
import fiji.plugin.volumeviewer.Volume;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class TFalpha2
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private int height = 128;
    private int width = 256;
    private final int[][] alpha2back = new int[256][128];
    private final float[][] alpha2 = new float[256][128];
    final int[][] a2 = new int[256][128];
    private int scaleAlpha = 0;
    private int[] pixels;
    private int sampleValue = -1;
    private int gradValue = -1;
    private Control control;
    private Volume vol;
    private int[][][] lut2D_2;
    private int[][] lut;
    int xLast = -1;
    int yLast = -1;
    int count = 0;

    public void setAlphaOffset(int scaleAlpha2) {
        this.scaleAlpha = scaleAlpha2;
    }

    public TFalpha2(Control control, Volume vol, int[][] lut, int[][][] lut2D_2) {
        this.control = control;
        this.vol = vol;
        this.lut = lut;
        this.lut2D_2 = lut2D_2;
        for (int i = 0; i < this.alpha2.length; ++i) {
            for (int j = 0; j < this.alpha2[0].length; ++j) {
                this.alpha2[i][j] = -1000.0f;
            }
        }
        this.setPreferredSize(new Dimension(256, this.height));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.pixels = new int[this.width * this.height];
        this.setAlphaAuto();
    }

    public void setValues(int[] vals) {
        this.sampleValue = vals[0];
        this.gradValue = vals[1];
    }

    public void clearAlpha() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < 256; ++x) {
                this.alpha2[x][y] = -1000.0f;
                this.a2[x][y] = 0;
            }
        }
        this.control.alphaWasChanged = true;
    }

    public void scaleAlpha() {
        for (int x = 0; x < 256; ++x) {
            for (int y = 0; y < 128; ++y) {
                int alpha = (int)this.alpha2[x][y];
                alpha = alpha != -1000 ? (alpha += this.scaleAlpha) : 0;
                if (alpha > 255) {
                    alpha = 255;
                } else if (alpha < 0) {
                    alpha = 0;
                }
                this.a2[x][y] = alpha;
            }
        }
        this.control.alphaWasChanged = true;
    }

    public void setAlphaAuto() {
        int y;
        int x;
        int val;
        int x2;
        int y2;
        float max1 = 0.0f;
        for (y2 = 0; y2 < this.vol.histValGrad[0].length; ++y2) {
            for (x2 = 0; x2 < this.vol.histValGrad.length; ++x2) {
                val = this.vol.histValGrad[x2][y2];
                if (!((float)val > max1)) continue;
                max1 = val;
            }
        }
        for (y2 = 0; y2 < this.height; ++y2) {
            for (x2 = 0; x2 < 256; ++x2) {
                val = (int)(510.0 * Math.pow((float)this.vol.histValGrad[x2][y2] / max1, 0.22));
                if (val > 255) {
                    val = 255;
                }
                this.alpha2back[x2][y2] = 255 - val;
            }
        }
        float[] alpha1D = new float[256];
        float sum = 0.0f;
        for (int x3 = 0; x3 < 256; ++x3) {
            float val2 = (float)(1.0 - Math.pow((float)this.vol.histVal[x3] / max1, 0.1));
            sum += val2;
            alpha1D[x3] = val2;
        }
        sum /= 256.0f;
        float[] alpha1Dauto = new float[256];
        for (int x4 = 0; x4 < 256; ++x4) {
            int xm2 = x4 > 1 ? x4 - 2 : 0;
            int xm1 = x4 > 0 ? x4 - 1 : 0;
            int xp1 = x4 < 255 ? x4 + 1 : 255;
            int xp2 = x4 < 254 ? x4 + 2 : 255;
            float val3 = (alpha1D[xm2] + alpha1D[xm1] + alpha1D[x4] + alpha1D[xp1] + alpha1D[xp2]) * 0.2f;
            alpha1Dauto[x4] = Math.max(0.0f, val3 += 0.5f - sum);
        }
        for (int y3 = 0; y3 < this.vol.histValGrad[0].length; ++y3) {
            for (x = 0; x < this.vol.histValGrad.length; ++x) {
                int val4 = this.vol.histValGrad[x][y3];
                if (!((float)val4 > max1)) continue;
                max1 = val4;
            }
        }
        float[][] alpha2Dauto = new float[256][128];
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 128; ++y) {
                float val5 = (float)(1.0 - 3.0 * Math.pow((float)this.vol.histValGrad[x][y] / max1, 0.22));
                sum += val5;
                this.alpha2[x][y] = val5;
            }
        }
        sum /= 32768.0f;
        for (int y4 = 0; y4 < 128; ++y4) {
            int ym2 = y4 > 1 ? y4 - 2 : 0;
            int ym1 = y4 > 0 ? y4 - 1 : 0;
            int yp1 = y4 < this.height - 1 ? y4 + 1 : this.height - 1;
            int yp2 = y4 < this.height - 2 ? y4 + 2 : this.height - 1;
            for (int x5 = 0; x5 < 256; ++x5) {
                float val6;
                alpha2Dauto[x5][y4] = val6 = (this.alpha2[x5][ym2] + this.alpha2[x5][ym1] + this.alpha2[x5][y4] + this.alpha2[x5][yp1] + this.alpha2[x5][yp2]) * 0.2f;
            }
        }
        for (x = 0; x < 256; ++x) {
            for (y = 0; y < 128; ++y) {
                float val7 = alpha2Dauto[x][y] * alpha1Dauto[x];
                this.alpha2[x][y] = val7 = 255.0f * (val7 + 0.8f - sum);
                this.a2[x][y] = (int)Math.min(Math.max(0.0f, val7), 255.0f);
                this.lut2D_2[x][y][0] = this.lut[x][0];
                this.lut2D_2[x][y][1] = this.lut[x][1];
                this.lut2D_2[x][y][2] = this.lut[x][2];
            }
        }
        this.control.alphaWasChanged = true;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.xLast = e.getX();
        this.yLast = e.getY();
        this.control.drag = true;
        this.handleMouseDragged(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.control.drag = false;
        this.control.newDisplayMode();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleMouseDragged(e);
        if (this.count++ % 10 == 0) {
            this.control.newDisplayMode();
        }
    }

    public void handleMouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > 255) {
            x = 255;
        }
        if (y > this.height) {
            y = this.height - 1;
        }
        y = this.height - 1 - y;
        int v = this.control.alphaPaint2;
        if (e.isAltDown()) {
            v = 0;
        }
        for (int y_ = Math.max(0, y - 6); y_ <= Math.min(y + 6, this.height - 1); ++y_) {
            for (int x_ = Math.max(0, x - 6); x_ <= Math.min(x + 6, 255); ++x_) {
                this.a2[x_][y_] = v;
                this.alpha2[x_][y_] = v > 0 ? (float)(v - this.scaleAlpha) : -1000.0f;
                if (this.control.pickColor) {
                    this.lut2D_2[x_][y_][0] = this.control.rPaint;
                    this.lut2D_2[x_][y_][1] = this.control.gPaint;
                    this.lut2D_2[x_][y_][2] = this.control.bPaint;
                    continue;
                }
                this.lut2D_2[x_][y_][0] = this.lut[x_][0];
                this.lut2D_2[x_][y_][1] = this.lut[x_][1];
                this.lut2D_2[x_][y_][2] = this.lut[x_][2];
            }
        }
        this.control.alphaWasChanged = true;
        this.repaint();
    }

    void updateLutGradVal() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.lut2D_2[x][y][0] = this.lut[x][0];
                this.lut2D_2[x][y][1] = this.lut[x][1];
                this.lut2D_2[x][y][2] = this.lut[x][2];
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int pos;
        int x;
        Graphics2D g2 = (Graphics2D)g;
        int width = 256;
        for (x = 0; x < width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int pos2 = (this.height - 1 - y) * width + x;
                int valBack = this.alpha2back[x][y];
                int valA = (int)Math.min(255.0, (double)this.a2[x][y] * 1.6);
                int val_A = 255 - valA;
                int valTR = this.lut2D_2[x][y][0];
                int valTG = this.lut2D_2[x][y][1];
                int valTB = this.lut2D_2[x][y][2];
                if (this.control.lutNr == 1 || this.control.lutNr == 0) {
                    valTR = 255;
                    valTG = 128;
                    valTB = 0;
                }
                int valR = valBack;
                int valG = valBack;
                int valB = valBack;
                if (valBack < 255) {
                    valR = val_A * valBack + valA * valTR >> 8;
                    valG = val_A * valBack + valA * valTG >> 8;
                    valB = val_A * valBack + valA * valTB >> 8;
                }
                this.pixels[pos2] = 0xFF000000 | valR << 16 | valG << 8 | valB;
            }
        }
        if (this.sampleValue >= 0) {
            for (int y = 0; y < this.height; ++y) {
                pos = y * width + this.sampleValue;
                this.pixels[pos] = -14769409;
            }
        }
        if (this.gradValue >= 0) {
            for (x = 0; x < width; ++x) {
                pos = (this.height - 1 - this.gradValue) * width + x;
                this.pixels[pos] = -14769409;
            }
        }
        BufferedImage image = new BufferedImage(width, this.height, 2);
        image.setRGB(0, 0, width, this.height, this.pixels, 0, width);
        g2.drawImage((Image)image, 0, 0, null);
    }
}

