/*
 * Decompiled with CFR 0.152.
 */
package jRenderer3D;

import jRenderer3D.Point3D;
import jRenderer3D.SurfacePlotData;
import jRenderer3D.Text3D;

class Transform {
    private int zOrientation = -1;
    private double angleX = 0.0;
    private double angleY = 0.0;
    private double angleZ = 0.0;
    private double xs = 256.0;
    private double ys = 256.0;
    private double cosZ;
    private double sinZ;
    private double cosX;
    private double sinX;
    private double cosY;
    private double sinY;
    private double scale = 1.0;
    private double zAspect = 1.0;
    double[][] m = new double[4][4];
    double[][] m_ = new double[4][4];
    double[][] mX = new double[4][4];
    double[][] mY = new double[4][4];
    double[][] mZ = new double[4][4];
    double[][] mP = new double[4][4];
    double[][] m_Z = new double[4][4];
    double[][] m_YZ = new double[4][4];
    double[][] m_XYZ = new double[4][4];
    double[][] m_PXYZ = new double[4][4];
    double[][] m_XYZInv = new double[4][4];
    double xO;
    double yO;
    double zO;
    double a00;
    double a01;
    double a02;
    double a03;
    double a10;
    double a11;
    double a12;
    double a13;
    double a20;
    double a21;
    double a22;
    double a23;
    double ai00;
    double ai01;
    double ai02;
    double ai03;
    double ai10;
    double ai11;
    double ai12;
    double ai13;
    double ai20;
    double ai21;
    double ai22;
    double ai23;
    double y;
    double x;
    double z;
    int[] xyz;
    double X;
    double Y;
    double Z;
    private double perspective = 0.0;
    private double maxDistance = 256.0;

    Transform(int width, int height) {
        this.xs = (double)width / 2.0 + 0.5;
        this.ys = (double)height / 2.0 + 0.5;
        this.initializeTransformation();
    }

    protected void transform(SurfacePlotData plotItem) {
        this.y = plotItem.y;
        this.x = plotItem.x;
        this.z = plotItem.z;
        this.xyzPos();
    }

    protected void transform(Text3D textItem) {
        this.x = textItem.x;
        this.y = textItem.y;
        this.z = textItem.z;
        this.xyzPos();
    }

    protected void transform(double x_, double y_, double z_) {
        this.x = x_;
        this.y = y_;
        this.z = z_;
        this.xyzPos_noShift();
    }

    protected void transform(Point3D pt) {
        this.x = pt.x;
        this.y = pt.y;
        this.z = pt.z;
        this.xyzPos();
    }

    protected void setScale(double scale) {
        this.scale = scale;
        this.initializeTransformation();
    }

    protected void setZOrientation(int zOrientation) {
        this.zOrientation = zOrientation <= 0 ? -1 : 1;
        this.initializeTransformation();
    }

    protected void setZAspectRatio(double zAspectRatio) {
        this.zAspect = zAspectRatio;
        this.initializeTransformation();
    }

    protected void setRotationZ(double angleZ) {
        this.angleZ = angleZ;
        this.initializeTransformation();
    }

    protected void setRotationY(double angleY) {
        this.angleY = angleY;
        this.initializeTransformation();
    }

    protected void setRotationX(double angleX) {
        this.angleX = angleX;
        this.initializeTransformation();
    }

    protected void setRotationXYZ(double angleX, double angleY, double angleZ) {
        this.angleX = angleX;
        this.angleY = angleY;
        this.angleZ = angleZ;
        this.initializeTransformation();
    }

    protected void setRotationXZ(double angleX, double angleZ) {
        this.angleX = angleX;
        this.angleZ = angleZ;
        this.initializeTransformation();
    }

    protected double getRotationX() {
        return this.angleX;
    }

    protected double getRotationY() {
        return this.angleY;
    }

    protected double getRotationZ() {
        return this.angleZ;
    }

    protected void changeRotationXZ(double dx, double dz) {
        this.angleX += dx;
        this.angleZ += dz;
        this.initializeTransformation();
    }

    protected void changeRotationXYZ(double dx, double dy, double dz) {
        this.angleX += dx;
        this.angleY += dy;
        this.angleZ += dz;
        this.initializeTransformation();
    }

    protected void setOffsets(double xOff, double yOff, double zOff) {
        this.xO = -xOff;
        this.yO = -yOff;
        this.zO = -zOff;
        this.initializeTransformation();
    }

    private void initializeTransformation() {
        double s;
        this.cosX = Math.cos(this.angleX);
        this.sinX = Math.sin(this.angleX);
        this.cosY = Math.cos(this.angleY);
        this.sinY = Math.sin(this.angleY);
        this.cosZ = Math.cos(this.angleZ);
        this.sinZ = Math.sin(this.angleZ);
        this.m[0][0] = s = 1.0;
        this.m[0][1] = 0.0;
        this.m[0][2] = 0.0;
        this.m[0][3] = s * this.xO;
        this.m[1][0] = 0.0;
        this.m[1][1] = s;
        this.m[1][2] = 0.0;
        this.m[1][3] = s * this.yO;
        this.m[2][0] = 0.0;
        this.m[2][1] = 0.0;
        this.m[2][2] = s * (double)this.zOrientation * this.zAspect;
        this.m[2][3] = s * (double)this.zOrientation * this.zAspect * this.zO;
        this.m[3][0] = 0.0;
        this.m[3][1] = 0.0;
        this.m[3][2] = 0.0;
        this.m[3][3] = 1.0;
        this.mZ[0][0] = this.cosZ;
        this.mZ[0][1] = this.sinZ;
        this.mZ[0][2] = 0.0;
        this.mZ[0][3] = 0.0;
        this.mZ[1][0] = -this.sinZ;
        this.mZ[1][1] = this.cosZ;
        this.mZ[1][2] = 0.0;
        this.mZ[1][3] = 0.0;
        this.mZ[2][0] = 0.0;
        this.mZ[2][1] = 0.0;
        this.mZ[2][2] = 1.0;
        this.mZ[2][3] = 0.0;
        this.mZ[3][0] = 0.0;
        this.mZ[3][1] = 0.0;
        this.mZ[3][2] = 0.0;
        this.mZ[3][3] = 1.0;
        this.mY[0][0] = this.cosY;
        this.mY[0][1] = 0.0;
        this.mY[0][2] = -this.sinY;
        this.mY[0][3] = 0.0;
        this.mY[1][0] = 0.0;
        this.mY[1][1] = 1.0;
        this.mY[1][2] = 0.0;
        this.mY[1][3] = 0.0;
        this.mY[2][0] = this.sinY;
        this.mY[2][1] = 0.0;
        this.mY[2][2] = this.cosY;
        this.mY[2][3] = 0.0;
        this.mY[3][0] = 0.0;
        this.mY[3][1] = 0.0;
        this.mY[3][2] = 0.0;
        this.mY[3][3] = 1.0;
        this.mX[0][0] = 1.0;
        this.mX[0][1] = 0.0;
        this.mX[0][2] = 0.0;
        this.mX[0][3] = 0.0;
        this.mX[1][0] = 0.0;
        this.mX[1][1] = this.cosX;
        this.mX[1][2] = this.sinX;
        this.mX[1][3] = 0.0;
        this.mX[2][0] = 0.0;
        this.mX[2][1] = -this.sinX;
        this.mX[2][2] = this.cosX;
        this.mX[2][3] = 0.0;
        this.mX[3][0] = 0.0;
        this.mX[3][1] = 0.0;
        this.mX[3][2] = 0.0;
        this.mX[3][3] = 1.0;
        this.matProd(this.m_Z, this.mZ, this.m);
        this.matProd(this.m_YZ, this.mY, this.m_Z);
        this.matProd(this.m_XYZ, this.mX, this.m_YZ);
        this.a00 = this.m_XYZ[0][0];
        this.a01 = this.m_XYZ[0][1];
        this.a02 = this.m_XYZ[0][2];
        this.a03 = this.m_XYZ[0][3];
        this.a10 = this.m_XYZ[1][0];
        this.a11 = this.m_XYZ[1][1];
        this.a12 = this.m_XYZ[1][2];
        this.a13 = this.m_XYZ[1][3];
        this.a20 = this.m_XYZ[2][0];
        this.a21 = this.m_XYZ[2][1];
        this.a22 = this.m_XYZ[2][2];
        this.a23 = this.m_XYZ[2][3];
        this.matInv4(this.m_XYZInv, this.m_XYZ);
        this.ai00 = this.m_XYZInv[0][0];
        this.ai01 = this.m_XYZInv[0][1];
        this.ai02 = this.m_XYZInv[0][2];
        this.ai03 = this.m_XYZInv[0][3];
        this.ai10 = this.m_XYZInv[1][0];
        this.ai11 = this.m_XYZInv[1][1];
        this.ai12 = this.m_XYZInv[1][2];
        this.ai13 = this.m_XYZInv[1][3];
        this.ai20 = this.m_XYZInv[2][0];
        this.ai21 = this.m_XYZInv[2][1];
        this.ai22 = this.m_XYZInv[2][2];
        this.ai23 = this.m_XYZInv[2][3];
    }

    public void rotateTransformation(double angle_X, double angle_Y, double angle_Z) {
        this.cosX = Math.cos(angle_X);
        this.sinX = Math.sin(angle_X);
        this.cosY = Math.cos(angle_Y);
        this.sinY = Math.sin(angle_Y);
        this.cosZ = Math.cos(angle_Z);
        this.sinZ = Math.sin(angle_Z);
        this.m_[0][0] = this.m_XYZ[0][0];
        this.m_[0][1] = this.m_XYZ[0][1];
        this.m_[0][2] = this.m_XYZ[0][2];
        this.m_[0][3] = this.m_XYZ[0][3];
        this.m_[1][0] = this.m_XYZ[1][0];
        this.m_[1][1] = this.m_XYZ[1][1];
        this.m_[1][2] = this.m_XYZ[1][2];
        this.m_[1][3] = this.m_XYZ[1][3];
        this.m_[2][0] = this.m_XYZ[2][0];
        this.m_[2][1] = this.m_XYZ[2][1];
        this.m_[2][2] = this.m_XYZ[2][2];
        this.m_[2][3] = this.m_XYZ[2][3];
        this.m_[3][0] = this.m_XYZ[3][0];
        this.m_[3][1] = this.m_XYZ[3][1];
        this.m_[3][2] = this.m_XYZ[3][2];
        this.m_[3][3] = this.m_XYZ[3][3];
        this.mZ[0][0] = this.cosZ;
        this.mZ[0][1] = this.sinZ;
        this.mZ[0][2] = 0.0;
        this.mZ[0][3] = 0.0;
        this.mZ[1][0] = -this.sinZ;
        this.mZ[1][1] = this.cosZ;
        this.mZ[1][2] = 0.0;
        this.mZ[1][3] = 0.0;
        this.mZ[2][0] = 0.0;
        this.mZ[2][1] = 0.0;
        this.mZ[2][2] = 1.0;
        this.mZ[2][3] = 0.0;
        this.mZ[3][0] = 0.0;
        this.mZ[3][1] = 0.0;
        this.mZ[3][2] = 0.0;
        this.mZ[3][3] = 1.0;
        this.mY[0][0] = this.cosY;
        this.mY[0][1] = 0.0;
        this.mY[0][2] = -this.sinY;
        this.mY[0][3] = 0.0;
        this.mY[1][0] = 0.0;
        this.mY[1][1] = 1.0;
        this.mY[1][2] = 0.0;
        this.mY[1][3] = 0.0;
        this.mY[2][0] = this.sinY;
        this.mY[2][1] = 0.0;
        this.mY[2][2] = this.cosY;
        this.mY[2][3] = 0.0;
        this.mY[3][0] = 0.0;
        this.mY[3][1] = 0.0;
        this.mY[3][2] = 0.0;
        this.mY[3][3] = 1.0;
        this.mX[0][0] = 1.0;
        this.mX[0][1] = 0.0;
        this.mX[0][2] = 0.0;
        this.mX[0][3] = 0.0;
        this.mX[1][0] = 0.0;
        this.mX[1][1] = this.cosX;
        this.mX[1][2] = this.sinX;
        this.mX[1][3] = 0.0;
        this.mX[2][0] = 0.0;
        this.mX[2][1] = -this.sinX;
        this.mX[2][2] = this.cosX;
        this.mX[2][3] = 0.0;
        this.mX[3][0] = 0.0;
        this.mX[3][1] = 0.0;
        this.mX[3][2] = 0.0;
        this.mX[3][3] = 1.0;
        this.matProd(this.m_YZ, this.mY, this.mZ);
        this.matProd(this.m_Z, this.mX, this.m_YZ);
        this.matProd(this.m_XYZ, this.m_Z, this.m_);
        this.a00 = this.m_XYZ[0][0];
        this.a01 = this.m_XYZ[0][1];
        this.a02 = this.m_XYZ[0][2];
        this.a03 = this.m_XYZ[0][3];
        this.a10 = this.m_XYZ[1][0];
        this.a11 = this.m_XYZ[1][1];
        this.a12 = this.m_XYZ[1][2];
        this.a13 = this.m_XYZ[1][3];
        this.a20 = this.m_XYZ[2][0];
        this.a21 = this.m_XYZ[2][1];
        this.a22 = this.m_XYZ[2][2];
        this.a23 = this.m_XYZ[2][3];
        this.matInv4(this.m_XYZInv, this.m_XYZ);
        this.ai00 = this.m_XYZInv[0][0];
        this.ai01 = this.m_XYZInv[0][1];
        this.ai02 = this.m_XYZInv[0][2];
        this.ai03 = this.m_XYZInv[0][3];
        this.ai10 = this.m_XYZInv[1][0];
        this.ai11 = this.m_XYZInv[1][1];
        this.ai12 = this.m_XYZInv[1][2];
        this.ai13 = this.m_XYZInv[1][3];
        this.ai20 = this.m_XYZInv[2][0];
        this.ai21 = this.m_XYZInv[2][1];
        this.ai22 = this.m_XYZInv[2][2];
        this.ai23 = this.m_XYZInv[2][3];
    }

    private final void xyzPos() {
        this.X = this.a00 * this.x + this.a01 * this.y + this.a02 * this.z + this.a03;
        this.Y = this.a10 * this.x + this.a11 * this.y + this.a12 * this.z + this.a13;
        this.Z = this.a20 * this.x + this.a21 * this.y + this.a22 * this.z + this.a23;
        double sz = this.scale * this.maxDistance / (this.maxDistance + this.perspective * this.Z);
        this.X = sz * this.X + this.xs;
        this.Y = sz * this.Y + this.ys;
    }

    private final void xyzPos_noShift() {
        this.X = this.a00 * this.x + this.a01 * this.y + this.a02 * this.z + this.a03;
        this.Y = this.a10 * this.x + this.a11 * this.y + this.a12 * this.z + this.a13;
        this.Z = this.a20 * this.x + this.a21 * this.y + this.a22 * this.z + this.a23;
    }

    private final void invxyzPos() {
        double sz = (this.maxDistance + this.perspective * this.Z) / (this.scale * this.maxDistance);
        this.X = (this.X - this.xs) * sz;
        this.Y = (this.Y - this.ys) * sz;
        this.x = this.ai00 * this.X + this.ai01 * this.Y + this.ai02 * this.Z + this.ai03;
        this.y = this.ai10 * this.X + this.ai11 * this.Y + this.ai12 * this.Z + this.ai13;
        this.z = this.ai20 * this.X + this.ai21 * this.Y + this.ai22 * this.Z + this.ai23;
    }

    void matInv4(double[][] z, double[][] u) {
        int j;
        int i;
        int[] ii = new int[4];
        double[][] w = new double[4][4];
        int n = 4;
        this.matCopy4(w, u);
        this.matUnit4(z);
        for (i = 0; i < n; ++i) {
            ii[i] = this.matge4(w, i);
            this.matXr4(w, i, ii[i]);
            for (j = 0; j < n; ++j) {
                if (i == j) continue;
                double f = -w[i][j] / w[i][i];
                this.matAc4(w, j, j, f, i);
                this.matAc4(z, j, j, f, i);
            }
        }
        for (i = 0; i < n; ++i) {
            this.matMc4(z, 1.0 / w[i][i], i);
        }
        for (i = 0; i < n; ++i) {
            j = n - i - 1;
            this.matXc4(z, j, ii[j]);
        }
    }

    int matge4(double[][] p, int n) {
        int m = n;
        double g = p[n][n];
        g = g < 0.0 ? -g : g;
        for (int i = n; i < 4; ++i) {
            double h = p[i][n];
            double d = h = h < 0.0 ? -h : h;
            if (h < g) continue;
            g = h;
            m = i;
        }
        return m;
    }

    void matCopy4(double[][] z, double[][] x) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                z[i][j] = x[i][j];
            }
        }
    }

    void matUnit4(double[][] z) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                z[i][j] = 0.0;
            }
            z[i][i] = 1.0;
        }
    }

    void matXc4(double[][] z, int i, int j) {
        if (i == j) {
            return;
        }
        for (int k = 0; k < 4; ++k) {
            double t = z[k][i];
            z[k][i] = z[k][j];
            z[k][j] = t;
        }
    }

    void matXr4(double[][] z, int i, int j) {
        if (i == j) {
            return;
        }
        for (int k = 0; k < 4; ++k) {
            double t = z[i][k];
            z[i][k] = z[j][k];
            z[j][k] = t;
        }
    }

    void matXtc4(double[] p, double[][] z, int n) {
        for (int i = 0; i < 4; ++i) {
            p[i] = z[i][n];
        }
    }

    void matAc4(double[][] z, int i, int j, double f, int k) {
        for (int l = 0; l < 4; ++l) {
            z[l][i] = z[l][j] + f * z[l][k];
        }
    }

    void matMc4(double[][] z, double f, int i) {
        for (int j = 0; j < 4; ++j) {
            double[] dArray = z[j];
            int n = i;
            dArray[n] = dArray[n] * f;
        }
    }

    void matProd(double[][] z, double[][] u, double[][] v) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                z[i][j] = 0.0;
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = z[i];
                    int n = j;
                    dArray[n] = dArray[n] + u[i][k] * v[k][j];
                }
            }
        }
    }

    final void xyzPos(int[] xyz) {
        this.x = xyz[0];
        this.y = xyz[1];
        this.z = xyz[2];
        this.xyzPos();
    }

    final double getScalarProduct() {
        return this.cosZ * this.x + this.sinZ * this.y;
    }

    final void invxyzPosf(int[] XYZ) {
        this.X = XYZ[0];
        this.Y = XYZ[1];
        this.Z = XYZ[2];
        this.invxyzPos();
    }

    final void invxyzPosf(double[] XYZ) {
        this.X = XYZ[0];
        this.Y = XYZ[1];
        this.Z = XYZ[2];
        this.invxyzPos();
    }

    protected double getScale() {
        return this.scale;
    }

    protected double getZAspectRatio() {
        return this.zAspect;
    }

    protected int getZOrientation() {
        return this.zOrientation;
    }

    public void setPerspective(double perspective) {
        this.perspective = perspective;
    }

    public void setMaxDistance(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    public double getPerspective() {
        return this.perspective;
    }

    public double getMaxDistance() {
        return this.maxDistance;
    }
}

