/*
 * Decompiled with CFR 0.152.
 */
package fiji.color;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class Convert_Red_To_Magenta
implements PlugInFilter {
    protected ImagePlus image;
    public int numSlices;
    public int currentSlice;
    public ImageStack stack;

    public int setup(String arg, ImagePlus image) {
        if (image != null) {
            this.stack = image.getStack();
            this.numSlices = this.stack.getSize();
            this.currentSlice = image.getCurrentSlice();
        }
        this.image = image;
        return 16;
    }

    public void run(ImageProcessor ip) {
        if (this.stack.isVirtual()) {
            IJ.showMessage((String)"Virtual Stack", (String)"This plugin does not support virtual stacks.");
            return;
        }
        if (this.numSlices == 1) {
            Convert_Red_To_Magenta.process((ColorProcessor)ip);
            this.image.updateAndDraw();
        } else {
            GenericDialog gd = new GenericDialog("Apply to entire stack?");
            gd.addMessage("Replace red with magenta in all slices?\n \nNOTE: There is no undo for this operation.");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            for (int i = 0; i < this.numSlices; ++i) {
                IJ.showStatus((String)("Processing slice " + (i + 1) + " of " + this.numSlices));
                IJ.showProgress((double)(i / this.numSlices));
                ImageProcessor ip2 = this.stack.getProcessor(i + 1);
                Convert_Red_To_Magenta.process((ColorProcessor)ip2);
            }
            this.image.setSlice(this.currentSlice);
            this.image.updateAndDraw();
        }
    }

    public static void process(ColorProcessor ip) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        int[] pixels = (int[])ip.getPixels();
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                int value = pixels[i + j * w];
                int red = value >> 16 & 0xFF;
                int green = value >> 8 & 0xFF;
                int blue = value & 0xFF;
                pixels[i + j * w] = red << 16 | green << 8 | red;
            }
        }
    }
}

