/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.mesh.nio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.function.Function;
import net.imagej.mesh.Mesh;

public class BufferMesh
implements Mesh {
    private final Vertices vertices;
    private final Triangles triangles;

    public BufferMesh(int vertexMax, int triangleMax) {
        this(vertexMax, triangleMax, true);
    }

    public BufferMesh(int vertexMax, int triangleMax, boolean direct) {
        this(vertexMax, triangleMax, direct ? ByteBuffer::allocateDirect : ByteBuffer::allocate);
    }

    public BufferMesh(int vertexMax, int triangleMax, Function<Integer, ByteBuffer> creator) {
        this(BufferMesh.floats(BufferMesh.create(creator, vertexMax * 12)), BufferMesh.floats(BufferMesh.create(creator, vertexMax * 12)), BufferMesh.floats(BufferMesh.create(creator, vertexMax * 8)), BufferMesh.ints(BufferMesh.create(creator, triangleMax * 12)), BufferMesh.floats(BufferMesh.create(creator, triangleMax * 12)));
    }

    public BufferMesh(FloatBuffer verts, FloatBuffer vNormals, FloatBuffer texCoords, IntBuffer indices, FloatBuffer tNormals) {
        this.vertices = new Vertices(verts, vNormals, texCoords);
        this.triangles = new Triangles(indices, tNormals);
    }

    @Override
    public Vertices vertices() {
        return this.vertices;
    }

    @Override
    public Triangles triangles() {
        return this.triangles;
    }

    private static int safeIndex(long index, int span, int offset) {
        return BufferMesh.safeInt((long)span * index + (long)offset);
    }

    private static int safeInt(long value) {
        if (value > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("Value too large: " + value);
        }
        return (int)value;
    }

    private static ByteBuffer create(Function<Integer, ByteBuffer> creator, int length) {
        return creator.apply(length).order(ByteOrder.nativeOrder());
    }

    private static FloatBuffer floats(ByteBuffer bytes) {
        FloatBuffer floats = bytes.asFloatBuffer();
        floats.limit(0);
        return floats;
    }

    private static IntBuffer ints(ByteBuffer bytes) {
        IntBuffer ints = bytes.asIntBuffer();
        ints.limit(0);
        return ints;
    }

    private static void grow(Buffer buffer, int step) {
        buffer.limit(buffer.limit() + step);
    }

    public class Triangles
    implements net.imagej.mesh.Triangles {
        private static final int I_STRIDE = 3;
        private static final int N_STRIDE = 3;
        private IntBuffer indices;
        private FloatBuffer normals;

        public Triangles(IntBuffer indices, FloatBuffer normals) {
            this.indices = indices;
            this.normals = normals;
        }

        public IntBuffer indices() {
            return this.indices;
        }

        public FloatBuffer normals() {
            return this.normals;
        }

        @Override
        public Mesh mesh() {
            return BufferMesh.this;
        }

        @Override
        public long size() {
            return this.indices.limit() / 3;
        }

        @Override
        public long vertex0(long tIndex) {
            return this.indices.get(BufferMesh.safeIndex(tIndex, 3, 0));
        }

        @Override
        public long vertex1(long tIndex) {
            return this.indices.get(BufferMesh.safeIndex(tIndex, 3, 1));
        }

        @Override
        public long vertex2(long tIndex) {
            return this.indices.get(BufferMesh.safeIndex(tIndex, 3, 2));
        }

        @Override
        public float nxf(long tIndex) {
            return this.normals.get(BufferMesh.safeIndex(tIndex, 3, 0));
        }

        @Override
        public float nyf(long tIndex) {
            return this.normals.get(BufferMesh.safeIndex(tIndex, 3, 1));
        }

        @Override
        public float nzf(long tIndex) {
            return this.normals.get(BufferMesh.safeIndex(tIndex, 3, 2));
        }

        @Override
        public long addf(long v0, long v1, long v2, float nx, float ny, float nz) {
            long index = this.size();
            BufferMesh.grow(this.indices, 3);
            this.indices.put(BufferMesh.safeInt(v0));
            this.indices.put(BufferMesh.safeInt(v1));
            this.indices.put(BufferMesh.safeInt(v2));
            BufferMesh.grow(this.normals, 3);
            this.normals.put(nx);
            this.normals.put(ny);
            this.normals.put(nz);
            return index;
        }
    }

    public class Vertices
    implements net.imagej.mesh.Vertices {
        private static final int V_STRIDE = 3;
        private static final int N_STRIDE = 3;
        private static final int T_STRIDE = 2;
        private FloatBuffer verts;
        private FloatBuffer normals;
        private FloatBuffer texCoords;

        public Vertices(FloatBuffer verts, FloatBuffer normals, FloatBuffer texCoords) {
            this.verts = verts;
            this.normals = normals;
            this.texCoords = texCoords;
        }

        public FloatBuffer verts() {
            return this.verts;
        }

        public FloatBuffer normals() {
            return this.normals;
        }

        public FloatBuffer texCoords() {
            return this.texCoords;
        }

        @Override
        public Mesh mesh() {
            return BufferMesh.this;
        }

        @Override
        public long size() {
            return this.verts.limit() / 3;
        }

        @Override
        public float xf(long vIndex) {
            return this.verts.get(BufferMesh.safeIndex(vIndex, 3, 0));
        }

        @Override
        public float yf(long vIndex) {
            return this.verts.get(BufferMesh.safeIndex(vIndex, 3, 1));
        }

        @Override
        public float zf(long vIndex) {
            return this.verts.get(BufferMesh.safeIndex(vIndex, 3, 2));
        }

        @Override
        public float nxf(long vIndex) {
            return this.normals.get(BufferMesh.safeIndex(vIndex, 3, 0));
        }

        @Override
        public float nyf(long vIndex) {
            return this.normals.get(BufferMesh.safeIndex(vIndex, 3, 1));
        }

        @Override
        public float nzf(long vIndex) {
            return this.normals.get(BufferMesh.safeIndex(vIndex, 3, 2));
        }

        @Override
        public float uf(long vIndex) {
            return this.texCoords.get(BufferMesh.safeIndex(vIndex, 2, 0));
        }

        @Override
        public float vf(long vIndex) {
            return this.texCoords.get(BufferMesh.safeIndex(vIndex, 2, 1));
        }

        @Override
        public long addf(float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            long index = this.size();
            BufferMesh.grow(this.verts, 3);
            this.verts.put(x);
            this.verts.put(y);
            this.verts.put(z);
            BufferMesh.grow(this.normals, 3);
            this.normals.put(nx);
            this.normals.put(ny);
            this.normals.put(nz);
            BufferMesh.grow(this.texCoords, 2);
            this.texCoords.put(u);
            this.texCoords.put(v);
            return index;
        }

        @Override
        public void setf(long vIndex, float x, float y, float z, float nx, float ny, float nz, float u, float v) {
            this.verts.put(BufferMesh.safeIndex(vIndex, 3, 0), x);
            this.verts.put(BufferMesh.safeIndex(vIndex, 3, 1), y);
            this.verts.put(BufferMesh.safeIndex(vIndex, 3, 2), z);
            this.normals.put(BufferMesh.safeIndex(vIndex, 3, 0), nx);
            this.normals.put(BufferMesh.safeIndex(vIndex, 3, 1), ny);
            this.normals.put(BufferMesh.safeIndex(vIndex, 3, 2), nz);
            this.texCoords.put(BufferMesh.safeIndex(vIndex, 2, 0), u);
            this.texCoords.put(BufferMesh.safeIndex(vIndex, 2, 1), v);
        }

        @Override
        public void setPositionf(long vIndex, float x, float y, float z) {
            this.verts.put(BufferMesh.safeIndex(vIndex, 3, 0), x);
            this.verts.put(BufferMesh.safeIndex(vIndex, 3, 1), y);
            this.verts.put(BufferMesh.safeIndex(vIndex, 3, 2), z);
        }

        @Override
        public void setNormalf(long vIndex, float nx, float ny, float nz) {
            this.normals.put(BufferMesh.safeIndex(vIndex, 3, 0), nx);
            this.normals.put(BufferMesh.safeIndex(vIndex, 3, 1), ny);
            this.normals.put(BufferMesh.safeIndex(vIndex, 3, 2), nz);
        }

        @Override
        public void setTexturef(long vIndex, float u, float v) {
            this.texCoords.put(BufferMesh.safeIndex(vIndex, 2, 0), u);
            this.texCoords.put(BufferMesh.safeIndex(vIndex, 2, 1), v);
        }
    }
}

