/*
 * Decompiled with CFR 0.152.
 */
package adt;

import adt.Points;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;

public class Connectivity2D {
    HashSet<Points> islands = new HashSet();
    Point topLeft;
    Point bottomRight;

    public void addPoint(int x, int y) {
        this.addPoint(new Point(x, y));
    }

    public void addLowerRightPoint(Point p) {
        if (this.topLeft == null) {
            this.topLeft = new Point(p.x, p.y);
        } else {
            if (p.x < this.topLeft.x) {
                this.topLeft.x = p.x;
            }
            if (p.y < this.topLeft.y) {
                this.topLeft.y = p.y;
            }
        }
        if (this.bottomRight == null) {
            this.bottomRight = new Point(p.x, p.y);
        }
        this.addPoint(p, Connectivity2D.getUpperLeftNeigbours(p));
    }

    public void addPoint(Point p) {
        if (this.topLeft == null) {
            this.topLeft = new Point(p.x, p.y);
        } else {
            if (p.x < this.topLeft.x) {
                this.topLeft.x = p.x;
            }
            if (p.y < this.topLeft.y) {
                this.topLeft.y = p.y;
            }
        }
        if (this.bottomRight == null) {
            this.bottomRight = new Point(p.x, p.y);
        } else {
            if (p.x > this.bottomRight.x) {
                this.bottomRight.x = p.x;
            }
            if (p.y > this.bottomRight.y) {
                this.bottomRight.y = p.y;
            }
        }
        this.addPoint(p, Connectivity2D.getNeighbours(p));
    }

    private void addPoint(Point p, Set<Point> neigbours) {
        Points masterIsland = null;
        HashSet<Points> slaveIslands = new HashSet<Points>();
        for (Point neighbour : neigbours) {
            for (Points island : this.islands) {
                if (!island.contains(neighbour)) continue;
                island.addPoint(p);
                if (masterIsland == null) {
                    masterIsland = island;
                    continue;
                }
                if (island == masterIsland) continue;
                slaveIslands.add(island);
            }
        }
        if (masterIsland == null) {
            Points island = new Points();
            island.addPoint(p);
            this.islands.add(island);
        } else {
            for (Points slave : slaveIslands) {
                masterIsland.addPoints(slave);
                this.islands.remove(slave);
            }
        }
    }

    public Iterable<Points> getIslands() {
        return this.islands;
    }

    public static Set<Point> getNeighbours(Point p) {
        HashSet<Point> neighbours = new HashSet<Point>();
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                if (x == 0 && y == 0) continue;
                neighbours.add(new Point(p.x + x, p.y + y));
            }
        }
        return neighbours;
    }

    public static Set<Point> getUpperLeftNeigbours(Point p) {
        HashSet<Point> neighbours = new HashSet<Point>();
        neighbours.add(new Point(p.x - 1, p.y));
        neighbours.add(new Point(p.x, p.y - 1));
        return neighbours;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int islandIndex = 0;
        for (Points island : this.islands) {
            buf.append("\n").append("island: ").append(islandIndex++);
            for (Point p : island.getPoints()) {
                buf.append(p).append("\t");
            }
        }
        return buf.toString();
    }
}

