/*
 * Decompiled with CFR 0.152.
 */
package delaunay;

import delaunay.Pnt;
import delaunay.Simplex;
import delaunay.Triangulation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class DelaunayTriangulation
extends Triangulation {
    private Simplex mostRecent = null;
    public boolean debug = false;

    public DelaunayTriangulation(Simplex triangle) {
        super(triangle);
        this.mostRecent = triangle;
    }

    public Simplex locate(Pnt point) {
        Simplex triangle = this.mostRecent;
        if (!this.contains(triangle)) {
            triangle = null;
        }
        HashSet<Simplex> visited = new HashSet<Simplex>();
        while (triangle != null) {
            if (visited.contains(triangle)) {
                System.out.println("Warning: Caught in a locate loop");
                break;
            }
            visited.add(triangle);
            Pnt corner = point.isOutside(triangle.toArray(new Pnt[0]));
            if (corner == null) {
                return triangle;
            }
            triangle = this.neighborOpposite(corner, triangle);
        }
        System.out.println("Warning: Checking all triangles for " + point);
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Simplex tri = (Simplex)it.next();
            if (point.isOutside(tri.toArray(new Pnt[0])) != null) continue;
            return tri;
        }
        System.out.println("Warning: No triangle holds " + point);
        return null;
    }

    public Set delaunayPlace(Pnt site) {
        Simplex triangle;
        HashSet<Simplex> newTriangles = new HashSet<Simplex>();
        HashSet<Simplex> oldTriangles = new HashSet<Simplex>();
        HashSet<Simplex> doneSet = new HashSet<Simplex>();
        LinkedList<Simplex> waitingQ = new LinkedList<Simplex>();
        if (this.debug) {
            System.out.println("Locate");
        }
        if ((triangle = this.locate(site)) == null || triangle.contains(site)) {
            return newTriangles;
        }
        if (this.debug) {
            System.out.println("Cavity");
        }
        waitingQ.add(triangle);
        while (!waitingQ.isEmpty()) {
            triangle = (Simplex)waitingQ.removeFirst();
            if (site.vsCircumcircle(triangle.toArray(new Pnt[0])) == 1) continue;
            oldTriangles.add(triangle);
            for (Simplex tri : this.neighbors(triangle)) {
                if (doneSet.contains(tri)) continue;
                doneSet.add(tri);
                waitingQ.add(tri);
            }
        }
        if (this.debug) {
            System.out.println("Create");
        }
        for (Set facet : Simplex.boundary(oldTriangles)) {
            facet.add(site);
            newTriangles.add(new Simplex(facet));
        }
        if (this.debug) {
            System.out.println("Update");
        }
        this.update(oldTriangles, newTriangles);
        if (!newTriangles.isEmpty()) {
            this.mostRecent = (Simplex)newTriangles.iterator().next();
        }
        return newTriangles;
    }

    public static void main(String[] args) {
        Simplex tri = new Simplex(new Pnt[]{new Pnt(-10.0, 10.0), new Pnt(10.0, 10.0), new Pnt(0.0, -10.0)});
        System.out.println("Triangle created: " + tri);
        DelaunayTriangulation dt = new DelaunayTriangulation(tri);
        System.out.println("DelaunayTriangulation created: " + dt);
        dt.delaunayPlace(new Pnt(0.0, 0.0));
        dt.delaunayPlace(new Pnt(1.0, 0.0));
        dt.delaunayPlace(new Pnt(0.0, 1.0));
        System.out.println("After adding 3 points, the DelaunayTriangulation is a " + dt);
        dt.printStuff();
    }
}

