/*
 * Decompiled with CFR 0.152.
 */
package math3d;

import math3d.Line;
import math3d.Plane;
import math3d.Point3d;

public class Triangle {
    public Point3d a;
    public Point3d b;
    public Point3d c;
    public Point3d center;
    public double cRadius2;

    public Triangle() {
    }

    public Triangle(Point3d a, Point3d b, Point3d c) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.calculateCircumcenter2();
    }

    public double calculateCircumcenter2() {
        Point3d x = this.b.minus(this.a);
        Point3d y = this.c.minus(this.a);
        double xx = x.scalar(x);
        double xy = x.scalar(y);
        double yy = y.scalar(y);
        double det = xx * yy - xy * xy;
        double alpha = 0.5 * (yy * xx - xy * yy) / det;
        double beta = 0.5 * (-xy * xx + xx * yy) / det;
        this.center = new Point3d(this.a.x + alpha * x.x + beta * y.x, this.a.y + alpha * x.y + beta * y.y, this.a.z + alpha * x.z + beta * y.z);
        this.cRadius2 = this.center.distance2(this.a);
        return this.cRadius2;
    }

    public Point3d intersection(Line l) {
        Plane p = new Plane(this.a, this.b, this.c, this.b);
        Point3d intersection = p.intersection(l);
        if (intersection == null) {
            return null;
        }
        Point3d tmp = p.getNormal().plus(this.a);
        Plane sa = new Plane(this.a, this.b, tmp, this.center);
        tmp = p.getNormal().plus(this.b);
        Plane sb = new Plane(this.b, this.c, tmp, this.center);
        tmp = p.getNormal().plus(this.c);
        Plane sc = new Plane(this.c, this.a, tmp, this.center);
        if (sa.isInside(intersection) && sb.isInside(intersection) && sc.isInside(intersection)) {
            return intersection;
        }
        return null;
    }

    public static void test() {
        Triangle t = new Triangle();
        t.a = Point3d.random();
        t.a.z = 0.0;
        t.b = Point3d.random();
        t.b.z = 0.0;
        t.c = Point3d.random();
        t.c.z = 0.0;
        t.calculateCircumcenter2();
        Point3d c = t.center;
        double radius = Math.sqrt(t.cRadius2);
        System.out.println("%!PS-1.0\n" + t.a + " pop moveto\n" + t.b + " pop lineto\n" + t.c + " pop lineto closepath stroke\n" + t.a + " pop moveto\n" + c + " pop lineto stroke\n" + c + " pop " + radius + " 0 350 arc stroke\nshowpage\n");
    }

    public String toString() {
        return "{" + this.a + "; " + this.b + "; " + this.c + "} ";
    }
}

