/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.StackWindow;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import stacks.PaneOwner;
import stacks.ThreePanesCanvas;

public class ThreePaneContainer
extends StackWindow
implements PaneOwner,
ActionListener {
    protected ThreePanesCanvas original_xy_canvas;
    protected ImagePlus xy;
    protected ImagePlus xz;
    protected ImagePlus zy;
    protected ThreePanesCanvas xy_canvas;
    protected ThreePanesCanvas xz_canvas;
    protected ThreePanesCanvas zy_canvas;

    public ThreePanesCanvas createCanvas(ImagePlus imagePlus, int plane) {
        return new ThreePanesCanvas(imagePlus, this, plane);
    }

    public ThreePaneContainer(ImagePlus imagePlus) {
        super(imagePlus, (ImageCanvas)new ThreePanesCanvas(imagePlus, 0));
        ByteProcessor bp;
        byte[] sliceBytes;
        int depth;
        this.original_xy_canvas = (ThreePanesCanvas)imagePlus.getWindow().getCanvas();
        this.original_xy_canvas.setPaneOwner(this);
        System.out.println("Creating ThreePaneContainer");
        this.xy = imagePlus;
        int type = this.xy.getType();
        if (type != 0) {
            IJ.error((String)"This doesn't currently work on 8 bit stacks.");
            return;
        }
        this.remove((Component)this.getCanvas());
        this.remove(this.sliceSelector);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int width = this.xy.getWidth();
        int height = this.xy.getHeight();
        int zy_width = depth = this.xy.getStackSize();
        int zy_height = height;
        ImageStack zy_stack = new ImageStack(zy_width, zy_height);
        int xz_width = width;
        int xz_height = depth;
        ImageStack xz_stack = new ImageStack(xz_width, xz_height);
        byte[][] slices_data = new byte[depth][];
        ImageStack xy_stack = this.xy.getStack();
        for (int z = 0; z < depth; ++z) {
            slices_data[z] = (byte[])xy_stack.getPixels(z + 1);
        }
        IJ.showStatus((String)"Generating XZ planes...");
        IJ.showProgress((double)0.0);
        for (int x_in_original = 0; x_in_original < width; ++x_in_original) {
            sliceBytes = new byte[zy_width * zy_height];
            for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                for (int y_in_original = 0; y_in_original < height; ++y_in_original) {
                    int x_in_left = z_in_original;
                    int y_in_left = y_in_original;
                    sliceBytes[y_in_left * zy_width + x_in_left] = slices_data[z_in_original][y_in_original * width + x_in_original];
                }
            }
            bp = new ByteProcessor(zy_width, zy_height);
            bp.setPixels((Object)sliceBytes);
            zy_stack.addSlice(null, (ImageProcessor)bp);
            IJ.showProgress((double)((double)x_in_original / (double)width));
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"Generating ZY planes...");
        IJ.showProgress((double)0.0);
        this.zy = new ImagePlus("ZY planes of " + this.xy.getShortTitle(), zy_stack);
        for (int y_in_original = 0; y_in_original < height; ++y_in_original) {
            sliceBytes = new byte[xz_width * xz_height];
            for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                int y_in_top = z_in_original;
                System.arraycopy(slices_data[z_in_original], y_in_original * width, sliceBytes, y_in_top * xz_width, width);
            }
            bp = new ByteProcessor(xz_width, xz_height);
            bp.setPixels((Object)sliceBytes);
            xz_stack.addSlice(null, (ImageProcessor)bp);
            IJ.showProgress((double)((double)y_in_original / (double)width));
        }
        this.xz = new ImagePlus("XZ planes of " + this.xy.getShortTitle(), xz_stack);
        IJ.showProgress((double)1.0);
        System.gc();
        this.xy_canvas = this.original_xy_canvas;
        this.xz_canvas = this.createCanvas(this.xz, 1);
        this.zy_canvas = this.createCanvas(this.zy, 2);
        Container xy_container = new Container();
        Container xz_container = new Container();
        Container zy_container = new Container();
        xy_container.setLayout((LayoutManager)new ImageLayout((ImageCanvas)this.xy_canvas));
        xz_container.setLayout((LayoutManager)new ImageLayout((ImageCanvas)this.xz_canvas));
        zy_container.setLayout((LayoutManager)new ImageLayout((ImageCanvas)this.zy_canvas));
        xy_container.add((Component)((Object)this.xy_canvas));
        xz_container.add((Component)((Object)this.xz_canvas));
        zy_container.add((Component)((Object)this.zy_canvas));
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(3, 3, 3, 3);
        this.add(xz_container, c);
        c.gridx = 0;
        c.gridy = 1;
        this.add(zy_container, c);
        c.gridx = 1;
        c.gridy = 1;
        this.add(xy_container, c);
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        this.add(this.sliceSelector, c);
        this.pack();
        this.show();
        this.repaintAllPanes();
    }

    public void findPointInStack(int x_in_pane, int y_in_pane, int plane, int[] point) {
        switch (plane) {
            case 0: {
                point[0] = x_in_pane;
                point[1] = y_in_pane;
                point[2] = this.xy.getCurrentSlice() - 1;
                break;
            }
            case 1: {
                point[0] = x_in_pane;
                point[1] = this.xz.getCurrentSlice() - 1;
                point[2] = y_in_pane;
                break;
            }
            case 2: {
                point[0] = this.zy.getCurrentSlice() - 1;
                point[1] = y_in_pane;
                point[2] = x_in_pane;
            }
        }
    }

    @Override
    public void mouseMovedTo(int off_screen_x, int off_screen_y, int in_plane, boolean shift_down) {
        int[] point = new int[3];
        this.findPointInStack(off_screen_x, off_screen_y, in_plane, point);
        this.xy_canvas.setCrosshairs(point[0], point[1], point[2], true);
        this.xz_canvas.setCrosshairs(point[0], point[1], point[2], true);
        this.zy_canvas.setCrosshairs(point[0], point[1], point[2], true);
        if (shift_down) {
            this.setSlicesAllPanes(point[0], point[1], point[2]);
        }
    }

    @Override
    public void zoom(boolean in, int off_screen_x, int off_screen_y, int in_plane) {
        int[] point = new int[3];
        this.findPointInStack(off_screen_x, off_screen_y, in_plane, point);
        this.xy_canvas.realZoom(in, point[0], point[1]);
        this.xz_canvas.realZoom(in, point[0], point[2]);
        this.zy_canvas.realZoom(in, point[2], point[1]);
    }

    public void setSlicesAllPanes(int new_x, int new_y, int new_z) {
        this.xy.setSlice(new_z + 1);
        this.xy.updateImage();
        this.xz.setSlice(new_y + 1);
        this.xz.updateImage();
        this.zy.setSlice(new_x + 1);
        this.zy.updateImage();
        this.repaintAllPanes();
    }

    public void repaintAllPanes() {
        this.xy_canvas.repaint();
        this.xz_canvas.repaint();
        this.zy_canvas.repaint();
    }

    public void closeAndReset() {
        this.zy.close();
        this.xz.close();
        new StackWindow(this.xy, (ImageCanvas)this.original_xy_canvas);
    }
}

