/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.ImageCanvas;
import ij.gui.StackWindow;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import stacks.PaneOwner;
import stacks.ThreePanesCanvas;

public class ThreePanes
implements PaneOwner {
    public static final int XY_PLANE = 0;
    public static final int XZ_PLANE = 1;
    public static final int ZY_PLANE = 2;
    protected ImagePlus xy;
    protected ImagePlus xz;
    protected ImagePlus zy;
    protected ThreePanesCanvas xy_canvas;
    protected ThreePanesCanvas xz_canvas;
    protected ThreePanesCanvas zy_canvas;
    protected ImageCanvas original_xy_canvas;
    protected StackWindow xy_window;
    protected StackWindow xz_window;
    protected StackWindow zy_window;
    protected boolean single_pane = false;
    int type;
    int bytesPerPixel;

    public void findPointInStack(int x_in_pane, int y_in_pane, int plane, int[] point) {
        switch (plane) {
            case 0: {
                point[0] = x_in_pane;
                point[1] = y_in_pane;
                point[2] = this.xy.getCurrentSlice() - 1;
                break;
            }
            case 1: {
                point[0] = x_in_pane;
                point[1] = this.xz.getCurrentSlice() - 1;
                point[2] = y_in_pane;
                break;
            }
            case 2: {
                point[0] = this.zy.getCurrentSlice() - 1;
                point[1] = y_in_pane;
                point[2] = x_in_pane;
            }
        }
    }

    public void findPointInStackPrecise(double x_in_pane, double y_in_pane, int plane, double[] point) {
        switch (plane) {
            case 0: {
                point[0] = x_in_pane;
                point[1] = y_in_pane;
                point[2] = this.xy.getCurrentSlice() - 1;
                break;
            }
            case 1: {
                point[0] = x_in_pane;
                point[1] = this.xz.getCurrentSlice() - 1;
                point[2] = y_in_pane;
                break;
            }
            case 2: {
                point[0] = this.zy.getCurrentSlice() - 1;
                point[1] = y_in_pane;
                point[2] = x_in_pane;
            }
        }
    }

    public ThreePanesCanvas createCanvas(ImagePlus imagePlus, int plane) {
        return new ThreePanesCanvas(imagePlus, this, plane);
    }

    @Override
    public void mouseMovedTo(int off_screen_x, int off_screen_y, int in_plane, boolean shift_down) {
        int[] point = new int[3];
        this.findPointInStack(off_screen_x, off_screen_y, in_plane, point);
        this.xy_canvas.setCrosshairs(point[0], point[1], point[2], true);
        if (!this.single_pane) {
            this.xz_canvas.setCrosshairs(point[0], point[1], point[2], true);
            this.zy_canvas.setCrosshairs(point[0], point[1], point[2], true);
        }
        if (shift_down) {
            this.setSlicesAllPanes(point[0], point[1], point[2]);
        }
    }

    @Override
    public void zoom(boolean in, int off_screen_x, int off_screen_y, int in_plane) {
        int[] point = new int[3];
        this.findPointInStack(off_screen_x, off_screen_y, in_plane, point);
        this.xy_canvas.realZoom(in, point[0], point[1]);
        if (!this.single_pane) {
            this.xz_canvas.realZoom(in, point[0], point[2]);
            this.zy_canvas.realZoom(in, point[2], point[1]);
        }
    }

    public void setSlicesAllPanes(int new_x, int new_y, int new_z) {
        this.xy.setSlice(new_z + 1);
        if (!this.single_pane) {
            this.xz.setSlice(new_y + 1);
            this.zy.setSlice(new_x + 1);
        }
    }

    public void repaintAllPanes() {
        this.xy_canvas.repaint();
        if (!this.single_pane) {
            this.xz_canvas.repaint();
            this.zy_canvas.repaint();
        }
    }

    public void closeAndReset() {
        if (!this.single_pane) {
            this.zy.close();
            this.xz.close();
        }
        if (this.original_xy_canvas != null && this.xy != null && this.xy.getImage() != null) {
            this.xy_window = new StackWindow(this.xy, this.original_xy_canvas);
        }
    }

    public void checkMemory(ImagePlus imagePlus, int memoryMultipleNeeded) {
        long sizeOfImagePlus = imagePlus.getWidth() * imagePlus.getHeight() * imagePlus.getStackSize() * (imagePlus.getBitDepth() / 8);
        long bytesNeededEstimate = (long)(memoryMultipleNeeded + 1) * sizeOfImagePlus;
        System.gc();
        long maxMemory = Runtime.getRuntime().maxMemory();
        if (bytesNeededEstimate > maxMemory) {
            IJ.error((String)"Warning", (String)("It looks as if the amount of memory required for the three pane view (" + bytesNeededEstimate / 0x100000L + "MiB) exceeds the maximum memory available (" + maxMemory / 0x100000L + "MiB)"));
        }
    }

    public static String imageTypeToString(int type) {
        String result;
        switch (type) {
            case 0: {
                result = "GRAY8 (8-bit grayscale (unsigned))";
                break;
            }
            case 1: {
                result = "GRAY16 (16-bit grayscale (unsigned))";
                break;
            }
            case 2: {
                result = "GRAY32 (32-bit floating-point grayscale)";
                break;
            }
            case 3: {
                result = "COLOR_256 (8-bit indexed color)";
                break;
            }
            case 4: {
                result = "COLOR_RGB (32-bit RGB color)";
                break;
            }
            default: {
                result = "Unknown (value: " + type + ")";
            }
        }
        return result;
    }

    public void initialize(ImagePlus imagePlus) {
        this.xy = imagePlus;
        this.type = this.xy.getType();
        this.bytesPerPixel = this.xy.getBitDepth() / 8;
        this.original_xy_canvas = imagePlus.getWindow().getCanvas();
        int width = this.xy.getWidth();
        int height = this.xy.getHeight();
        int depth = this.xy.getStackSize();
        ImageStack xy_stack = this.xy.getStack();
        ColorModel cm = null;
        if (this.type == 3) {
            cm = xy_stack.getColorModel();
        }
        if (!this.single_pane) {
            FloatProcessor fp;
            float[] sliceFloats;
            ColorProcessor cp;
            int[] sliceInts;
            ShortProcessor sp;
            short[] sliceShorts;
            ByteProcessor bp;
            byte[] sliceBytes;
            int zy_width = depth;
            int zy_height = height;
            ImageStack zy_stack = new ImageStack(zy_width, zy_height);
            int xz_width = width;
            int xz_height = depth;
            ImageStack xz_stack = new ImageStack(xz_width, xz_height);
            byte[][] slices_data_b = new byte[depth][];
            int[][] slices_data_i = new int[depth][];
            float[][] slices_data_f = new float[depth][];
            short[][] slices_data_s = new short[depth][];
            block18: for (int z = 0; z < depth; ++z) {
                switch (this.type) {
                    case 0: 
                    case 3: {
                        slices_data_b[z] = (byte[])xy_stack.getPixels(z + 1);
                        continue block18;
                    }
                    case 1: {
                        slices_data_s[z] = (short[])xy_stack.getPixels(z + 1);
                        continue block18;
                    }
                    case 4: {
                        slices_data_i[z] = (int[])xy_stack.getPixels(z + 1);
                        continue block18;
                    }
                    case 2: {
                        slices_data_f[z] = (float[])xy_stack.getPixels(z + 1);
                    }
                }
            }
            IJ.showStatus((String)"Generating XZ planes...");
            IJ.showProgress((double)0.0);
            switch (this.type) {
                case 0: 
                case 3: {
                    int y_in_left;
                    int x_in_left;
                    int y_in_original;
                    int x_in_original;
                    for (x_in_original = 0; x_in_original < width; ++x_in_original) {
                        sliceBytes = new byte[zy_width * zy_height];
                        for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                            for (y_in_original = 0; y_in_original < height; ++y_in_original) {
                                x_in_left = z_in_original;
                                y_in_left = y_in_original;
                                sliceBytes[y_in_left * zy_width + x_in_left] = slices_data_b[z_in_original][y_in_original * width + x_in_original];
                            }
                        }
                        bp = new ByteProcessor(zy_width, zy_height);
                        bp.setPixels((Object)sliceBytes);
                        zy_stack.addSlice(null, (ImageProcessor)bp);
                        IJ.showProgress((double)((double)x_in_original / (double)width));
                    }
                    break;
                }
                case 1: {
                    int y_in_left;
                    int x_in_left;
                    int y_in_original;
                    int x_in_original;
                    for (x_in_original = 0; x_in_original < width; ++x_in_original) {
                        sliceShorts = new short[zy_width * zy_height];
                        for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                            for (y_in_original = 0; y_in_original < height; ++y_in_original) {
                                x_in_left = z_in_original;
                                y_in_left = y_in_original;
                                sliceShorts[y_in_left * zy_width + x_in_left] = slices_data_s[z_in_original][y_in_original * width + x_in_original];
                            }
                        }
                        sp = new ShortProcessor(zy_width, zy_height);
                        sp.setPixels((Object)sliceShorts);
                        zy_stack.addSlice(null, (ImageProcessor)sp);
                        IJ.showProgress((double)((double)x_in_original / (double)width));
                    }
                    break;
                }
                case 4: {
                    int y_in_left;
                    int x_in_left;
                    int y_in_original;
                    int x_in_original;
                    for (x_in_original = 0; x_in_original < width; ++x_in_original) {
                        sliceInts = new int[zy_width * zy_height];
                        for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                            for (y_in_original = 0; y_in_original < height; ++y_in_original) {
                                x_in_left = z_in_original;
                                y_in_left = y_in_original;
                                sliceInts[y_in_left * zy_width + x_in_left] = slices_data_i[z_in_original][y_in_original * width + x_in_original];
                            }
                        }
                        cp = new ColorProcessor(zy_width, zy_height);
                        cp.setPixels((Object)sliceInts);
                        zy_stack.addSlice(null, (ImageProcessor)cp);
                        IJ.showProgress((double)((double)x_in_original / (double)width));
                    }
                    break;
                }
                case 2: {
                    int y_in_left;
                    int x_in_left;
                    int y_in_original;
                    int x_in_original;
                    for (x_in_original = 0; x_in_original < width; ++x_in_original) {
                        sliceFloats = new float[zy_width * zy_height];
                        for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                            for (y_in_original = 0; y_in_original < height; ++y_in_original) {
                                x_in_left = z_in_original;
                                y_in_left = y_in_original;
                                sliceFloats[y_in_left * zy_width + x_in_left] = slices_data_f[z_in_original][y_in_original * width + x_in_original];
                            }
                        }
                        fp = new FloatProcessor(zy_width, zy_height);
                        fp.setPixels((Object)sliceFloats);
                        zy_stack.addSlice(null, (ImageProcessor)fp);
                        IJ.showProgress((double)((double)x_in_original / (double)width));
                    }
                    break;
                }
            }
            if (this.type == 3 && cm != null) {
                zy_stack.setColorModel(cm);
            }
            IJ.showProgress((double)1.0);
            IJ.showStatus((String)"Generating ZY planes...");
            IJ.showProgress((double)0.0);
            this.zy = new ImagePlus("ZY planes of " + this.xy.getShortTitle(), zy_stack);
            switch (this.type) {
                case 0: 
                case 3: {
                    int y_in_top;
                    int y_in_original;
                    for (y_in_original = 0; y_in_original < height; ++y_in_original) {
                        sliceBytes = new byte[xz_width * xz_height];
                        for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                            y_in_top = z_in_original;
                            System.arraycopy(slices_data_b[z_in_original], y_in_original * width, sliceBytes, y_in_top * xz_width, width);
                        }
                        bp = new ByteProcessor(xz_width, xz_height);
                        bp.setPixels((Object)sliceBytes);
                        xz_stack.addSlice(null, (ImageProcessor)bp);
                        IJ.showProgress((double)((double)y_in_original / (double)width));
                    }
                    break;
                }
                case 1: {
                    int y_in_top;
                    int y_in_original;
                    for (y_in_original = 0; y_in_original < height; ++y_in_original) {
                        sliceShorts = new short[xz_width * xz_height];
                        for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                            y_in_top = z_in_original;
                            System.arraycopy(slices_data_s[z_in_original], y_in_original * width, sliceShorts, y_in_top * xz_width, width);
                        }
                        sp = new ShortProcessor(xz_width, xz_height);
                        sp.setPixels((Object)sliceShorts);
                        xz_stack.addSlice(null, (ImageProcessor)sp);
                        IJ.showProgress((double)((double)y_in_original / (double)width));
                    }
                    break;
                }
                case 4: {
                    int y_in_top;
                    int y_in_original;
                    for (y_in_original = 0; y_in_original < height; ++y_in_original) {
                        sliceInts = new int[xz_width * xz_height];
                        for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                            y_in_top = z_in_original;
                            System.arraycopy(slices_data_i[z_in_original], y_in_original * width, sliceInts, y_in_top * xz_width, width);
                        }
                        cp = new ColorProcessor(xz_width, xz_height);
                        cp.setPixels((Object)sliceInts);
                        xz_stack.addSlice(null, (ImageProcessor)cp);
                        IJ.showProgress((double)((double)y_in_original / (double)width));
                    }
                    break;
                }
                case 2: {
                    int y_in_top;
                    int y_in_original;
                    for (y_in_original = 0; y_in_original < height; ++y_in_original) {
                        sliceFloats = new float[xz_width * xz_height];
                        for (int z_in_original = 0; z_in_original < depth; ++z_in_original) {
                            y_in_top = z_in_original;
                            System.arraycopy(slices_data_f[z_in_original], y_in_original * width, sliceFloats, y_in_top * xz_width, width);
                        }
                        fp = new FloatProcessor(xz_width, xz_height);
                        fp.setPixels((Object)sliceFloats);
                        xz_stack.addSlice(null, (ImageProcessor)fp);
                        IJ.showProgress((double)((double)y_in_original / (double)width));
                    }
                    break;
                }
            }
            this.xz = new ImagePlus("XZ planes of " + this.xy.getShortTitle(), xz_stack);
            if (this.type == 3 && cm != null) {
                xz_stack.setColorModel(cm);
            }
            IJ.showProgress((double)1.0);
        }
        System.gc();
        this.xy_canvas = this.createCanvas(this.xy, 0);
        if (!this.single_pane) {
            this.xz_canvas = this.createCanvas(this.xz, 1);
            this.zy_canvas = this.createCanvas(this.zy, 2);
        }
        this.xy_window = new StackWindow(this.xy, (ImageCanvas)this.xy_canvas);
        if (!this.single_pane) {
            this.xz_window = new StackWindow(this.xz, (ImageCanvas)this.xz_canvas);
            this.zy_window = new StackWindow(this.zy, (ImageCanvas)this.zy_canvas);
        }
    }

    public int[][] findAllPointsAlongLine(int x_in_pane, int y_in_pane, int plane) {
        int n = -1;
        switch (plane) {
            case 0: {
                n = this.xy.getStackSize();
                break;
            }
            case 1: {
                n = this.xz.getStackSize();
                break;
            }
            case 2: {
                n = this.zy.getStackSize();
            }
        }
        int[][] result = new int[n][3];
        switch (plane) {
            case 0: {
                for (int z = 0; z < n; ++z) {
                    result[z] = new int[]{x_in_pane, y_in_pane, z};
                }
                break;
            }
            case 1: {
                for (int y = 0; y < n; ++y) {
                    result[y] = new int[]{x_in_pane, y, y_in_pane};
                }
                break;
            }
            case 2: {
                for (int x = 0; x < n; ++x) {
                    result[x] = new int[]{x, y_in_pane, x_in_pane};
                }
                break;
            }
        }
        return result;
    }
}

