/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;

public class RGBToLuminance {
    public static ImagePlus convertToLuminance(ImagePlus colourImage) {
        if (colourImage.getType() != 4) {
            return null;
        }
        int depth = colourImage.getStackSize();
        int width = colourImage.getWidth();
        int height = colourImage.getHeight();
        Calibration calibration = colourImage.getCalibration();
        ImageStack stack = colourImage.getStack();
        ImageStack luminanceStack = new ImageStack(width, height);
        byte[][] luminancePixels = new byte[depth][];
        for (int z = 0; z < depth; ++z) {
            int[] intPixels = (int[])stack.getPixels(z + 1);
            luminancePixels[z] = new byte[width * height];
            for (int iv : intPixels) {
                int b = iv & 0xFF;
                int g = (iv & 0xFF00) >> 8;
                int r = (iv & 0xFF0000) >> 16;
                int luminance = (int)Math.round(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b);
                luminancePixels[z][i] = (byte)luminance;
            }
            ByteProcessor bp = new ByteProcessor(width, height);
            bp.setPixels((Object)luminancePixels[z]);
            luminanceStack.addSlice("", (ImageProcessor)bp);
            IJ.showProgress((double)((float)z / (float)depth));
        }
        ImagePlus result = new ImagePlus("luminance of " + colourImage.getTitle(), luminanceStack);
        result.setCalibration(calibration);
        IJ.showProgress((double)1.0);
        return result;
    }
}

