/*
 * Decompiled with CFR 0.152.
 */
package vib.segment;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import ij.gui.ImageLayout;
import ij.gui.Roi;
import ij.gui.StackWindow;
import ij.measure.Calibration;
import ij.plugin.filter.ThresholdToSelection;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import vib.BinaryInterpolator;
import vib.segment.CustomCanvas;
import vib.segment.Sidebar;
import vib.segment.Thresholder;

public class CustomStackWindow
extends StackWindow
implements AdjustmentListener,
KeyListener,
ActionListener,
MouseMotionListener,
MouseWheelListener {
    private Roi[] savedRois;
    private int oldSlice;
    private boolean roisLocked;
    private ActionListener al;
    private Sidebar sidebar;
    private CustomCanvas cc = (CustomCanvas)this.getCanvas();
    private Button ok;

    public CustomStackWindow(ImagePlus imp) {
        super(imp, (ImageCanvas)new CustomCanvas(imp));
        this.savedRois = new Roi[imp.getStack().getSize() + 1];
        if (this.sliceSelector == null) {
            this.sliceSelector = new Scrollbar(0, 1, 1, 1, 2);
        } else {
            this.sliceSelector.setValue(this.cc.getImage().getCurrentSlice());
        }
        this.oldSlice = this.sliceSelector.getValue();
        this.roisLocked = false;
        this.sliceSelector.addAdjustmentListener(this);
        this.cc.removeKeyListener((KeyListener)this.ij);
        this.cc.addKeyListener(this);
        this.cc.addMouseMotionListener(this);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        this.setBackground(Color.LIGHT_GRAY);
        this.remove(this.sliceSelector);
        this.remove((Component)((Object)this.cc));
        this.sidebar = new Sidebar(this.cc, this);
        c.anchor = 18;
        c.gridy = 0;
        c.gridx = 0;
        c.weightx = 0.0;
        c.weighty = 0.5;
        c.gridheight = 2;
        gridbag.setConstraints(this.sidebar, c);
        this.add(this.sidebar, c);
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        gridbag.setConstraints(this.sliceSelector, c);
        this.add(this.sliceSelector, c);
        Container slideAndImage = new Container();
        slideAndImage.setLayout((LayoutManager)new ImageLayout((ImageCanvas)this.cc));
        slideAndImage.add((Component)((Object)this.cc));
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.fill = 1;
        c.anchor = 10;
        gridbag.setConstraints(slideAndImage, c);
        this.add(slideAndImage, c);
        Panel buttonPanel = new Panel(new FlowLayout());
        this.ok = new Button("Ok");
        this.ok.addActionListener(this);
        buttonPanel.add(this.ok);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridwidth = 2;
        gridbag.setConstraints(buttonPanel, c);
        this.add(buttonPanel, c);
        this.pack();
        this.cc.requestFocus();
    }

    public void cleanUp() {
        this.roisLocked = false;
        this.savedRois = null;
        this.al = null;
        this.sidebar.getMaterials().labels = null;
        this.sidebar = null;
        this.ok = null;
        this.cc.releaseImage();
        this.cc = null;
        if (this.imp != null) {
            this.imp.close();
            this.imp = null;
        }
    }

    public ImagePlus getLabels() {
        return this.cc.getLabels();
    }

    public void setLabels(ImagePlus labels) {
        this.sidebar.setLabelImage(labels);
    }

    public void addActionListener(ActionListener al) {
        this.al = al;
    }

    public Sidebar getSidebar() {
        return this.sidebar;
    }

    public CustomCanvas getCustomCanvas() {
        return this.cc;
    }

    public Dimension getMinimumSize() {
        return this.getSize();
    }

    public void processPlusButton() {
        if (this.roisLocked) {
            return;
        }
        int currentSlice = this.cc.getImage().getCurrentSlice();
        Roi roi = this.cc.getImage().getRoi();
        this.assignSliceTo(currentSlice, roi, this.sidebar.currentMaterialID());
        this.cc.getImage().killRoi();
        if (this.sidebar.is3d()) {
            for (int i = 0; i < this.savedRois.length; ++i) {
                roi = this.savedRois[i];
                if (roi == null) continue;
                this.assignSliceTo(i, roi, this.sidebar.currentMaterialID());
                this.savedRois[i] = null;
            }
        }
        this.cc.getImage().setSlice(currentSlice);
        this.cc.getLabels().setSlice(currentSlice);
        this.cc.getImage().updateAndDraw();
        this.cc.getLabels().updateAndDraw();
        this.cc.requestFocus();
    }

    public void processMinusButton() {
        if (this.roisLocked) {
            return;
        }
        int currentSlice = this.cc.getImage().getCurrentSlice();
        Roi roi = this.cc.getImage().getRoi();
        this.releaseSliceFrom(currentSlice, roi, this.sidebar.currentMaterialID());
        this.cc.getImage().killRoi();
        if (this.sidebar.is3d()) {
            for (int i = 0; i < this.savedRois.length; ++i) {
                roi = this.savedRois[i];
                if (roi == null) continue;
                this.releaseSliceFrom(i, roi, this.sidebar.currentMaterialID());
                this.savedRois[i] = null;
            }
        }
        this.cc.getImage().setSlice(currentSlice);
        this.cc.getLabels().setSlice(currentSlice);
        this.cc.getImage().updateAndDraw();
        this.cc.getLabels().updateAndDraw();
        this.cc.requestFocus();
    }

    public void processInterpolateButton() {
        if (this.roisLocked) {
            return;
        }
        this.updateRois();
        this.roisLocked = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                CustomStackWindow.this.setCursor(3);
                new BinaryInterpolator().run(CustomStackWindow.this.cc.getImage(), CustomStackWindow.this.savedRois);
                CustomStackWindow.this.transferRois(CustomStackWindow.this.savedRois, true);
                CustomStackWindow.this.roisLocked = false;
                CustomStackWindow.this.setCursor(0);
            }
        }).start();
        this.cc.requestFocus();
    }

    public void processThresholdButton() {
        new Thresholder(this).run();
    }

    public void processCloseButton() {
        ImagePlus image = this.cc.getImage();
        ImageProcessor ip = image.getProcessor();
        ByteProcessor newip = new ByteProcessor(ip.getWidth(), ip.getHeight());
        newip.setBackgroundValue(0.0);
        newip.setRoi(image.getRoi());
        newip.setValue(255.0);
        newip.fill(newip.getMask());
        newip.dilate();
        newip.erode();
        newip.setThreshold(255.0, 255.0, 2);
        ImagePlus tmp = new ImagePlus(" ", (ImageProcessor)newip);
        ThresholdToSelection ts = new ThresholdToSelection();
        ts.setup("", tmp);
        ts.run((ImageProcessor)newip);
        newip.resetThreshold();
        image.setRoi(tmp.getRoi());
    }

    public void processOpenButton() {
        ImagePlus image = this.cc.getImage();
        ImageProcessor ip = image.getProcessor();
        ByteProcessor newip = new ByteProcessor(ip.getWidth(), ip.getHeight());
        newip.setBackgroundValue(0.0);
        newip.setRoi(image.getRoi());
        newip.setValue(255.0);
        newip.fill(newip.getMask());
        newip.erode();
        newip.dilate();
        newip.setThreshold(255.0, 255.0, 2);
        ImagePlus tmp = new ImagePlus(" ", (ImageProcessor)newip);
        ThresholdToSelection ts = new ThresholdToSelection();
        ts.setup("", tmp);
        ts.run((ImageProcessor)newip);
        newip.resetThreshold();
        image.setRoi(tmp.getRoi());
    }

    public void assignSliceTo(int slice, Roi roi, int materialID) {
        ImagePlus grey = this.cc.getImage();
        ImagePlus labels = this.cc.getLabels();
        if (grey == null || labels == null) {
            return;
        }
        if (roi == null) {
            return;
        }
        int w = labels.getWidth();
        int h = labels.getHeight();
        ImageProcessor labP = labels.getStack().getProcessor(slice);
        labP.setRoi(roi);
        Rectangle bounds = roi.getBounds();
        int x1 = bounds.x > 0 ? bounds.x : 0;
        int y1 = bounds.y > 0 ? bounds.y : 0;
        int x2 = bounds.x + bounds.width <= w ? bounds.x + bounds.width : w;
        int y2 = bounds.y + bounds.height <= h ? bounds.y + bounds.height : h;
        ImageProcessor maskP = roi.getMask();
        if (maskP == null) {
            for (int i = x1; i < x2; ++i) {
                for (int j = y1; j < y2; ++j) {
                    if (!roi.contains(i, j)) continue;
                    int oldID = labP.get(i, j);
                    if (this.sidebar.getMaterials().isLocked(oldID)) continue;
                    labP.set(i, j, materialID);
                }
            }
        } else {
            int maskX = (int)Math.round(roi.getBounds().getX());
            int maskY = (int)Math.round(roi.getBounds().getY());
            for (int i = x1; i < x2; ++i) {
                for (int j = y1; j < y2; ++j) {
                    if (maskP.get(i - maskX, j - maskY) != 255) continue;
                    int oldID = labP.get(i, j);
                    if (this.sidebar.getMaterials().isLocked(oldID)) continue;
                    labP.set(i, j, materialID);
                }
            }
        }
        this.cc.updateSlice(slice);
    }

    public void releaseSliceFrom(int slice, Roi roi, int materialID) {
        ImagePlus grey = this.cc.getImage();
        ImagePlus labels = this.cc.getLabels();
        if (grey == null || labels == null) {
            return;
        }
        if (roi == null) {
            return;
        }
        if (this.sidebar.getMaterials().isLocked(materialID)) {
            return;
        }
        int w = labels.getWidth();
        int h = labels.getHeight();
        ImageProcessor labP = labels.getStack().getProcessor(slice);
        labP.setRoi(roi);
        Rectangle bounds = roi.getBounds();
        int x1 = bounds.x > 0 ? bounds.x : 0;
        int y1 = bounds.y > 0 ? bounds.y : 0;
        int x2 = bounds.x + bounds.width <= w ? bounds.x + bounds.width : w;
        int y2 = bounds.y + bounds.height <= h ? bounds.y + bounds.height : h;
        int defaultMaterialID = this.sidebar.getMaterials().getDefaultMaterialID();
        ImageProcessor maskP = roi.getMask();
        if (maskP == null) {
            for (int i = x1; i < x2; ++i) {
                for (int j = y1; j < y2; ++j) {
                    if (!roi.contains(i, j) || labP.get(i, j) != materialID) continue;
                    labP.set(i, j, defaultMaterialID);
                }
            }
        } else {
            int maskX = (int)Math.round(roi.getBounds().getX());
            int maskY = (int)Math.round(roi.getBounds().getY());
            for (int i = x1; i < x2; ++i) {
                for (int j = y1; j < y2; ++j) {
                    if (maskP.get(i - maskX, j - maskY) != 255 || labP.get(i, j) != materialID) continue;
                    labP.set(i, j, defaultMaterialID);
                }
            }
        }
        this.cc.updateSlice(slice);
    }

    public boolean areAllRoisEmpty() {
        if (this.cc.getImage().getRoi() != null) {
            return false;
        }
        for (int i = 0; i < this.savedRois.length; ++i) {
            if (i == this.oldSlice || this.savedRois[i] == null) continue;
            return false;
        }
        return true;
    }

    public Roi getRoi(int slice) {
        if (slice == this.oldSlice) {
            return this.cc.getImage().getRoi();
        }
        return this.savedRois[slice];
    }

    public void transferRois(Roi[] rois) {
        this.transferRois(rois, false);
    }

    public void transferRois(Roi[] rois, boolean overrideLocking) {
        for (int i = 0; i < rois.length; ++i) {
            this.setRoi(i, rois[i], overrideLocking);
        }
    }

    public void setRoi(int slice, Roi roi) {
        this.setRoi(slice, roi, false);
    }

    public void setRoi(int slice, Roi roi, boolean overrideLocking) {
        if (this.roisLocked && !overrideLocking) {
            return;
        }
        if (slice != this.oldSlice) {
            this.savedRois[slice] = roi;
        } else if (roi == null) {
            this.cc.getImage().killRoi();
        } else {
            this.cc.getImage().setRoi(roi);
        }
    }

    public void setCurrentSlice(int slice) {
        this.cc.getImage().setSlice(slice + 1);
        this.updateRois(slice);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = this.cc.offScreenX(e.getX());
        int y = this.cc.offScreenY(e.getY());
        if (x < this.imp.getWidth() && y < this.imp.getHeight()) {
            Calibration cal = this.imp.getCalibration();
            double posX = cal.getX((double)x);
            posX = Double.valueOf(IJ.d2s((double)posX));
            double posY = cal.getY((double)y);
            posY = Double.valueOf(IJ.d2s((double)posY));
            int z = this.imp.getCurrentSlice() - 1;
            double posZ = cal.getZ((double)z);
            posZ = Double.valueOf(IJ.d2s((double)posZ));
            int voxelValue = this.imp.getProcessor().get(x, y);
            int materialID = this.cc.getLabels().getStack().getProcessor(z + 1).get(x, y);
            String materialName = this.sidebar.getMaterials().params.getMaterialName(materialID);
            IJ.showStatus((String)("x=" + posX + ", y=" + posY + ", z=" + posZ + ", value=" + voxelValue + ", material=" + materialName));
        }
    }

    public void paint(Graphics g) {
        this.drawInfo(g);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("zoomin")) {
            this.cc.zoomIn(this.cc.getWidth() / 2, this.cc.getHeight() / 2);
            this.cc.requestFocus();
        } else if (command.equals("zoomout")) {
            this.cc.zoomOut(this.cc.getWidth() / 2, this.cc.getHeight() / 2);
            this.cc.requestFocus();
        } else if (command.equals("plus")) {
            this.processPlusButton();
        } else if (command.equals("minus")) {
            this.processMinusButton();
        } else if (command.equals("interpolate")) {
            this.processInterpolateButton();
        } else if (command.equals("threshold")) {
            this.processThresholdButton();
        } else if (command.equals("open")) {
            this.processOpenButton();
        } else if (command.equals("close")) {
            this.processCloseButton();
        } else if (command.equals("Ok")) {
            if (this.al != null) {
                this.al.actionPerformed(e);
            }
            if (this.getImagePlus() != null) {
                new StackWindow(this.getImagePlus());
            }
        }
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        this.imp.setSlice(e.getValue());
        this.sliceSelector.setValue(e.getValue());
        this.updateRois();
    }

    public synchronized void updateRois() {
        this.updateRois(this.sliceSelector.getValue());
    }

    public synchronized void updateRois(int newSlice) {
        if (this.roisLocked) {
            return;
        }
        this.savedRois[this.oldSlice] = this.imp.getRoi();
        this.oldSlice = newSlice;
        if (this.savedRois[this.oldSlice] == null) {
            this.imp.killRoi();
        } else {
            this.imp.setRoi(this.savedRois[this.oldSlice]);
        }
        this.repaint();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        super.mouseWheelMoved(e);
        this.updateRois();
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int c = e.getKeyCode();
        char ch = e.getKeyChar();
        if (c == 40 || c == 39 || ch == '>') {
            int newSlice = this.clamp(this.oldSlice + 1);
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 1, newSlice));
        } else if (c == 38 || c == 37 || ch == '<') {
            int newSlice = this.clamp(this.oldSlice - 1);
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 2, newSlice));
        } else if (c == 33) {
            int newSlice = this.clamp(this.oldSlice - 5);
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 3, newSlice));
        } else if (c == 34) {
            int newSlice = this.clamp(this.oldSlice + 5);
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 4, newSlice));
        } else if (ch == '.') {
            int newSlice = this.nextRoiSlice();
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 4, newSlice));
        } else if (ch == ',') {
            int newSlice = this.prevRoiSlice();
            this.adjustmentValueChanged(new AdjustmentEvent(this.sliceSelector, 601, 4, newSlice));
        } else if (ch == '+' || ch == '=') {
            this.processPlusButton();
        } else if (ch == '-') {
            this.processMinusButton();
        } else if (ch == 'i') {
            this.processInterpolateButton();
        } else if (ch == 't') {
            this.processThresholdButton();
        } else if (ch == 'o') {
            this.processOpenButton();
        } else if (ch == 'c') {
            this.processCloseButton();
        }
    }

    protected int clamp(int targetSlice) {
        return targetSlice < 1 ? 1 : (targetSlice > this.cc.getImage().getNSlices() ? this.cc.getImage().getNSlices() : targetSlice);
    }

    protected int nextRoiSlice() {
        return this.findRoiSlice(1);
    }

    protected int prevRoiSlice() {
        return this.findRoiSlice(-1);
    }

    protected int findRoiSlice(int direction) {
        boolean found = false;
        int foundSlice = 0;
        for (int i = 1; i < this.savedRois.length; ++i) {
            if (i == this.oldSlice) {
                if (direction < 0) break;
                foundSlice = 0;
            }
            if (this.savedRois[i] == null) continue;
            foundSlice = i;
            if (i > this.oldSlice) break;
        }
        if (foundSlice == 0) {
            return this.oldSlice;
        }
        return foundSlice;
    }
}

