/*
 * Decompiled with CFR 0.152.
 */
package vib.transforms;

import math3d.Bookstein;
import math3d.Point3d;
import vib.transforms.Transform;

public class BooksteinTransform
extends Bookstein
implements Transform {
    protected Point3d[] originalPoints;
    protected Point3d[] transformedPoints;

    @Override
    public BooksteinTransform inverse() {
        return new BooksteinTransform(this.transformedPoints, this.originalPoints);
    }

    @Override
    public Transform composeWith(Transform t) {
        return null;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public int getTransformType() {
        return 0;
    }

    @Override
    public String toStringIndented(String indent) {
        return indent + "FIXME: implement this...\n";
    }

    public BooksteinTransform(Point3d[] orig, Point3d[] trans) {
        super(orig, trans);
        this.originalPoints = orig;
        this.transformedPoints = trans;
    }

    @Override
    public void apply(double x, double y, double z, double[] result) {
        Point3d p = new Point3d(x, y, z);
        result[0] = this.bx.evalInit(p);
        result[1] = this.by.evalInit(p);
        result[2] = this.bz.evalInit(p);
        for (int i = 0; i < this.points.length; ++i) {
            double u = BooksteinTransform.U(p.distanceTo(this.points[i]));
            result[0] = result[0] + this.bx.w[i] * u;
            result[1] = result[1] + this.by.w[i] * u;
            result[2] = result[2] + this.bz.w[i] * u;
        }
    }

    public void apply(double x, double y, double z) {
        this.apply(new Point3d(x, y, z));
    }
}

