/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.ThreddsMetadataContainer;
import thredds.client.catalog.builder.CatalogBuilder;
import thredds.client.catalog.builder.DatasetBuilder;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class ThreddsMetadata
implements ThreddsMetadataContainer {
    private static final Logger logger = LoggerFactory.getLogger(ThreddsMetadata.class);
    private final Map<String, Object> flds = new HashMap<String, Object>();
    private boolean immutable;

    public ThreddsMetadata() {
    }

    public ThreddsMetadata(ThreddsMetadata from) {
        for (Map.Entry<String, Object> entry : from.flds.entrySet()) {
            this.flds.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, Object> getFlds() {
        if (this.immutable) {
            throw new UnsupportedOperationException();
        }
        return this.flds;
    }

    public Iterable<Map.Entry<String, Object>> getFldIterator() {
        return this.flds.entrySet();
    }

    public void set(String fldName, Object fldValue) {
        if (this.immutable) {
            throw new UnsupportedOperationException();
        }
        if (fldValue != null) {
            this.flds.put(fldName, fldValue);
        } else {
            this.flds.remove(fldName);
        }
    }

    public void addToList(String fldName, Object fldValue) {
        if (this.immutable) {
            throw new UnsupportedOperationException();
        }
        if (fldValue != null) {
            DatasetBuilder.addToList(this.flds, fldName, fldValue);
        }
    }

    public void finish() {
        this.immutable = true;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public Object getLocalField(String fldName) {
        return this.flds.get(fldName);
    }

    @Override
    public List<Object> getLocalFieldAsList(String fldName) {
        Object value = this.flds.get(fldName);
        if (value != null) {
            if (value instanceof List) {
                return (List)value;
            }
            ArrayList<Object> result = new ArrayList<Object>(1);
            result.add(value);
            return result;
        }
        return new ArrayList<Object>(0);
    }

    @Immutable
    public static class MetadataOther {
        public final String title;
        public final String type;
        public final String xlinkHref;
        public final String namespaceURI;
        public final String prefix;
        public final boolean isInherited;
        public final Object contentObject;

        public MetadataOther(String xlinkHref, String title, String type, String namespaceURI, String prefix, boolean inherited) {
            this.xlinkHref = xlinkHref;
            this.title = title;
            this.type = type;
            this.namespaceURI = namespaceURI;
            this.prefix = prefix;
            this.isInherited = inherited;
            this.contentObject = null;
        }

        public MetadataOther(String mtype, String namespaceURI, String namespacePrefix, boolean inherited, Object contentObject) {
            this.xlinkHref = null;
            this.title = null;
            this.type = mtype;
            this.namespaceURI = namespaceURI;
            this.prefix = namespacePrefix;
            this.isInherited = inherited;
            this.contentObject = contentObject;
        }

        public boolean isInherited() {
            return this.isInherited;
        }

        public String getTitle() {
            return this.title;
        }

        public String getType() {
            return this.type;
        }

        public String getXlinkHref() {
            return this.xlinkHref;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Object getContentObject() {
            return this.contentObject;
        }
    }

    @Immutable
    public static class VariableGroup {
        public final String vocabulary;
        public final UriResolved vocabUri;
        public final UriResolved variableMap;
        public final List<Variable> variables;

        public VariableGroup(String vocab, UriResolved vocabUri, UriResolved variableMap, List<Variable> variables) {
            this.vocabulary = vocab;
            this.vocabUri = vocabUri;
            this.variableMap = variableMap;
            Collections.sort(variables);
            this.variables = Collections.unmodifiableList(variables);
        }

        public String getVocabulary() {
            return this.vocabulary;
        }

        public UriResolved getVocabUri() {
            return this.vocabUri;
        }

        public UriResolved getVariableMap() {
            return this.variableMap;
        }

        public List<Variable> getVariableList() {
            if (!this.variables.isEmpty()) {
                return this.variables;
            }
            if (this.variableMap != null) {
                return this.getVariablesFromMap();
            }
            return this.variables;
        }

        private List<Variable> getVariablesFromMap() {
            try {
                SAXBuilder saxBuilder = new SAXBuilder();
                saxBuilder.setExpandEntities(false);
                Document jdomDoc = saxBuilder.build(this.variableMap.resolved.toURL());
                Element varsElem = jdomDoc.getRootElement();
                List vlist = varsElem.getChildren("variable", Catalog.defNS);
                ArrayList<Variable> variables = new ArrayList<Variable>();
                for (Element e : vlist) {
                    variables.add(CatalogBuilder.readVariable(e));
                }
                return variables;
            }
            catch (Exception e) {
                logger.error("failed to read VariablesFromMap at {}", (Object)this.variableMap.resolved, (Object)e);
                return new ArrayList<Variable>(0);
            }
        }
    }

    @Immutable
    public static class UriResolved {
        public final String href;
        public final URI resolved;

        public UriResolved(String href, URI resolved) {
            this.href = href;
            this.resolved = resolved;
        }
    }

    @Immutable
    public static class Variable
    implements Comparable<Variable> {
        public final String name;
        public final String desc;
        public final String vocabulary_name;
        public final String units;
        public final String id;

        public Variable(String name, String desc, String vocabulary_name, String units, String id) {
            this.name = name;
            this.desc = desc;
            this.vocabulary_name = vocabulary_name;
            this.units = units;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getVocabularyName() {
            return this.vocabulary_name;
        }

        public String getVocabularyId() {
            return this.id;
        }

        public String getUnits() {
            return this.units;
        }

        @Override
        public int compareTo(Variable o) {
            return this.name.compareTo(o.name);
        }
    }

    @Immutable
    public static class GeospatialRange {
        public final double start;
        public final double size;
        public final double resolution;
        public final String units;

        public GeospatialRange(double start, double size, double resolution, String units) {
            this.start = start;
            this.size = size;
            this.resolution = resolution;
            this.units = units;
        }

        public GeospatialRange(GeospatialRange from) {
            this.start = from.start;
            this.size = from.size;
            this.resolution = from.resolution;
            this.units = from.units;
        }

        public double getStart() {
            return this.start;
        }

        public double getSize() {
            return this.size;
        }

        public double getResolution() {
            return this.resolution;
        }

        public String getUnits() {
            return this.units;
        }

        public boolean hasResolution() {
            return this.resolution != 0.0 && !Double.isNaN(this.resolution);
        }
    }

    @Immutable
    public static class GeospatialCoverage {
        public final GeospatialRange eastwest;
        public final GeospatialRange northsouth;
        public final GeospatialRange updown;
        public final boolean isGlobal;
        public final String zpositive;
        public final List<Vocab> names;

        public GeospatialCoverage(GeospatialRange eastwest, GeospatialRange northsouth, GeospatialRange updown, List<Vocab> names, String zpositive) {
            this.eastwest = eastwest;
            this.northsouth = northsouth;
            this.updown = updown;
            this.zpositive = zpositive != null ? zpositive : "up";
            this.names = names;
            boolean isGlobalCheck = false;
            if (names != null) {
                for (Vocab name : names) {
                    String elem = name.getText();
                    if (!elem.equalsIgnoreCase("global")) continue;
                    isGlobalCheck = true;
                }
            }
            this.isGlobal = isGlobalCheck;
        }

        public GeospatialCoverage(LatLonRect bb, CoordinateAxis1D vaxis, double dX, double dY) {
            if (bb == null) {
                this.eastwest = null;
                this.northsouth = null;
                this.isGlobal = false;
                this.names = null;
            } else {
                LatLonPointImpl llpt = bb.getLowerLeftPoint();
                LatLonPointImpl urpt = bb.getUpperRightPoint();
                double height = urpt.getLatitude() - llpt.getLatitude();
                this.eastwest = new GeospatialRange(llpt.getLongitude(), bb.getWidth(), dX, "degrees_east");
                this.northsouth = new GeospatialRange(llpt.getLatitude(), height, dY, "degrees_north");
                if (bb.getWidth() >= 360.0 - dX && height >= 180.0 - dY) {
                    this.isGlobal = true;
                    this.names = new ArrayList<Vocab>();
                    this.names.add(new Vocab("global", null));
                } else {
                    this.isGlobal = false;
                    this.names = null;
                }
            }
            if (vaxis == null) {
                this.updown = null;
                this.zpositive = null;
            } else {
                boolean isPositive;
                int n = (int)vaxis.getSize();
                double size = vaxis.getCoordValue(n - 1) - vaxis.getCoordValue(0);
                double resolution = vaxis.getIncrement();
                String units = vaxis.getUnitsString();
                this.updown = new GeospatialRange(vaxis.getCoordValue(0), size, resolution, units);
                this.zpositive = units != null ? ((isPositive = SimpleUnit.isCompatible("m", units)) ? "up" : "down") : "up";
            }
        }

        public GeospatialRange getEastWestRange() {
            return this.eastwest;
        }

        public GeospatialRange getNorthSouthRange() {
            return this.northsouth;
        }

        public GeospatialRange getUpDownRange() {
            return this.updown;
        }

        public List<Vocab> getNames() {
            return this.names != null ? this.names : new ArrayList<Vocab>();
        }

        public String getZPositive() {
            return this.zpositive;
        }

        public boolean isZPositiveUp() {
            return this.zpositive.equalsIgnoreCase("up");
        }

        public boolean isValid() {
            return this.isGlobal || this.eastwest != null && this.northsouth != null;
        }

        public boolean isGlobal() {
            return this.isGlobal;
        }

        public double getLatStart() {
            return this.northsouth == null ? Double.NaN : this.northsouth.start;
        }

        public double getLatExtent() {
            return this.northsouth == null ? Double.NaN : this.northsouth.size;
        }

        public double getLatResolution() {
            return this.northsouth == null ? Double.NaN : this.northsouth.resolution;
        }

        public String getLatUnits() {
            return this.northsouth == null ? null : this.northsouth.units;
        }

        public double getLatNorth() {
            return Math.max(this.northsouth.start, this.northsouth.start + this.northsouth.size);
        }

        public double getLatSouth() {
            return Math.min(this.northsouth.start, this.northsouth.start + this.northsouth.size);
        }

        public double getLonStart() {
            return this.eastwest == null ? Double.NaN : this.eastwest.start;
        }

        public double getLonExtent() {
            return this.eastwest == null ? Double.NaN : this.eastwest.size;
        }

        public double getLonResolution() {
            return this.eastwest == null ? Double.NaN : this.eastwest.resolution;
        }

        public String getLonUnits() {
            return this.eastwest == null ? null : this.eastwest.units;
        }

        public double getLonEast() {
            if (this.eastwest == null) {
                return Double.NaN;
            }
            return Math.max(this.eastwest.start, this.eastwest.start + this.eastwest.size);
        }

        public double getLonWest() {
            if (this.eastwest == null) {
                return Double.NaN;
            }
            return Math.min(this.eastwest.start, this.eastwest.start + this.eastwest.size);
        }

        public double getHeightStart() {
            return this.updown == null ? 0.0 : this.updown.start;
        }

        public double getHeightExtent() {
            return this.updown == null ? 0.0 : this.updown.size;
        }

        public double getHeightResolution() {
            return this.updown == null ? 0.0 : this.updown.resolution;
        }

        public String getHeightUnits() {
            return this.updown == null ? null : this.updown.units;
        }

        public LatLonRect getBoundingBox() {
            return this.isGlobal ? new LatLonRect() : new LatLonRect(LatLonPoint.create(this.getLatStart(), this.getLonStart()), this.getLatExtent(), this.getLonExtent());
        }
    }

    @Immutable
    public static class Vocab {
        public final String text;
        public final String vocabulary;

        public Vocab(String text, String vocabulary) {
            this.text = text;
            this.vocabulary = vocabulary;
        }

        public String getText() {
            return this.text;
        }

        public String getVocabulary() {
            return this.vocabulary;
        }
    }

    @Immutable
    public static class Source {
        public final Vocab name;
        public final String url;
        public final String email;

        public Source(Vocab name, String url, String email) {
            this.name = name;
            this.url = url;
            this.email = email;
        }

        public Vocab getNameVocab() {
            return this.name;
        }

        public String getName() {
            return this.name.getText();
        }

        public String getUrl() {
            return this.url;
        }

        public String getEmail() {
            return this.email;
        }

        public String getVocabulary() {
            return this.name.getVocabulary();
        }
    }

    @Immutable
    public static class Contributor {
        public final String name;
        public final String role;

        public Contributor(String name, String role) {
            this.name = name;
            this.role = role;
        }

        public String getName() {
            return this.name;
        }

        public String getRole() {
            return this.role;
        }
    }
}

