/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionChangeEvent;
import fiji.plugin.trackmate.SelectionChangeListener;
import fiji.plugin.trackmate.Spot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.traverse.GraphIterator;

public class SelectionModel {
    private static final boolean DEBUG = false;
    private final Set<Spot> spotSelection = new HashSet<Spot>();
    private final Set<DefaultWeightedEdge> edgeSelection = new HashSet<DefaultWeightedEdge>();
    private final List<SelectionChangeListener> selectionChangeListeners = new ArrayList<SelectionChangeListener>();
    private final Model model;

    public SelectionModel(Model parent) {
        this.model = parent;
    }

    public boolean addSelectionChangeListener(SelectionChangeListener listener) {
        return this.selectionChangeListeners.add(listener);
    }

    public boolean removeSelectionChangeListener(SelectionChangeListener listener) {
        return this.selectionChangeListeners.remove(listener);
    }

    public List<SelectionChangeListener> getSelectionChangeListener() {
        return this.selectionChangeListeners;
    }

    public void clearSelection() {
        HashMap<Spot, Boolean> spotMap = new HashMap<Spot, Boolean>(this.spotSelection.size());
        for (Spot spot : this.spotSelection) {
            spotMap.put(spot, false);
        }
        HashMap<DefaultWeightedEdge, Boolean> edgeMap = new HashMap<DefaultWeightedEdge, Boolean>(this.edgeSelection.size());
        for (DefaultWeightedEdge edge : this.edgeSelection) {
            edgeMap.put(edge, false);
        }
        SelectionChangeEvent selectionChangeEvent = new SelectionChangeEvent(this, spotMap, edgeMap);
        this.clearSpotSelection();
        this.clearEdgeSelection();
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(selectionChangeEvent);
        }
    }

    public void clearSpotSelection() {
        HashMap<Spot, Boolean> spotMap = new HashMap<Spot, Boolean>(this.spotSelection.size());
        for (Spot spot : this.spotSelection) {
            spotMap.put(spot, false);
        }
        SelectionChangeEvent event = new SelectionChangeEvent(this, spotMap, null);
        this.spotSelection.clear();
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void clearEdgeSelection() {
        HashMap<DefaultWeightedEdge, Boolean> edgeMap = new HashMap<DefaultWeightedEdge, Boolean>(this.edgeSelection.size());
        for (DefaultWeightedEdge edge : this.edgeSelection) {
            edgeMap.put(edge, false);
        }
        SelectionChangeEvent event = new SelectionChangeEvent(this, null, edgeMap);
        this.edgeSelection.clear();
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addSpotToSelection(Spot spot) {
        if (!this.spotSelection.add(spot)) {
            return;
        }
        HashMap<Spot, Boolean> spotMap = new HashMap<Spot, Boolean>(1);
        spotMap.put(spot, true);
        SelectionChangeEvent event = new SelectionChangeEvent(this, spotMap, null);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void removeSpotFromSelection(Spot spot) {
        if (!this.spotSelection.remove(spot)) {
            return;
        }
        HashMap<Spot, Boolean> spotMap = new HashMap<Spot, Boolean>(1);
        spotMap.put(spot, false);
        SelectionChangeEvent event = new SelectionChangeEvent(this, spotMap, null);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addSpotToSelection(Collection<Spot> spots) {
        HashMap<Spot, Boolean> spotMap = new HashMap<Spot, Boolean>(spots.size());
        for (Spot spot : spots) {
            if (!this.spotSelection.add(spot)) continue;
            spotMap.put(spot, true);
        }
        SelectionChangeEvent event = new SelectionChangeEvent(this, spotMap, null);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void removeSpotFromSelection(Collection<Spot> spots) {
        HashMap<Spot, Boolean> spotMap = new HashMap<Spot, Boolean>(spots.size());
        for (Spot spot : spots) {
            if (!this.spotSelection.remove(spot)) continue;
            spotMap.put(spot, false);
        }
        SelectionChangeEvent event = new SelectionChangeEvent(this, spotMap, null);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addEdgeToSelection(DefaultWeightedEdge edge) {
        if (!this.edgeSelection.add(edge)) {
            return;
        }
        HashMap<DefaultWeightedEdge, Boolean> edgeMap = new HashMap<DefaultWeightedEdge, Boolean>(1);
        edgeMap.put(edge, true);
        SelectionChangeEvent event = new SelectionChangeEvent(this, null, edgeMap);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void removeEdgeFromSelection(DefaultWeightedEdge edge) {
        if (!this.edgeSelection.remove(edge)) {
            return;
        }
        HashMap<DefaultWeightedEdge, Boolean> edgeMap = new HashMap<DefaultWeightedEdge, Boolean>(1);
        edgeMap.put(edge, false);
        SelectionChangeEvent event = new SelectionChangeEvent(this, null, edgeMap);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void addEdgeToSelection(Collection<DefaultWeightedEdge> edges) {
        HashMap<DefaultWeightedEdge, Boolean> edgeMap = new HashMap<DefaultWeightedEdge, Boolean>(edges.size());
        for (DefaultWeightedEdge edge : edges) {
            if (!this.edgeSelection.add(edge)) continue;
            edgeMap.put(edge, true);
        }
        SelectionChangeEvent event = new SelectionChangeEvent(this, null, edgeMap);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public void removeEdgeFromSelection(Collection<DefaultWeightedEdge> edges) {
        HashMap<DefaultWeightedEdge, Boolean> edgeMap = new HashMap<DefaultWeightedEdge, Boolean>(edges.size());
        for (DefaultWeightedEdge edge : edges) {
            if (!this.edgeSelection.remove(edge)) continue;
            edgeMap.put(edge, false);
        }
        SelectionChangeEvent event = new SelectionChangeEvent(this, null, edgeMap);
        for (SelectionChangeListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(event);
        }
    }

    public Set<Spot> getSpotSelection() {
        return this.spotSelection;
    }

    public Set<DefaultWeightedEdge> getEdgeSelection() {
        return this.edgeSelection;
    }

    public void selectTrack(Collection<Spot> spots, Collection<DefaultWeightedEdge> edges, int direction) {
        HashSet<Spot> inspectionSpots = new HashSet<Spot>(spots);
        for (DefaultWeightedEdge edge : edges) {
            inspectionSpots.add(this.model.getTrackModel().getEdgeSource(edge));
            inspectionSpots.add(this.model.getTrackModel().getEdgeTarget(edge));
        }
        HashSet<Spot> lSpotSelection = new HashSet<Spot>();
        HashSet<DefaultWeightedEdge> lEdgeSelection = new HashSet<DefaultWeightedEdge>();
        if (direction == 0) {
            for (Spot spot : inspectionSpots) {
                lSpotSelection.add(spot);
                GraphIterator<Spot, DefaultWeightedEdge> walker = this.model.getTrackModel().getDepthFirstIterator(spot, false);
                while (walker.hasNext()) {
                    Spot target = (Spot)walker.next();
                    lSpotSelection.add(target);
                    targetEdges = this.model.getTrackModel().edgesOf(target);
                    for (DefaultWeightedEdge targetEdge : targetEdges) {
                        lEdgeSelection.add(targetEdge);
                    }
                }
            }
        } else {
            for (Spot spot : inspectionSpots) {
                lSpotSelection.add(spot);
                Stack<Spot> stack = new Stack<Spot>();
                stack.add(spot);
                while (!stack.isEmpty()) {
                    Spot inspected = (Spot)stack.pop();
                    targetEdges = this.model.getTrackModel().edgesOf(inspected);
                    for (DefaultWeightedEdge targetEdge : targetEdges) {
                        Spot other = direction > 0 ? this.model.getTrackModel().getEdgeSource(targetEdge) : this.model.getTrackModel().getEdgeTarget(targetEdge);
                        if (other == inspected) continue;
                        lSpotSelection.add(other);
                        lEdgeSelection.add(targetEdge);
                        stack.add(other);
                    }
                }
            }
        }
        ArrayList<DefaultWeightedEdge> edgesToRemove = new ArrayList<DefaultWeightedEdge>();
        for (DefaultWeightedEdge edge : lEdgeSelection) {
            Spot source = this.model.getTrackModel().getEdgeSource(edge);
            Spot target = this.model.getTrackModel().getEdgeTarget(edge);
            if (lSpotSelection.contains(source) && lSpotSelection.contains(target)) continue;
            edgesToRemove.add(edge);
        }
        lEdgeSelection.removeAll(edgesToRemove);
        this.addSpotToSelection(lSpotSelection);
        this.addEdgeToSelection(lEdgeSelection);
    }
}

